/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.mapper.mapping.building.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.mapper.mapping.building.impl.DepthFilter;
import org.hibernate.search.engine.mapper.mapping.building.impl.PathFilter;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEmbeddedDefinition;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEmbeddedPathTracker;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class IndexSchemaFilter {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final IndexSchemaFilter ROOT = new IndexSchemaFilter(null, null, null, DepthFilter.unconstrained(), PathFilter.unconstrained());
    private final IndexSchemaFilter parent;
    private final IndexedEmbeddedDefinition definition;
    private final IndexedEmbeddedPathTracker pathTracker;
    private final DepthFilter depthFilter;
    private final PathFilter pathFilter;

    public static IndexSchemaFilter root() {
        return ROOT;
    }

    private IndexSchemaFilter(IndexSchemaFilter parent, IndexedEmbeddedDefinition definition, IndexedEmbeddedPathTracker pathTracker, DepthFilter depthFilter, PathFilter pathFilter) {
        this.parent = parent;
        this.definition = definition;
        this.pathTracker = pathTracker;
        this.depthFilter = depthFilter;
        this.pathFilter = pathFilter;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "depthFilter=" + this.depthFilter + ",pathFilter=" + this.pathFilter + ",parent=" + this.parent + "]";
    }

    public boolean isPathIncluded(String relativePath) {
        return this.isPathIncludedInternal(0, relativePath, true, true);
    }

    private boolean isPathIncludedInternal(int relativeDepth, String relativePath, boolean markAsEncountered, boolean includedByChild) {
        boolean included;
        boolean includedByThis = this.depthFilter.isEveryPathIncludedAtDepth(relativeDepth) || this.pathFilter.isExplicitlyIncluded(relativePath);
        boolean includedByParent = true;
        if (this.parent != null) {
            includedByParent = this.parent.isPathIncludedInternal(relativeDepth + 1, this.definition.relativePrefix() + relativePath, markAsEncountered, includedByThis);
        }
        boolean bl = included = includedByParent && includedByThis;
        if (markAsEncountered && this.pathTracker != null) {
            this.pathTracker.markAsEncountered(relativePath, includedByThis && includedByChild);
        }
        return included;
    }

    boolean isEveryPathExcluded() {
        return !this.isEveryPathIncludedAtDepth(0) && !this.isAnyPathExplicitlyIncluded("", this);
    }

    private boolean isAnyPathExplicitlyIncluded(String prefixToRemove, IndexSchemaFilter filter) {
        if (this.definition == null) {
            return false;
        }
        int prefixLength = prefixToRemove.length();
        for (String path : this.definition.includePaths()) {
            String pathWithoutPrefix;
            if (!path.startsWith(prefixToRemove) || !filter.isPathIncludedInternal(0, pathWithoutPrefix = path.substring(prefixLength), false, true)) continue;
            return true;
        }
        return this.parent != null && this.parent.isAnyPathExplicitlyIncluded(this.definition.relativePrefix() + prefixToRemove, filter);
    }

    private boolean isEveryPathIncludedAtDepth(int depth) {
        return this.depthFilter.isEveryPathIncludedAtDepth(depth) && (this.parent == null || this.parent.isEveryPathIncludedAtDepth(depth + 1));
    }

    private String getPathFromSameIndexedEmbeddedSinceNoCompositionLimits(IndexedEmbeddedDefinition definition) {
        if (this.hasCompositionLimits()) {
            return null;
        }
        if (this.parent != null) {
            if (this.definition.equals(definition)) {
                return this.definition.relativePrefix();
            }
            String path = this.parent.getPathFromSameIndexedEmbeddedSinceNoCompositionLimits(definition);
            return path == null ? null : path + this.definition.relativePrefix();
        }
        return null;
    }

    public IndexSchemaFilter compose(IndexedEmbeddedDefinition definition, IndexedEmbeddedPathTracker pathTracker) {
        String cyclicRecursionPath = this.getPathFromSameIndexedEmbeddedSinceNoCompositionLimits(definition);
        if (cyclicRecursionPath != null) {
            cyclicRecursionPath = cyclicRecursionPath + definition.relativePrefix();
            throw log.indexedEmbeddedCyclicRecursion(cyclicRecursionPath, definition.definingTypeModel());
        }
        DepthFilter newDepthFilter = DepthFilter.of(definition.includeDepth());
        PathFilter newPathFilter = PathFilter.of(definition.includePaths());
        return new IndexSchemaFilter(this, definition, pathTracker, newDepthFilter, newPathFilter);
    }

    private boolean hasCompositionLimits() {
        return this.depthFilter.hasDepthLimit() || this.pathFilter.isAnyPathExplicitlyIncluded() || this.parent != null && this.parent.hasCompositionLimits();
    }
}

