/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp.traces;

import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.otlp.InstrumentationLibraryMarshaler;
import io.opentelemetry.exporter.internal.otlp.traces.SpanMarshaler;
import io.opentelemetry.proto.trace.v1.internal.InstrumentationLibrarySpans;
import java.io.IOException;
import java.util.List;

final class InstrumentationLibrarySpansMarshaler
extends MarshalerWithSize {
    private final InstrumentationLibraryMarshaler instrumentationLibrary;
    private final List<SpanMarshaler> spanMarshalers;
    private final byte[] schemaUrlUtf8;

    InstrumentationLibrarySpansMarshaler(InstrumentationLibraryMarshaler instrumentationLibrary, byte[] schemaUrlUtf8, List<SpanMarshaler> spanMarshalers) {
        super(InstrumentationLibrarySpansMarshaler.calculateSize(instrumentationLibrary, schemaUrlUtf8, spanMarshalers));
        this.instrumentationLibrary = instrumentationLibrary;
        this.schemaUrlUtf8 = schemaUrlUtf8;
        this.spanMarshalers = spanMarshalers;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeMessage(InstrumentationLibrarySpans.INSTRUMENTATION_LIBRARY, this.instrumentationLibrary);
        output.serializeRepeatedMessage(InstrumentationLibrarySpans.SPANS, this.spanMarshalers);
        output.serializeString(InstrumentationLibrarySpans.SCHEMA_URL, this.schemaUrlUtf8);
    }

    private static int calculateSize(InstrumentationLibraryMarshaler instrumentationLibrary, byte[] schemaUrlUtf8, List<SpanMarshaler> spanMarshalers) {
        int size = 0;
        size += MarshalerUtil.sizeMessage(InstrumentationLibrarySpans.INSTRUMENTATION_LIBRARY, instrumentationLibrary);
        size += MarshalerUtil.sizeBytes(InstrumentationLibrarySpans.SCHEMA_URL, schemaUrlUtf8);
        return size += MarshalerUtil.sizeRepeatedMessage(InstrumentationLibrarySpans.SPANS, spanMarshalers);
    }
}

