/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.messaging.activemq.JGroupsDiscoveryGroupRemove;
import org.wildfly.extension.messaging.activemq.SocketDiscoveryGroupRemove;

public class DiscoveryGroupRemove
extends AbstractRemoveStepHandler {
    public static final DiscoveryGroupRemove INSTANCE = new DiscoveryGroupRemove(false);
    public static final DiscoveryGroupRemove LEGACY_INSTANCE = new DiscoveryGroupRemove(true);
    private final boolean isLegacyCall;

    private DiscoveryGroupRemove(boolean isLegacyCall) {
        this.isLegacyCall = isLegacyCall;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (!this.isLegacyCall) {
            ReloadRequiredRemoveStepHandler removeHandler;
            ModelNode op = operation.clone();
            PathAddress target = context.getCurrentAddress().getParent();
            try {
                context.readResourceFromRoot(target.append("jgroups-discovery-group", context.getCurrentAddressValue()), false);
                target = target.append("jgroups-discovery-group", context.getCurrentAddressValue());
                removeHandler = JGroupsDiscoveryGroupRemove.LEGACY_INSTANCE;
            }
            catch (Resource.NoSuchResourceException ex) {
                target = target.append("socket-discovery-group", context.getCurrentAddressValue());
                removeHandler = SocketDiscoveryGroupRemove.LEGACY_INSTANCE;
            }
            op.get("address").set(target.toModelNode());
            context.addStep(op, (OperationStepHandler)removeHandler, OperationContext.Stage.MODEL, true);
        }
        super.execute(context, operation);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        context.reloadRequired();
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        context.revertReloadRequired();
    }
}

