/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.wsc11.messaging;

import com.arjuna.webservices.SoapFaultType;
import com.arjuna.webservices.logging.WSCLogger;
import com.arjuna.webservices11.wsarj.ArjunaContext;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wscoor.CoordinationConstants;
import com.arjuna.webservices11.wscoor.processors.RegistrationCoordinatorProcessor;
import com.arjuna.wsc.AlreadyRegisteredException;
import com.arjuna.wsc.InvalidProtocolException;
import com.arjuna.wsc.InvalidStateException;
import com.arjuna.wsc.NoActivityException;
import com.arjuna.wsc11.Registrar;
import com.arjuna.wsc11.RegistrarMapper;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFactory;
import jakarta.xml.soap.SOAPFault;
import jakarta.xml.ws.ProtocolException;
import jakarta.xml.ws.soap.SOAPFaultException;
import jakarta.xml.ws.wsaddressing.W3CEndpointReference;
import org.jboss.ws.api.addressing.MAP;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.RegisterResponseType;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.RegisterType;

public class RegistrationCoordinatorProcessorImpl
extends RegistrationCoordinatorProcessor {
    @Override
    public RegisterResponseType register(RegisterType register, MAP map, ArjunaContext arjunaContext, boolean isSecure) {
        RegistrarMapper registrarMapper = RegistrarMapper.getFactory();
        try {
            String protocolIdentifier = register.getProtocolIdentifier();
            Registrar registrar = registrarMapper.getRegistrar(protocolIdentifier);
            if (registrar != null) {
                try {
                    W3CEndpointReference participantProtocolService = register.getParticipantProtocolService();
                    InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
                    W3CEndpointReference coordinationProtocolService = registrar.register(participantProtocolService, protocolIdentifier, instanceIdentifier, isSecure);
                    RegisterResponseType response = new RegisterResponseType();
                    response.setCoordinatorProtocolService(coordinationProtocolService);
                    return response;
                }
                catch (AlreadyRegisteredException alreadyRegisteredException) {
                    if (WSCLogger.logger.isTraceEnabled()) {
                        WSCLogger.logger.tracev((Throwable)alreadyRegisteredException, "{0}, of protocol {1}, of instance {2}", (Object)WSCLogger.i18NLogger.get_wsc11_messaging_RegistrationCoordinatorProcessorImpl_1(), (Object)protocolIdentifier, (Object)arjunaContext.getInstanceIdentifier());
                    }
                    SOAPFactory factory = SOAPFactory.newInstance();
                    SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_SENDER.getValue(), CoordinationConstants.WSCOOR_ERROR_CODE_CANNOT_REGISTER_QNAME);
                    soapFault.addDetail().addDetailEntry(CoordinationConstants.WSCOOR_ERROR_CODE_CANNOT_REGISTER_QNAME).addTextNode(WSCLogger.i18NLogger.get_wsc11_messaging_RegistrationCoordinatorProcessorImpl_1());
                    throw new SOAPFaultException(soapFault);
                }
                catch (InvalidProtocolException invalidProtocolException) {
                    if (WSCLogger.logger.isTraceEnabled()) {
                        WSCLogger.logger.tracev((Throwable)invalidProtocolException, "{0}, of protocol {1}, of instance {2}", (Object)WSCLogger.i18NLogger.get_wsc11_messaging_RegistrationCoordinatorProcessorImpl_2(), (Object)protocolIdentifier, (Object)arjunaContext.getInstanceIdentifier());
                    }
                    SOAPFactory factory = SOAPFactory.newInstance();
                    SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_SENDER.getValue(), CoordinationConstants.WSCOOR_ERROR_CODE_INVALID_PROTOCOL_QNAME);
                    soapFault.addDetail().addDetailEntry(CoordinationConstants.WSCOOR_ERROR_CODE_INVALID_PARAMETERS_QNAME).addTextNode(WSCLogger.i18NLogger.get_wsc11_messaging_RegistrationCoordinatorProcessorImpl_2());
                    throw new SOAPFaultException(soapFault);
                }
                catch (InvalidStateException invalidStateException) {
                    if (WSCLogger.logger.isTraceEnabled()) {
                        WSCLogger.logger.tracev((Throwable)invalidStateException, "{0}, of protocol {1}, of instance {2}", (Object)WSCLogger.i18NLogger.get_wsc11_messaging_RegistrationCoordinatorProcessorImpl_3(), (Object)protocolIdentifier, (Object)arjunaContext.getInstanceIdentifier());
                    }
                    SOAPFactory factory = SOAPFactory.newInstance();
                    SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_SENDER.getValue(), CoordinationConstants.WSCOOR_ERROR_CODE_INVALID_STATE_QNAME);
                    soapFault.addDetail().addDetailEntry(CoordinationConstants.WSCOOR_ERROR_CODE_INVALID_STATE_QNAME).addTextNode(WSCLogger.i18NLogger.get_wsc11_messaging_RegistrationCoordinatorProcessorImpl_3());
                    throw new SOAPFaultException(soapFault);
                }
                catch (NoActivityException noActivityException) {
                    if (WSCLogger.logger.isTraceEnabled()) {
                        WSCLogger.logger.tracev((Throwable)noActivityException, "{0}, of protocol {1}, of instance {2}", (Object)WSCLogger.i18NLogger.get_wsc11_messaging_RegistrationCoordinatorProcessorImpl_4(), (Object)protocolIdentifier, (Object)arjunaContext.getInstanceIdentifier());
                    }
                    SOAPFactory factory = SOAPFactory.newInstance();
                    SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_SENDER.getValue(), CoordinationConstants.WSCOOR_ERROR_CODE_CANNOT_REGISTER_QNAME);
                    soapFault.addDetail().addDetailEntry(CoordinationConstants.WSCOOR_ERROR_CODE_CANNOT_REGISTER_QNAME).addTextNode(WSCLogger.i18NLogger.get_wsc11_messaging_RegistrationCoordinatorProcessorImpl_4());
                    throw new SOAPFaultException(soapFault);
                }
                catch (Throwable th) {
                    if (WSCLogger.logger.isTraceEnabled()) {
                        WSCLogger.logger.tracev(th, "Unexpected exception thrown from create: protocol {1}, identifier {2}", (Object)protocolIdentifier, (Object)(arjunaContext == null ? null : arjunaContext.getInstanceIdentifier()));
                    }
                    SOAPFactory factory = SOAPFactory.newInstance();
                    SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_SENDER.getValue(), CoordinationConstants.WSCOOR_ERROR_CODE_CANNOT_REGISTER_QNAME);
                    soapFault.addDetail().addDetailEntry(CoordinationConstants.WSCOOR_ERROR_CODE_CANNOT_REGISTER_QNAME).addTextNode(th.getMessage());
                    throw new SOAPFaultException(soapFault);
                }
            }
            if (WSCLogger.logger.isTraceEnabled()) {
                WSCLogger.logger.tracev("Register called for unknown protocol identifier: {0} [{1}]", (Object)protocolIdentifier, (Object)WSCLogger.i18NLogger.get_wsc11_messaging_RegistrationCoordinatorProcessorImpl_2());
            }
            SOAPFactory factory = SOAPFactory.newInstance();
            SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_SENDER.getValue(), CoordinationConstants.WSCOOR_ERROR_CODE_INVALID_PROTOCOL_QNAME);
            soapFault.addDetail().addDetailEntry(CoordinationConstants.WSCOOR_ERROR_CODE_INVALID_PARAMETERS_QNAME).addTextNode(WSCLogger.i18NLogger.get_wsc11_messaging_RegistrationCoordinatorProcessorImpl_2());
            throw new SOAPFaultException(soapFault);
        }
        catch (SOAPException se) {
            WSCLogger.i18NLogger.error_failure_to_register_protocol(register == null ? null : register.getProtocolIdentifier(), arjunaContext == null ? null : arjunaContext.getInstanceIdentifier(), se);
            throw new ProtocolException((Throwable)se);
        }
    }
}

