/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.config.impl;

import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionAddressType;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPMirrorBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.XMLUtil;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConfigurationValidationTest
extends ActiveMQTestBase {
    @Test
    public void testMinimalConfiguration() throws Exception {
        String xml = "<core xmlns='urn:activemq:core'></core>";
        Element element = XMLUtil.stringToElement((String)xml);
        Assert.assertNotNull((Object)element);
        XMLUtil.validate((Node)element, (String)"schema/artemis-configuration.xsd");
    }

    @Test
    public void testFullConfiguration() throws Exception {
        FileConfiguration fc = new FileConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager("ConfigurationTest-full-config.xml");
        deploymentManager.addDeployable((Deployable)fc);
        deploymentManager.readConfiguration();
        Assert.assertEquals((Object)true, (Object)fc.isPersistDeliveryCountBeforeDelivery());
    }

    @Test
    public void testAMQPConnectParsing() throws Exception {
        FileConfiguration fc = new FileConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager("ConfigurationTest-full-config.xml");
        deploymentManager.addDeployable((Deployable)fc);
        deploymentManager.readConfiguration();
        Assert.assertEquals((long)3L, (long)fc.getAMQPConnection().size());
        AMQPBrokerConnectConfiguration amqpBrokerConnectConfiguration = (AMQPBrokerConnectConfiguration)fc.getAMQPConnection().get(0);
        Assert.assertEquals((Object)"testuser", (Object)amqpBrokerConnectConfiguration.getUser());
        Assert.assertEquals((Object)"testpassword", (Object)amqpBrokerConnectConfiguration.getPassword());
        Assert.assertEquals((long)33L, (long)amqpBrokerConnectConfiguration.getReconnectAttempts());
        Assert.assertEquals((long)333L, (long)amqpBrokerConnectConfiguration.getRetryInterval());
        Assert.assertEquals((Object)"test1", (Object)amqpBrokerConnectConfiguration.getName());
        Assert.assertEquals((Object)"tcp://test1:111", (Object)amqpBrokerConnectConfiguration.getUri());
        Assert.assertEquals((Object)"TEST-SENDER", (Object)((AMQPBrokerConnectionElement)amqpBrokerConnectConfiguration.getConnectionElements().get(0)).getMatchAddress().toString());
        Assert.assertEquals((Object)AMQPBrokerConnectionAddressType.SENDER, (Object)((AMQPBrokerConnectionElement)amqpBrokerConnectConfiguration.getConnectionElements().get(0)).getType());
        Assert.assertEquals((Object)"TEST-RECEIVER", (Object)((AMQPBrokerConnectionElement)amqpBrokerConnectConfiguration.getConnectionElements().get(1)).getMatchAddress().toString());
        Assert.assertEquals((Object)AMQPBrokerConnectionAddressType.RECEIVER, (Object)((AMQPBrokerConnectionElement)amqpBrokerConnectConfiguration.getConnectionElements().get(1)).getType());
        Assert.assertEquals((Object)"TEST-PEER", (Object)((AMQPBrokerConnectionElement)amqpBrokerConnectConfiguration.getConnectionElements().get(2)).getMatchAddress().toString());
        Assert.assertEquals((Object)AMQPBrokerConnectionAddressType.PEER, (Object)((AMQPBrokerConnectionElement)amqpBrokerConnectConfiguration.getConnectionElements().get(2)).getType());
        Assert.assertEquals((Object)"TEST-WITH-QUEUE-NAME", (Object)((AMQPBrokerConnectionElement)amqpBrokerConnectConfiguration.getConnectionElements().get(3)).getQueueName().toString());
        Assert.assertEquals(null, (Object)((AMQPBrokerConnectionElement)amqpBrokerConnectConfiguration.getConnectionElements().get(3)).getMatchAddress());
        Assert.assertEquals((Object)AMQPBrokerConnectionAddressType.RECEIVER, (Object)((AMQPBrokerConnectionElement)amqpBrokerConnectConfiguration.getConnectionElements().get(3)).getType());
        Assert.assertEquals((Object)AMQPBrokerConnectionAddressType.MIRROR, (Object)((AMQPBrokerConnectionElement)amqpBrokerConnectConfiguration.getConnectionElements().get(4)).getType());
        AMQPMirrorBrokerConnectionElement mirrorConnectionElement = (AMQPMirrorBrokerConnectionElement)amqpBrokerConnectConfiguration.getConnectionElements().get(4);
        Assert.assertFalse((boolean)mirrorConnectionElement.isMessageAcknowledgements());
        Assert.assertFalse((boolean)mirrorConnectionElement.isQueueCreation());
        Assert.assertFalse((boolean)mirrorConnectionElement.isQueueRemoval());
        Assert.assertFalse((boolean)mirrorConnectionElement.isDurable());
        amqpBrokerConnectConfiguration = (AMQPBrokerConnectConfiguration)fc.getAMQPConnection().get(1);
        Assert.assertEquals(null, (Object)amqpBrokerConnectConfiguration.getUser());
        mirrorConnectionElement = (AMQPMirrorBrokerConnectionElement)amqpBrokerConnectConfiguration.getConnectionElements().get(0);
        Assert.assertEquals(null, (Object)amqpBrokerConnectConfiguration.getPassword());
        Assert.assertEquals((Object)"test2", (Object)amqpBrokerConnectConfiguration.getName());
        Assert.assertEquals((Object)"tcp://test2:222", (Object)amqpBrokerConnectConfiguration.getUri());
        Assert.assertTrue((boolean)mirrorConnectionElement.isMessageAcknowledgements());
        Assert.assertFalse((boolean)mirrorConnectionElement.isDurable());
        Assert.assertTrue((boolean)mirrorConnectionElement.isQueueCreation());
        Assert.assertTrue((boolean)mirrorConnectionElement.isQueueRemoval());
        amqpBrokerConnectConfiguration = (AMQPBrokerConnectConfiguration)fc.getAMQPConnection().get(2);
        Assert.assertFalse((boolean)amqpBrokerConnectConfiguration.isAutostart());
    }

    @Test
    public void testChangeConfiguration() throws Exception {
        FileConfiguration fc = new FileConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager("ConfigurationTest-full-config.xml");
        deploymentManager.addDeployable((Deployable)fc);
        deploymentManager.readConfiguration();
        deploymentManager = new FileDeploymentManager("ConfigurationTest-full-config-wrong-address.xml");
        deploymentManager.addDeployable((Deployable)fc);
        try {
            deploymentManager.readConfiguration();
            ConfigurationValidationTest.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        System.setProperty("a2Prop", "a2");
        System.setProperty("falseProp", "false");
        System.setProperty("trueProp", "true");
        System.setProperty("ninetyTwoProp", "92");
    }
}

