/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import java.lang.reflect.Field;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryImpl;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.ScaleDownConfiguration;
import org.apache.activemq.artemis.core.config.ha.LiveOnlyPolicyConfiguration;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.server.cluster.ClusterController;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.activemq.artemis.utils.collections.IterableStream;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ScaleDownTest
extends ClusterTestBase {
    private static final String AMQP_ACCEPTOR_URI = "tcp://127.0.0.1:5672";
    private boolean useScaleDownGroupName;

    @Parameterized.Parameters(name="useScaleDownGroupName={0}")
    public static Collection getParameters() {
        return Arrays.asList({true}, {false});
    }

    public ScaleDownTest(boolean useScaleDownGroupName) {
        this.useScaleDownGroupName = useScaleDownGroupName;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.setupLiveServer(0, this.isFileStorage(), this.isNetty(), true);
        this.setupLiveServer(1, this.isFileStorage(), this.isNetty(), true);
        this.servers[0].getConfiguration().addAcceptorConfiguration("amqp", "tcp://127.0.0.1:5672?protocols=AMQP");
        LiveOnlyPolicyConfiguration haPolicyConfiguration0 = (LiveOnlyPolicyConfiguration)this.servers[0].getConfiguration().getHAPolicyConfiguration();
        haPolicyConfiguration0.setScaleDownConfiguration(new ScaleDownConfiguration());
        LiveOnlyPolicyConfiguration haPolicyConfiguration1 = (LiveOnlyPolicyConfiguration)this.servers[1].getConfiguration().getHAPolicyConfiguration();
        haPolicyConfiguration1.setScaleDownConfiguration(new ScaleDownConfiguration());
        if (this.useScaleDownGroupName) {
            haPolicyConfiguration0.getScaleDownConfiguration().setGroupName("bill");
            haPolicyConfiguration1.getScaleDownConfiguration().setGroupName("bill");
        }
        this.setupClusterConnection("cluster0", "testAddress", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster0", "testAddress", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
        haPolicyConfiguration0.getScaleDownConfiguration().getConnectors().addAll(((ClusterConnectionConfiguration)this.servers[0].getConfiguration().getClusterConfigurations().iterator().next()).getStaticConnectors());
        haPolicyConfiguration1.getScaleDownConfiguration().getConnectors().addAll(((ClusterConnectionConfiguration)this.servers[1].getConfiguration().getClusterConfigurations().iterator().next()).getStaticConnectors());
        this.servers[0].getConfiguration().getAddressesSettings().put("#", new AddressSettings().setRedistributionDelay(0L));
        this.servers[1].getConfiguration().getAddressesSettings().put("#", new AddressSettings().setRedistributionDelay(0L));
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
    }

    protected boolean isNetty() {
        return true;
    }

    @Override
    protected boolean isResolveProtocols() {
        return true;
    }

    @Test
    public void testBasicScaleDown() throws Exception {
        int TEST_SIZE = 2;
        String addressName = "testAddress";
        String queueName1 = "testQueue1";
        String queueName2 = "testQueue2";
        this.createQueue(0, "testAddress", "testQueue1", null, true);
        this.createQueue(0, "testAddress", "testQueue2", null, true);
        this.createQueue(1, "testAddress", "testQueue1", null, true);
        this.createQueue(1, "testAddress", "testQueue2", null, true);
        this.send(0, "testAddress", 2, true, null);
        this.addConsumer(1, 0, "testQueue2", null, false);
        ClientMessage clientMessage = this.consumers[1].getConsumer().receive(1000L);
        Assert.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        this.consumers[1].getSession().commit();
        Assert.assertEquals((long)2L, (long)this.getMessageCount(((LocalQueueBinding)this.servers[0].getPostOffice().getBinding(new SimpleString("testQueue1"))).getQueue()));
        Assert.assertEquals((long)1L, (long)this.getMessageCount(((LocalQueueBinding)this.servers[0].getPostOffice().getBinding(new SimpleString("testQueue2"))).getQueue()));
        this.servers[0].stop();
        this.addConsumer(0, 1, "testQueue1", null);
        clientMessage = this.consumers[0].getConsumer().receive(1000L);
        Assert.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        clientMessage = this.consumers[0].getConsumer().receive(1000L);
        Assert.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        clientMessage = this.consumers[0].getConsumer().receiveImmediate();
        Assert.assertNull((Object)clientMessage);
        this.removeConsumer(0);
        this.addConsumer(0, 1, "testQueue2", null);
        clientMessage = this.consumers[0].getConsumer().receive(1000L);
        Assert.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        clientMessage = this.consumers[0].getConsumer().receiveImmediate();
        Assert.assertNull((Object)clientMessage);
        this.removeConsumer(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScaleDownNodeReconnect() throws Exception {
        try {
            ClusterController controller = this.servers[0].getClusterManager().getClusterController();
            Map locatorsMap = controller.getLocators();
            Iterator iter = locatorsMap.entrySet().iterator();
            ScaleDownTest.assertTrue((boolean)iter.hasNext());
            Map.Entry entry = iter.next();
            ServerLocatorImpl locator = (ServerLocatorImpl)entry.getValue();
            this.waitForClusterConnected(locator);
            this.servers[1].stop();
            this.servers[1].start();
            this.checkClusterConnectionExecutorNotBlocking(locator);
        }
        finally {
            this.servers[1].stop();
            this.servers[0].stop();
        }
    }

    private void checkClusterConnectionExecutorNotBlocking(ServerLocatorImpl locator) throws NoSuchFieldException, IllegalAccessException {
        Field factoriesField = locator.getClass().getDeclaredField("factories");
        factoriesField.setAccessible(true);
        Set factories = (Set)factoriesField.get(locator);
        ScaleDownTest.assertEquals((long)1L, (long)factories.size());
        ClientSessionFactoryImpl factory = (ClientSessionFactoryImpl)factories.iterator().next();
        Field executorField = factory.getClass().getDeclaredField("closeExecutor");
        executorField.setAccessible(true);
        Executor pool = (Executor)executorField.get(factory);
        CountDownLatch latch = new CountDownLatch(1);
        pool.execute(() -> latch.countDown());
        boolean result = false;
        try {
            result = latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ScaleDownTest.assertTrue((String)"executor got blocked.", (boolean)result);
    }

    private void waitForClusterConnected(final ServerLocatorImpl locator) throws Exception {
        boolean result = Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisfied() throws Exception {
                return !locator.getTopology().isEmpty();
            }
        }, (long)5000L);
        ScaleDownTest.assertTrue((String)"topology should not be empty", (boolean)result);
    }

    @Test
    public void testStoreAndForward() throws Exception {
        int TEST_SIZE = 50;
        String addressName1 = "testAddress1";
        String addressName2 = "testAddress2";
        String queueName1 = "testQueue1";
        String queueName2 = "testQueue2";
        this.createQueue(0, "testAddress1", "testQueue1", null, false);
        this.createQueue(1, "testAddress1", "testQueue1", null, false);
        this.createQueue(0, "testAddress2", "testQueue2", null, false);
        this.createQueue(1, "testAddress2", "testQueue2", null, false);
        String sfQueueName = null;
        for (Binding binding : IterableStream.iterableOf((Stream)this.servers[0].getPostOffice().getAllBindings())) {
            String temp = binding.getAddress().toString();
            if (!temp.startsWith(this.servers[1].getInternalNamingPrefix() + "sf.") || !temp.endsWith(this.servers[1].getNodeID().toString())) continue;
            ((LocalQueueBinding)binding).getQueue().pause();
            sfQueueName = temp;
        }
        ScaleDownTest.assertNotNull(sfQueueName);
        this.send(0, "testAddress1", 50, false, null);
        this.send(0, "testAddress2", 50, false, null);
        this.addConsumer(0, 1, "testQueue1", null);
        this.addConsumer(1, 1, "testQueue2", null);
        LocalQueueBinding queue1Binding = (LocalQueueBinding)this.servers[0].getPostOffice().getBinding(new SimpleString("testQueue1"));
        LocalQueueBinding queue2Binding = (LocalQueueBinding)this.servers[0].getPostOffice().getBinding(new SimpleString("testQueue2"));
        LocalQueueBinding sfQueueBinding = (LocalQueueBinding)this.servers[0].getPostOffice().getBinding(new SimpleString(sfQueueName));
        long timeout = 5000L;
        long start = System.currentTimeMillis();
        while (this.getMessageCount(queue1Binding.getQueue()) > 0 && System.currentTimeMillis() - start <= timeout) {
            Thread.sleep(50L);
        }
        start = System.currentTimeMillis();
        while (this.getMessageCount(queue2Binding.getQueue()) > 0 && System.currentTimeMillis() - start <= timeout) {
            Thread.sleep(50L);
        }
        start = System.currentTimeMillis();
        while (this.getMessageCount(sfQueueBinding.getQueue()) < 100 && System.currentTimeMillis() - start <= timeout) {
            Thread.sleep(50L);
        }
        Assert.assertEquals((long)0L, (long)this.getMessageCount(queue1Binding.getQueue()));
        Assert.assertEquals((long)0L, (long)this.getMessageCount(queue2Binding.getQueue()));
        Assert.assertEquals((long)100L, (long)this.getMessageCount(sfQueueBinding.getQueue()));
        this.removeConsumer(0);
        this.removeConsumer(1);
        this.servers[0].stop();
        this.addConsumer(0, 1, "testQueue1", null);
        for (int i = 0; i < 50; ++i) {
            ClientMessage clientMessage = this.consumers[0].getConsumer().receive(250L);
            Assert.assertNotNull((Object)clientMessage);
            clientMessage.acknowledge();
        }
        ClientMessage clientMessage = this.consumers[0].getConsumer().receiveImmediate();
        Assert.assertNull((Object)clientMessage);
        this.removeConsumer(0);
        this.addConsumer(0, 1, "testQueue2", null);
        for (int i = 0; i < 50; ++i) {
            clientMessage = this.consumers[0].getConsumer().receive(250L);
            Assert.assertNotNull((Object)clientMessage);
            clientMessage.acknowledge();
        }
        clientMessage = this.consumers[0].getConsumer().receiveImmediate();
        Assert.assertNull((Object)clientMessage);
        this.removeConsumer(0);
    }

    @Test
    public void testScaleDownWithMissingQueue() throws Exception {
        int TEST_SIZE = 2;
        String addressName = "testAddress";
        String queueName1 = "testQueue1";
        String queueName2 = "testQueue2";
        this.createQueue(0, "testAddress", "testQueue1", null, false);
        this.createQueue(0, "testAddress", "testQueue2", null, false);
        this.createQueue(1, "testAddress", "testQueue1", null, false);
        this.send(0, "testAddress", 2, false, null);
        this.addConsumer(1, 0, "testQueue2", null, false);
        ClientMessage clientMessage = this.consumers[1].getConsumer().receive(250L);
        Assert.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        this.consumers[1].getSession().commit();
        this.servers[0].stop();
        this.addConsumer(0, 1, "testQueue1", null);
        clientMessage = this.consumers[0].getConsumer().receive(250L);
        Assert.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        clientMessage = this.consumers[0].getConsumer().receive(250L);
        Assert.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        clientMessage = this.consumers[0].getConsumer().receiveImmediate();
        Assert.assertNull((Object)clientMessage);
        this.removeConsumer(0);
        this.addConsumer(0, 1, "testQueue2", null);
        clientMessage = this.consumers[0].getConsumer().receive(250L);
        Assert.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        clientMessage = this.consumers[0].getConsumer().receiveImmediate();
        Assert.assertNull((Object)clientMessage);
        this.removeConsumer(0);
    }

    @Test
    public void testScaleDownWithMissingAnycastQueue() throws Exception {
        int TEST_SIZE = 2;
        String addressName = "testAddress";
        String queueName = "testQueue";
        this.createQueue(0, "testAddress", "testQueue", null, false, null, null, RoutingType.ANYCAST);
        this.send(0, "testAddress", 2, false, null);
        this.servers[0].stop();
        Assert.assertEquals((Object)((QueueImpl)((LocalQueueBinding)this.servers[1].getPostOffice().getBinding(new SimpleString("testQueue"))).getBindable()).getRoutingType(), (Object)RoutingType.ANYCAST);
        this.addConsumer(0, 1, "testQueue", null);
        ClientMessage clientMessage = this.consumers[0].getConsumer().receive(250L);
        Assert.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAMQPMessages(String address, int numMessages, boolean durable) throws Exception {
        AmqpClient client = new AmqpClient(new URI(AMQP_ACCEPTOR_URI), "admin", "admin");
        try (AmqpConnection connection = client.connect();){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(address);
            for (int i = 0; i < numMessages; ++i) {
                AmqpMessage message = new AmqpMessage();
                message.setMessageId("MessageID:" + i);
                message.setDurable(durable);
                sender.send(message);
            }
        }
    }

    @Test
    public void testScaleDownAMQPMessagesWithMissingAnycastQueue() throws Exception {
        int TEST_SIZE = 2;
        String addressName = "testAddress";
        String queueName = "testQueue";
        this.createQueue(0, "testAddress", "testQueue", null, false, null, null, RoutingType.ANYCAST);
        this.sendAMQPMessages("testAddress", 2, false);
        this.servers[0].stop();
        Assert.assertEquals((Object)((QueueImpl)((LocalQueueBinding)this.servers[1].getPostOffice().getBinding(new SimpleString("testQueue"))).getBindable()).getRoutingType(), (Object)RoutingType.ANYCAST);
        this.addConsumer(0, 1, "testQueue", null);
        ClientMessage clientMessage = this.consumers[0].getConsumer().receive(250L);
        Assert.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
    }

    @Test
    public void testScaleDownAMQPMessagesWithMissingMulticastQueues() throws Exception {
        int TEST_SIZE = 2;
        String addressName = "testAddress";
        String queueName1 = "testQueue1";
        String queueName2 = "testQueue2";
        this.createQueue(0, "testAddress", "testQueue1", null, false, null, null, RoutingType.MULTICAST);
        this.createQueue(0, "testAddress", "testQueue2", null, false, null, null, RoutingType.MULTICAST);
        this.sendAMQPMessages("testAddress", 2, false);
        Assert.assertEquals((long)((QueueImpl)((LocalQueueBinding)this.servers[0].getPostOffice().getBinding(new SimpleString("testQueue1"))).getBindable()).getMessageCount(), (long)2L);
        Assert.assertEquals((long)((QueueImpl)((LocalQueueBinding)this.servers[0].getPostOffice().getBinding(new SimpleString("testQueue2"))).getBindable()).getMessageCount(), (long)2L);
        this.servers[0].stop();
        Assert.assertEquals((Object)((QueueImpl)((LocalQueueBinding)this.servers[1].getPostOffice().getBinding(new SimpleString("testQueue1"))).getBindable()).getRoutingType(), (Object)RoutingType.MULTICAST);
        Assert.assertEquals((Object)((QueueImpl)((LocalQueueBinding)this.servers[1].getPostOffice().getBinding(new SimpleString("testQueue2"))).getBindable()).getRoutingType(), (Object)RoutingType.MULTICAST);
        Assert.assertEquals((long)((QueueImpl)((LocalQueueBinding)this.servers[1].getPostOffice().getBinding(new SimpleString("testQueue1"))).getBindable()).getMessageCount(), (long)2L);
        Assert.assertEquals((long)((QueueImpl)((LocalQueueBinding)this.servers[1].getPostOffice().getBinding(new SimpleString("testQueue2"))).getBindable()).getMessageCount(), (long)2L);
        this.addConsumer(0, 1, "testQueue1", null);
        ClientMessage clientMessage = this.consumers[0].getConsumer().receive(250L);
        Assert.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        this.addConsumer(1, 1, "testQueue2", null);
        clientMessage = this.consumers[1].getConsumer().receive(250L);
        Assert.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
    }

    @Test
    public void testMessageProperties() throws Exception {
        int TEST_SIZE = 5;
        String addressName = "testAddress";
        String queueName = "testQueue";
        this.createQueue(0, "testAddress", "testQueue", null, false);
        this.createQueue(1, "testAddress", "testQueue", null, false);
        ClientSessionFactory sf = this.sfs[0];
        ClientSession session = this.addClientSession(sf.createSession(false, true, true));
        ClientProducer producer = this.addClientProducer(session.createProducer("testAddress"));
        StringBuilder international = new StringBuilder();
        for (char x = '\u0320'; x < '\u04b0'; x = (char)(x + '\u0001')) {
            international.append(x);
        }
        String special = "\"<>'&";
        for (int i = 0; i < 5; ++i) {
            ClientMessage msg = session.createMessage(true);
            msg.getBodyBuffer().writeString("Bob the giant pig " + i);
            msg.putBooleanProperty("myBooleanProperty", Boolean.TRUE.booleanValue());
            msg.putByteProperty("myByteProperty", Byte.valueOf("0").byteValue());
            msg.putBytesProperty("myBytesProperty", new byte[]{0, 1, 2, 3, 4});
            msg.putDoubleProperty("myDoubleProperty", (double)i * 1.6);
            msg.putFloatProperty("myFloatProperty", (float)i * 2.5f);
            msg.putIntProperty("myIntProperty", i);
            msg.putLongProperty("myLongProperty", Long.MAX_VALUE - (long)i);
            msg.putObjectProperty("myObjectProperty", (Object)i);
            msg.putShortProperty("myShortProperty", Integer.valueOf(i).shortValue());
            msg.putStringProperty("myStringProperty", "myStringPropertyValue_" + i);
            msg.putStringProperty("myNonAsciiStringProperty", international.toString());
            msg.putStringProperty("mySpecialCharacters", special);
            producer.send((Message)msg);
        }
        this.servers[0].stop();
        sf = this.sfs[1];
        session = this.addClientSession(sf.createSession(false, true, true));
        ClientConsumer consumer = this.addClientConsumer(session.createConsumer("testQueue"));
        session.start();
        for (int i = 0; i < 5; ++i) {
            ClientMessage msg = consumer.receive(250L);
            byte[] body = new byte[msg.getBodySize()];
            msg.getBodyBuffer().readBytes(body);
            Assert.assertTrue((boolean)new String(body).contains("Bob the giant pig " + i));
            Assert.assertEquals((Object)msg.getBooleanProperty("myBooleanProperty"), (Object)Boolean.TRUE);
            Assert.assertEquals((Object)msg.getByteProperty("myByteProperty"), (Object)Byte.valueOf("0"));
            byte[] bytes = msg.getBytesProperty("myBytesProperty");
            for (int j = 0; j < 5; ++j) {
                Assert.assertEquals((long)j, (long)bytes[j]);
            }
            Assert.assertEquals((double)((double)i * 1.6), (double)msg.getDoubleProperty("myDoubleProperty"), (double)1.0E-6);
            Assert.assertEquals((double)((float)i * 2.5f), (double)msg.getFloatProperty("myFloatProperty").floatValue(), (double)1.0E-6);
            Assert.assertEquals((long)i, (long)msg.getIntProperty("myIntProperty").intValue());
            Assert.assertEquals((long)(Long.MAX_VALUE - (long)i), (long)msg.getLongProperty("myLongProperty"));
            Assert.assertEquals((Object)i, (Object)msg.getObjectProperty("myObjectProperty"));
            Assert.assertEquals((long)Integer.valueOf(i).shortValue(), (long)msg.getShortProperty("myShortProperty").shortValue());
            Assert.assertEquals((Object)("myStringPropertyValue_" + i), (Object)msg.getStringProperty("myStringProperty"));
            Assert.assertEquals((Object)international.toString(), (Object)msg.getStringProperty("myNonAsciiStringProperty"));
            Assert.assertEquals((Object)special, (Object)msg.getStringProperty("mySpecialCharacters"));
        }
    }

    @Test
    public void testLargeMessage() throws Exception {
        String addressName = "testAddress";
        String queueName = "testQueue";
        this.createQueue(0, "testAddress", "testQueue", null, true);
        this.createQueue(1, "testAddress", "testQueue", null, true);
        ClientSessionFactory sf = this.sfs[0];
        ClientSession session = this.addClientSession(sf.createSession(false, false));
        ClientProducer producer = this.addClientProducer(session.createProducer("testAddress"));
        byte[] buffer = new byte[204800];
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = ScaleDownTest.getSamplebyte((long)i);
        }
        for (int nmsg = 0; nmsg < 10; ++nmsg) {
            ClientMessage message = session.createMessage(true);
            message.getBodyBuffer().writeBytes(buffer);
            producer.send((Message)message);
            session.commit();
        }
        this.servers[0].stop();
        sf = this.sfs[1];
        session = this.addClientSession(sf.createSession(false, true, true));
        ClientConsumer consumer = this.addClientConsumer(session.createConsumer("testQueue"));
        session.start();
        for (int nmsg = 0; nmsg < 10; ++nmsg) {
            ClientMessage msg = consumer.receive(250L);
            Assert.assertNotNull((Object)msg);
            Assert.assertEquals((long)204800L, (long)msg.getBodySize());
            for (int i = 0; i < 204800; ++i) {
                byte byteRead = msg.getBodyBuffer().readByte();
                Assert.assertEquals((String)(msg + " Is different"), (long)ActiveMQTestBase.getSamplebyte((long)i), (long)byteRead);
            }
            msg.acknowledge();
            session.commit();
        }
    }

    @Test
    public void testPaging() throws Exception {
        int i;
        int CHUNK_SIZE = 50;
        int messageCount = 0;
        String addressName = "testAddress";
        String queueName = "testQueue";
        this.createQueue(0, "testAddress", "testQueue", null, false);
        this.createQueue(1, "testAddress", "testQueue", null, false);
        ClientSessionFactory sf = this.sfs[0];
        ClientSession session = this.addClientSession(sf.createSession(false, false));
        ClientProducer producer = this.addClientProducer(session.createProducer("testAddress"));
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(10240).setMaxSizeBytes(20480L);
        this.servers[0].getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        while (!this.servers[0].getPagingManager().getPageStore(new SimpleString("testAddress")).isPaging()) {
            for (i = 0; i < 50; ++i) {
                ClientMessage message = session.createMessage(true);
                message.getBodyBuffer().writeBytes(new byte[1024]);
                producer.send((Message)message);
                ++messageCount;
            }
            session.commit();
        }
        this.servers[0].stop();
        this.addConsumer(0, 1, "testQueue", null);
        for (i = 0; i < messageCount; ++i) {
            Assert.assertNotNull((Object)this.consumers[0].getConsumer().receive(250L));
        }
        Assert.assertNull((Object)this.consumers[0].getConsumer().receiveImmediate());
        this.removeConsumer(0);
    }

    @Test
    public void testOrderWithPaging() throws Exception {
        int i;
        int CHUNK_SIZE = 50;
        int messageCount = 0;
        String addressName = "testAddress";
        String queueName = "testQueue";
        this.createQueue(0, "testAddress", "testQueue", null, false);
        this.createQueue(1, "testAddress", "testQueue", null, false);
        ClientSessionFactory sf = this.sfs[0];
        ClientSession session = this.addClientSession(sf.createSession(false, false));
        ClientProducer producer = this.addClientProducer(session.createProducer("testAddress"));
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(10240).setMaxSizeBytes(20480L);
        this.servers[0].getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        while (!this.servers[0].getPagingManager().getPageStore(new SimpleString("testAddress")).isPaging()) {
            for (i = 0; i < 50; ++i) {
                ClientMessage message = session.createMessage(true);
                message.getBodyBuffer().writeBytes(new byte[1024]);
                message.putIntProperty("order", i);
                producer.send((Message)message);
                ++messageCount;
            }
            session.commit();
        }
        this.servers[0].stop();
        this.addConsumer(0, 1, "testQueue", null);
        for (i = 0; i < messageCount; ++i) {
            Assert.assertEquals((long)i, (long)this.consumers[0].getConsumer().receive(250L).getIntProperty("order").intValue());
        }
        Assert.assertNull((Object)this.consumers[0].getConsumer().receiveImmediate());
        this.removeConsumer(0);
    }

    @Test
    public void testFilters() throws Exception {
        int i;
        int TEST_SIZE = 50;
        String addressName = "testAddress";
        String evenQueue = "evenQueue";
        String oddQueue = "oddQueue";
        this.createQueue(0, "testAddress", "evenQueue", "0", false);
        this.createQueue(0, "testAddress", "oddQueue", "1", false);
        this.createQueue(1, "testAddress", "evenQueue", "0", false);
        this.createQueue(1, "testAddress", "oddQueue", "1", false);
        ClientSessionFactory sf = this.sfs[0];
        ClientSession session = this.addClientSession(sf.createSession(false, false));
        ClientProducer producer = this.addClientProducer(session.createProducer("testAddress"));
        for (i = 0; i < 50; ++i) {
            ClientMessage message = session.createMessage(false);
            if (i % 2 == 0) {
                message.putStringProperty(ClusterTestBase.FILTER_PROP, new SimpleString("0"));
            } else {
                message.putStringProperty(ClusterTestBase.FILTER_PROP, new SimpleString("1"));
            }
            producer.send((Message)message);
        }
        session.commit();
        this.servers[0].stop();
        this.addConsumer(0, 1, "evenQueue", null);
        this.addConsumer(1, 1, "oddQueue", null);
        for (i = 0; i < 50; ++i) {
            String compare;
            ClientMessage message;
            if (i % 2 == 0) {
                message = this.consumers[0].getConsumer().receive(250L);
                compare = "0";
            } else {
                message = this.consumers[1].getConsumer().receive(250L);
                compare = "1";
            }
            Assert.assertEquals((Object)compare, (Object)message.getStringProperty(ClusterTestBase.FILTER_PROP));
        }
        Assert.assertNull((Object)this.consumers[0].getConsumer().receiveImmediate());
        Assert.assertNull((Object)this.consumers[1].getConsumer().receiveImmediate());
        this.removeConsumer(0);
        this.removeConsumer(1);
    }

    @Test
    public void testScaleDownMessageWithAutoCreatedDLAResources() throws Exception {
        SimpleString dla = new SimpleString("DLA");
        SimpleString queueName = new SimpleString("q1");
        SimpleString addressName = new SimpleString("q1");
        String sampleText = "Put me on DLA";
        AddressSettings addressSettings = (AddressSettings)this.servers[0].getAddressSettingsRepository().getMatch(addressName.toString());
        this.servers[0].getAddressSettingsRepository().addMatch(addressName.toString(), (Object)new AddressSettings().setMaxDeliveryAttempts(1).setDeadLetterAddress(dla).setAutoCreateDeadLetterResources(true));
        SimpleString dlq = addressSettings.getDeadLetterQueuePrefix().concat(addressName).concat(addressSettings.getDeadLetterQueueSuffix());
        this.createQueue(0, addressName.toString(), queueName.toString(), null, false, null, null, RoutingType.ANYCAST);
        ClientSessionFactory sf = this.sfs[0];
        ClientSession session = this.addClientSession(sf.createSession(true, false));
        ClientProducer producer = this.addClientProducer(session.createProducer(addressName));
        ClientMessage m = this.createTextMessage(session, "Put me on DLA");
        m.putByteProperty(Message.HDR_ROUTING_TYPE, (byte)1);
        producer.send((Message)m);
        session.start();
        ClientConsumer consumer = session.createConsumer(queueName);
        ClientMessage message = consumer.receive(1000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)message.getBodyBuffer().readString(), (Object)"Put me on DLA");
        ScaleDownTest.assertTrue((message.getRoutingType() == RoutingType.ANYCAST ? (byte)1 : 0) != 0);
        message.acknowledge();
        session.rollback();
        message = consumer.receiveImmediate();
        Assert.assertNull((Object)message);
        consumer.close();
        consumer = session.createConsumer(dlq.toString());
        message = consumer.receive(1000L);
        Assert.assertNotNull((Object)message);
        ScaleDownTest.assertTrue((message.getRoutingType() == null ? (byte)1 : 0) != 0);
        this.servers[0].stop();
        sf = this.sfs[1];
        session = this.addClientSession(sf.createSession(false, true, true));
        consumer = session.createConsumer(dlq.toString());
        session.start();
        message = consumer.receive(1000L);
        Assert.assertNotNull((Object)message);
        message.acknowledge();
        Assert.assertEquals((Object)"Put me on DLA", (Object)message.getBodyBuffer().readString());
        consumer.close();
    }
}

