/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.rest.util;

import java.io.IOException;
import org.apache.activemq.artemis.tests.integration.rest.util.ResponseUtil;
import org.apache.activemq.artemis.tests.integration.rest.util.RestAMQConnection;
import org.apache.activemq.artemis.tests.integration.rest.util.RestMessageContext;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;

public class TopicRestMessageContext
extends RestMessageContext {
    public static final String PREFIX_TOPIC = "/topics/";
    private boolean durableSub;

    public TopicRestMessageContext(RestAMQConnection restAMQConnection, String topic, boolean durable) throws IOException {
        super(restAMQConnection, topic);
        this.durableSub = durable;
    }

    @Override
    protected String getDestLink() {
        return PREFIX_TOPIC + this.destination;
    }

    @Override
    protected String getPullConsumerUri() {
        return this.getDestLink() + "/pull-subscriptions";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initPullConsumers() throws IOException {
        block7: {
            String pullUri = this.getPullConsumerUri();
            CloseableHttpResponse response = null;
            if (this.durableSub || !this.autoAck) {
                String extraOpt = "durable=" + this.durableSub + "&autoAck=" + this.autoAck;
                response = this.connection.post(pullUri, "application/x-www-form-urlencoded", extraOpt);
            } else {
                response = this.connection.post(pullUri);
            }
            int code = ResponseUtil.getHttpCode(response);
            try {
                if (code == 201) {
                    Header header = response.getFirstHeader("Location");
                    this.contextMap.put("pull-consumers-location", header.getValue());
                    header = response.getFirstHeader("msg-consume-next");
                    this.contextMap.put("msg-consume-next", header.getValue());
                    header = response.getFirstHeader("msg-acknowledge-next");
                    if (header != null) {
                        this.contextMap.put("msg-acknowledge-next", header.getValue());
                    }
                    break block7;
                }
                throw new IllegalStateException("Failed to init pull consumer " + ResponseUtil.getDetails(response));
            }
            finally {
                response.close();
            }
        }
    }

    @Override
    protected String getPushLink(String pushTarget) {
        return PREFIX_TOPIC + pushTarget;
    }
}

