/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.plugin;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.RoutingStatus;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.server.HandleStatus;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueConfig;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.cluster.Bridge;
import org.apache.activemq.artemis.core.server.federation.FederatedConsumerKey;
import org.apache.activemq.artemis.core.server.federation.FederatedQueueConsumer;
import org.apache.activemq.artemis.core.server.federation.FederationStream;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerPlugin;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Assert;

public class MethodCalledVerifier
implements ActiveMQServerPlugin {
    private final Map<String, AtomicInteger> methodCalls;
    public static final String AFTER_CREATE_CONNECTION = "afterCreateConnection";
    public static final String AFTER_DESTROY_CONNECTION = "afterDestroyConnection";
    public static final String BEFORE_CREATE_SESSION = "beforeCreateSession";
    public static final String AFTER_CREATE_SESSION = "afterCreateSession";
    public static final String BEFORE_CLOSE_SESSION = "beforeCloseSession";
    public static final String AFTER_CLOSE_SESSION = "afterCloseSession";
    public static final String BEFORE_SESSION_METADATA_ADDED = "beforeSessionMetadataAdded";
    public static final String AFTER_SESSION_METADATA_ADDED = "afterSessionMetadataAdded";
    public static final String BEFORE_CREATE_CONSUMER = "beforeCreateConsumer";
    public static final String AFTER_CREATE_CONSUMER = "afterCreateConsumer";
    public static final String BEFORE_CLOSE_CONSUMER = "beforeCloseConsumer";
    public static final String AFTER_CLOSE_CONSUMER = "afterCloseConsumer";
    public static final String BEFORE_ADD_ADDRESS = "beforeAddAddress";
    public static final String AFTER_ADD_ADDRESS = "afterAddAddress";
    public static final String BEFORE_UPDATE_ADDRESS = "beforeUpdateAddress";
    public static final String AFTER_UPDATE_ADDRESS = "afterUpdateAddress";
    public static final String BEFORE_REMOVE_ADDRESS = "beforeRemoveAddress";
    public static final String AFTER_REMOVE_ADDRESS = "afterRemoveAddress";
    public static final String BEFORE_CREATE_QUEUE = "beforeCreateQueue";
    public static final String AFTER_CREATE_QUEUE = "afterCreateQueue";
    public static final String BEFORE_DESTROY_QUEUE = "beforeDestroyQueue";
    public static final String AFTER_DESTROY_QUEUE = "afterDestroyQueue";
    public static final String BEFORE_ADD_BINDING = "beforeAddBinding";
    public static final String AFTER_ADD_BINDING = "afterAddBinding";
    public static final String BEFORE_REMOVE_BINDING = "beforeRemoveBinding";
    public static final String AFTER_REMOVE_BINDING = "afterRemoveBinding";
    public static final String MESSAGE_EXPIRED = "messageExpired";
    public static final String MESSAGE_ACKED = "messageAcknowledged";
    public static final String BEFORE_SEND = "beforeSend";
    public static final String AFTER_SEND = "afterSend";
    public static final String ON_SEND_EXCEPTION = "onSendException";
    public static final String BEFORE_MESSAGE_ROUTE = "beforeMessageRoute";
    public static final String AFTER_MESSAGE_ROUTE = "afterMessageRoute";
    public static final String ON_MESSAGE_ROUTE_EXCEPTION = "onMessageRouteException";
    public static final String BEFORE_DELIVER = "beforeDeliver";
    public static final String AFTER_DELIVER = "afterDeliver";
    public static final String BEFORE_DEPLOY_BRIDGE = "beforeDeployBridge";
    public static final String AFTER_DEPLOY_BRIDGE = "afterDeployBridge";
    public static final String BEFORE_DELIVER_BRIDGE = "beforeDeliverBridge";
    public static final String AFTER_DELIVER_BRIDGE = "afterDeliverBridge";
    public static final String AFTER_ACKNOWLEDGE_BRIDGE = "afterAcknowledgeBridge";
    public static final String FEDERATION_STREAM_STARTED = "federationStreamStarted";
    public static final String FEDERATION_STREAM_STOPPED = "federationStreamStopped";
    public static final String BEFORE_CREATE_FEDERATED_QUEUE_CONSUMER = "beforeCreateFederatedQueueConsumer";
    public static final String AFTER_CREATE_FEDERATED_QUEUE_CONSUMER = "afterCreateFederatedQueueConsumer";
    public static final String BEFORE_CLOSE_FEDERATED_QUEUE_CONSUMER = "beforeCloseFederatedQueueConsumer";
    public static final String AFTER_CLOSE_FEDERATED_QUEUE_CONSUMER = "afterCloseFederatedQueueConsumer";
    public static final String FEDERATED_ADDRESS_CONDITIONAL_CREATE_CONSUMER = "federatedAddressConditionalCreateConsumer";
    public static final String FEDERATED_QUEUE_CONDITIONAL_CREATE_CONSUMER = "federatedQueueConditionalCreateConsumer";
    public static final String BEFORE_FEDERATED_QUEUE_CONSUMER_MESSAGE_HANDLED = "beforeFederatedQueueConsumerMessageHandled";
    public static final String AFTER_FEDERATED_QUEUE_CONSUMER_MESSAGE_HANDLED = "afterFederatedQueueConsumerMessageHandled";

    public MethodCalledVerifier(Map<String, AtomicInteger> methodCalls) {
        this.methodCalls = methodCalls;
    }

    public MethodCalledVerifier() {
        this(new ConcurrentHashMap<String, AtomicInteger>());
    }

    public void afterCreateConnection(RemotingConnection connection) {
        Preconditions.checkNotNull((Object)connection);
        this.methodCalled(AFTER_CREATE_CONNECTION);
    }

    public void afterDestroyConnection(RemotingConnection connection) {
        Preconditions.checkNotNull((Object)connection);
        this.methodCalled(AFTER_DESTROY_CONNECTION);
    }

    public void beforeCreateSession(String name, String username, int minLargeMessageSize, RemotingConnection connection, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean xa, String defaultAddress, SessionCallback callback, boolean autoCreateQueues, OperationContext context, Map<SimpleString, RoutingType> prefixes) {
        Preconditions.checkNotNull((Object)connection);
        this.methodCalled(BEFORE_CREATE_SESSION);
    }

    public void afterCreateSession(ServerSession session) {
        Preconditions.checkNotNull((Object)session);
        this.methodCalled(AFTER_CREATE_SESSION);
    }

    public void beforeCloseSession(ServerSession session, boolean failed) {
        Preconditions.checkNotNull((Object)session);
        this.methodCalled(BEFORE_CLOSE_SESSION);
    }

    public void afterCloseSession(ServerSession session, boolean failed) {
        Preconditions.checkNotNull((Object)session);
        this.methodCalled(AFTER_CLOSE_SESSION);
    }

    public void beforeSessionMetadataAdded(ServerSession session, String key, String data) {
        Preconditions.checkNotNull((Object)key);
        this.methodCalled(BEFORE_SESSION_METADATA_ADDED);
    }

    public void afterSessionMetadataAdded(ServerSession session, String key, String data) {
        Preconditions.checkNotNull((Object)key);
        this.methodCalled(AFTER_SESSION_METADATA_ADDED);
    }

    public void beforeCreateConsumer(long consumerID, QueueBinding queueBinding, SimpleString filterString, boolean browseOnly, boolean supportLargeMessage) {
        Preconditions.checkNotNull((Object)queueBinding);
        this.methodCalled(BEFORE_CREATE_CONSUMER);
    }

    public void afterCreateConsumer(ServerConsumer consumer) {
        Preconditions.checkNotNull((Object)consumer);
        this.methodCalled(AFTER_CREATE_CONSUMER);
    }

    public void beforeCloseConsumer(ServerConsumer consumer, boolean failed) {
        Preconditions.checkNotNull((Object)consumer);
        this.methodCalled(BEFORE_CLOSE_CONSUMER);
    }

    public void afterCloseConsumer(ServerConsumer consumer, boolean failed) {
        Preconditions.checkNotNull((Object)consumer);
        this.methodCalled(AFTER_CLOSE_CONSUMER);
    }

    public void beforeAddAddress(AddressInfo addressInfo, boolean reload) throws ActiveMQException {
        Preconditions.checkNotNull((Object)addressInfo);
        this.methodCalled(BEFORE_ADD_ADDRESS);
    }

    public void afterAddAddress(AddressInfo addressInfo, boolean reload) throws ActiveMQException {
        Preconditions.checkNotNull((Object)addressInfo);
        this.methodCalled(AFTER_ADD_ADDRESS);
    }

    public void beforeUpdateAddress(SimpleString address, EnumSet<RoutingType> routingTypes) throws ActiveMQException {
        Preconditions.checkNotNull((Object)address);
        Preconditions.checkNotNull(routingTypes);
        this.methodCalled(BEFORE_UPDATE_ADDRESS);
    }

    public void afterUpdateAddress(AddressInfo addressInfo) throws ActiveMQException {
        Preconditions.checkNotNull((Object)addressInfo);
        this.methodCalled(AFTER_UPDATE_ADDRESS);
    }

    public void beforeRemoveAddress(SimpleString address) throws ActiveMQException {
        Preconditions.checkNotNull((Object)address);
        this.methodCalled(BEFORE_REMOVE_ADDRESS);
    }

    public void afterRemoveAddress(SimpleString address, AddressInfo addressInfo) throws ActiveMQException {
        Preconditions.checkNotNull((Object)address);
        Preconditions.checkNotNull((Object)addressInfo);
        this.methodCalled(AFTER_REMOVE_ADDRESS);
    }

    public void beforeCreateQueue(QueueConfig queueConfig) {
        Preconditions.checkNotNull((Object)queueConfig);
        this.methodCalled(BEFORE_CREATE_QUEUE);
    }

    public void afterCreateQueue(Queue queue) {
        Preconditions.checkNotNull((Object)queue);
        this.methodCalled(AFTER_CREATE_QUEUE);
    }

    public void beforeDestroyQueue(Queue queue, SecurityAuth session, boolean checkConsumerCount, boolean removeConsumers, boolean autoDeleteAddress) {
        Preconditions.checkNotNull((Object)queue);
        this.methodCalled(BEFORE_DESTROY_QUEUE);
    }

    public void afterDestroyQueue(Queue queue, SimpleString address, SecurityAuth session, boolean checkConsumerCount, boolean removeConsumers, boolean autoDeleteAddress) {
        Preconditions.checkNotNull((Object)queue);
        this.methodCalled(AFTER_DESTROY_QUEUE);
    }

    public void beforeAddBinding(Binding binding) throws ActiveMQException {
        Preconditions.checkNotNull((Object)binding);
        this.methodCalled(BEFORE_ADD_BINDING);
    }

    public void afterAddBinding(Binding binding) throws ActiveMQException {
        Preconditions.checkNotNull((Object)binding);
        this.methodCalled(AFTER_ADD_BINDING);
    }

    public void beforeRemoveBinding(SimpleString uniqueName, Transaction tx, boolean deleteData) throws ActiveMQException {
        Preconditions.checkNotNull((Object)uniqueName);
        this.methodCalled(BEFORE_REMOVE_BINDING);
    }

    public void afterRemoveBinding(Binding binding, Transaction tx, boolean deleteData) throws ActiveMQException {
        Preconditions.checkNotNull((Object)binding);
        this.methodCalled(AFTER_REMOVE_BINDING);
    }

    public void messageExpired(MessageReference message, SimpleString messageExpiryAddress, ServerConsumer consumer) {
        Preconditions.checkNotNull((Object)message);
        this.methodCalled(MESSAGE_EXPIRED);
    }

    public void messageAcknowledged(MessageReference ref, AckReason reason, ServerConsumer consumer) {
        Preconditions.checkNotNull((Object)ref);
        Preconditions.checkNotNull((Object)reason);
        this.methodCalled(MESSAGE_ACKED);
    }

    public void beforeSend(ServerSession session, Transaction tx, Message message, boolean direct, boolean noAutoCreateQueue) {
        Preconditions.checkNotNull((Object)message);
        this.methodCalled(BEFORE_SEND);
    }

    public void afterSend(ServerSession session, Transaction tx, Message message, boolean direct, boolean noAutoCreateQueue, RoutingStatus result) {
        Preconditions.checkNotNull((Object)message);
        Preconditions.checkNotNull((Object)result);
        this.methodCalled(AFTER_SEND);
    }

    public void onSendException(ServerSession session, Transaction tx, Message message, boolean direct, boolean noAutoCreateQueue, Exception e) {
        Preconditions.checkNotNull((Object)message);
        Preconditions.checkNotNull((Object)e);
        this.methodCalled(ON_SEND_EXCEPTION);
    }

    public void beforeMessageRoute(Message message, RoutingContext context, boolean direct, boolean rejectDuplicates) {
        Preconditions.checkNotNull((Object)message);
        Preconditions.checkNotNull((Object)context);
        this.methodCalled(BEFORE_MESSAGE_ROUTE);
    }

    public void afterMessageRoute(Message message, RoutingContext context, boolean direct, boolean rejectDuplicates, RoutingStatus result) {
        Preconditions.checkNotNull((Object)message);
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)result);
        this.methodCalled(AFTER_MESSAGE_ROUTE);
    }

    public void onMessageRouteException(Message message, RoutingContext context, boolean direct, boolean rejectDuplicates, Exception e) {
        Preconditions.checkNotNull((Object)message);
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)e);
        this.methodCalled(ON_MESSAGE_ROUTE_EXCEPTION);
    }

    public void beforeDeliver(ServerConsumer consumer, MessageReference reference) {
        Preconditions.checkNotNull((Object)reference);
        this.methodCalled(BEFORE_DELIVER);
    }

    public void afterDeliver(ServerConsumer consumer, MessageReference reference) {
        Preconditions.checkNotNull((Object)reference);
        this.methodCalled(AFTER_DELIVER);
    }

    public void beforeDeployBridge(BridgeConfiguration config) {
        Preconditions.checkNotNull((Object)config);
        this.methodCalled(BEFORE_DEPLOY_BRIDGE);
    }

    public void afterDeployBridge(Bridge bridge) {
        Preconditions.checkNotNull((Object)bridge);
        this.methodCalled(AFTER_DEPLOY_BRIDGE);
    }

    public void beforeDeliverBridge(Bridge bridge, MessageReference ref) throws ActiveMQException {
        Preconditions.checkNotNull((Object)bridge);
        this.methodCalled(BEFORE_DELIVER_BRIDGE);
    }

    public void afterDeliverBridge(Bridge bridge, MessageReference ref, HandleStatus status) throws ActiveMQException {
        Preconditions.checkNotNull((Object)bridge);
        this.methodCalled(AFTER_DELIVER_BRIDGE);
    }

    public void afterAcknowledgeBridge(Bridge bridge, MessageReference ref) throws ActiveMQException {
        Preconditions.checkNotNull((Object)bridge);
        this.methodCalled(AFTER_ACKNOWLEDGE_BRIDGE);
    }

    public void federationStreamStarted(FederationStream stream) throws ActiveMQException {
        Preconditions.checkNotNull((Object)stream);
        this.methodCalled(FEDERATION_STREAM_STARTED);
    }

    public void federationStreamStopped(FederationStream stream) throws ActiveMQException {
        Preconditions.checkNotNull((Object)stream);
        this.methodCalled(FEDERATION_STREAM_STOPPED);
    }

    public void beforeCreateFederatedQueueConsumer(FederatedConsumerKey key) throws ActiveMQException {
        Preconditions.checkNotNull((Object)key);
        this.methodCalled(BEFORE_CREATE_FEDERATED_QUEUE_CONSUMER);
    }

    public void afterCreateFederatedQueueConsumer(FederatedQueueConsumer consumer) throws ActiveMQException {
        Preconditions.checkNotNull((Object)consumer);
        this.methodCalled(AFTER_CREATE_FEDERATED_QUEUE_CONSUMER);
    }

    public void beforeCloseFederatedQueueConsumer(FederatedQueueConsumer consumer) throws ActiveMQException {
        Preconditions.checkNotNull((Object)consumer);
        this.methodCalled(BEFORE_CLOSE_FEDERATED_QUEUE_CONSUMER);
    }

    public void afterCloseFederatedQueueConsumer(FederatedQueueConsumer consumer) throws ActiveMQException {
        Preconditions.checkNotNull((Object)consumer);
        this.methodCalled(AFTER_CLOSE_FEDERATED_QUEUE_CONSUMER);
    }

    public void beforeFederatedQueueConsumerMessageHandled(FederatedQueueConsumer consumer, Message message) throws ActiveMQException {
        Preconditions.checkNotNull((Object)consumer);
        Preconditions.checkNotNull((Object)message);
        this.methodCalled(BEFORE_FEDERATED_QUEUE_CONSUMER_MESSAGE_HANDLED);
    }

    public void afterFederatedQueueConsumerMessageHandled(FederatedQueueConsumer consumer, Message message) throws ActiveMQException {
        Preconditions.checkNotNull((Object)consumer);
        Preconditions.checkNotNull((Object)message);
        this.methodCalled(AFTER_FEDERATED_QUEUE_CONSUMER_MESSAGE_HANDLED);
    }

    public boolean federatedAddressConditionalCreateConsumer(Queue queue) throws ActiveMQException {
        Preconditions.checkNotNull((Object)queue);
        this.methodCalled(FEDERATED_ADDRESS_CONDITIONAL_CREATE_CONSUMER);
        return true;
    }

    public boolean federatedQueueConditionalCreateConsumer(ServerConsumer consumer) throws ActiveMQException {
        Preconditions.checkNotNull((Object)consumer);
        this.methodCalled(FEDERATED_QUEUE_CONDITIONAL_CREATE_CONSUMER);
        return true;
    }

    public void validatePluginMethodsEquals(int count, String ... names) {
        this.validatePluginMethodsEquals(count, 30000L, 100L, new String[0]);
    }

    public void validatePluginMethodsEquals(int count, long timeout, long sleepMillis, String ... names) {
        Arrays.asList(names).forEach(name -> {
            try {
                Wait.waitFor(() -> count == this.methodCalls.getOrDefault(name, new AtomicInteger()).get(), (long)timeout, (long)sleepMillis);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Assert.assertEquals((String)("validating method " + name), (long)count, (long)this.methodCalls.getOrDefault(name, new AtomicInteger()).get());
        });
    }

    public void validatePluginMethodsAtLeast(int count, String ... names) {
        Arrays.asList(names).forEach(name -> {
            try {
                Wait.waitFor(() -> count <= this.methodCalls.getOrDefault(name, new AtomicInteger()).get());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Assert.assertTrue((String)("validating method " + name + " expected less than " + count), (count <= this.methodCalls.getOrDefault(name, new AtomicInteger()).get() ? (byte)1 : (byte)0) != 0);
        });
    }

    private void methodCalled(String name) {
        this.methodCalls.computeIfAbsent(name, k -> new AtomicInteger()).incrementAndGet();
    }
}

