/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.paging;

import java.util.HashMap;
import java.util.LinkedList;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreMasterPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreSlavePolicyConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptorFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;

public class SpawnedServerSupport {
    static ActiveMQServer createServer(String folder) {
        return ActiveMQServers.newActiveMQServer((Configuration)SpawnedServerSupport.createConfig(folder), (boolean)true);
    }

    static Configuration createConfig(String folder) {
        AddressSettings settings = new AddressSettings().setMaxDeliveryAttempts(-1).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE).setPageSizeBytes(10240).setMaxSizeBytes(102400L);
        ConfigurationImpl config = new ConfigurationImpl().setSecurityEnabled(false).setJournalMinFiles(2).setJournalFileSize(102400).setJournalType(ActiveMQTestBase.getDefaultJournalType()).setJournalCompactMinFiles(0).setJournalCompactPercentage(0).setClusterPassword("UnitTestsClusterPassword").setJournalDirectory(ActiveMQTestBase.getJournalDir((String)folder, (int)0, (boolean)false)).setBindingsDirectory(ActiveMQTestBase.getBindingsDir((String)folder, (int)0, (boolean)false)).setPagingDirectory(ActiveMQTestBase.getPageDir((String)folder, (int)0, (boolean)false)).setLargeMessagesDirectory(ActiveMQTestBase.getLargeMessagesDir((String)folder, (int)0, (boolean)false)).setPersistenceEnabled(true).addAddressesSetting("#", settings).addAcceptorConfiguration(new TransportConfiguration(ActiveMQTestBase.NETTY_ACCEPTOR_FACTORY));
        return config;
    }

    static Configuration createSharedFolderConfig(String folder, int thisport, int otherport, boolean isBackup) {
        SharedStoreSlavePolicyConfiguration haPolicyConfiguration = null;
        if (isBackup) {
            haPolicyConfiguration = new SharedStoreSlavePolicyConfiguration();
            haPolicyConfiguration.setAllowFailBack(false);
        } else {
            haPolicyConfiguration = new SharedStoreMasterPolicyConfiguration();
        }
        Configuration config = SpawnedServerSupport.createConfig(folder).clearAcceptorConfigurations().setJournalFileSize(0xF00000).addAcceptorConfiguration(SpawnedServerSupport.createTransportConfigiguration(true, thisport)).addConnectorConfiguration("thisServer", SpawnedServerSupport.createTransportConfigiguration(false, thisport)).addConnectorConfiguration("otherServer", SpawnedServerSupport.createTransportConfigiguration(false, otherport)).setMessageExpiryScanPeriod(500L).addClusterConfiguration(isBackup ? SpawnedServerSupport.setupClusterConn("thisServer", "otherServer") : SpawnedServerSupport.setupClusterConn("thisServer", new String[0])).setHAPolicyConfiguration((HAPolicyConfiguration)haPolicyConfiguration);
        return config;
    }

    protected static final ClusterConnectionConfiguration setupClusterConn(String connectorName, String ... connectors) {
        LinkedList<String> connectorList = new LinkedList<String>();
        for (String conn : connectors) {
            connectorList.add(conn);
        }
        ClusterConnectionConfiguration ccc = new ClusterConnectionConfiguration().setName("cluster1").setAddress("jms").setConnectorName(connectorName).setRetryInterval(10L).setDuplicateDetection(false).setMessageLoadBalancingType(MessageLoadBalancingType.STRICT).setConfirmationWindowSize(1).setStaticConnectors(connectorList);
        return ccc;
    }

    public static ServerLocator createLocator(int port) {
        TransportConfiguration config = SpawnedServerSupport.createTransportConfigiguration(false, port);
        return ActiveMQClient.createServerLocator((boolean)true, (TransportConfiguration[])new TransportConfiguration[]{config});
    }

    static TransportConfiguration createTransportConfigiguration(boolean acceptor, int port) {
        String className = acceptor ? NettyAcceptorFactory.class.getName() : NettyConnectorFactory.class.getName();
        HashMap<String, Integer> serverParams = new HashMap<String, Integer>();
        serverParams.put("port", port);
        return new TransportConfiguration(className, serverParams);
    }

    static ActiveMQServer createSharedFolderServer(String folder, int thisPort, int otherPort, boolean isBackup) {
        return ActiveMQServers.newActiveMQServer((Configuration)SpawnedServerSupport.createSharedFolderConfig(folder, thisPort, otherPort, isBackup), (boolean)true);
    }
}

