/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.command.ActiveMQDestination;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JMSConsumer8Test
extends BasicOpenWireTest {
    public int deliveryMode;
    public int ackMode;
    public byte destinationType;

    @Parameterized.Parameters(name="deliveryMode={0} ackMode={1} destinationType={2}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({1, 1, (byte)1}, {1, 2, (byte)1}, {2, 1, (byte)1}, {2, 2, (byte)1});
    }

    public JMSConsumer8Test(int deliveryMode, int ackMode, byte destinationType) {
        this.deliveryMode = deliveryMode;
        this.ackMode = ackMode;
        this.destinationType = destinationType;
    }

    @Test
    public void testMessageListenerAutoAckOnCloseWithPrefetch1() throws Exception {
        final AtomicInteger counter = new AtomicInteger(0);
        final CountDownLatch sendDone = new CountDownLatch(1);
        final CountDownLatch got2Done = new CountDownLatch(1);
        this.connection.getPrefetchPolicy().setAll(1);
        this.connection.setOptimizedMessageDispatch(false);
        this.connection.start();
        Session session = this.connection.createSession(false, this.ackMode);
        ActiveMQDestination destination = this.createDestination(session, this.destinationType);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message m) {
                try {
                    TextMessage tm = (TextMessage)m;
                    Assert.assertEquals((Object)("" + counter.get()), (Object)tm.getText());
                    counter.incrementAndGet();
                    m.acknowledge();
                    if (counter.get() == 2) {
                        sendDone.await();
                        JMSConsumer8Test.this.connection.close();
                        got2Done.countDown();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        this.sendMessages(session, (Destination)destination, 4);
        sendDone.countDown();
        JMSConsumer8Test.assertTrue((boolean)got2Done.await(100000L, TimeUnit.MILLISECONDS));
        this.connection = (ActiveMQConnection)this.factory.createConnection();
        this.connection.getPrefetchPolicy().setAll(1);
        this.connection.start();
        final CountDownLatch done2 = new CountDownLatch(1);
        session = this.connection.createSession(false, this.ackMode);
        consumer = session.createConsumer((Destination)destination);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message m) {
                try {
                    TextMessage tm = (TextMessage)m;
                    counter.incrementAndGet();
                    if (counter.get() == 4) {
                        done2.countDown();
                    }
                }
                catch (Throwable e) {
                    System.err.println("Unexpected exception " + e);
                }
            }
        });
        JMSConsumer8Test.assertTrue((boolean)done2.await(1000L, TimeUnit.MILLISECONDS));
        Thread.sleep(200L);
        JMSConsumer8Test.assertEquals((long)4L, (long)counter.get());
    }
}

