/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.tests.integration.openwire.OpenWireDivertTestBase;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.junit.Assert;
import org.junit.Test;

public class OpenWireDivertNonExclusiveTest
extends OpenWireDivertTestBase {
    @Override
    protected boolean isExclusive() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleNonExclusiveDivert() throws Exception {
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession coreSession = sf.createSession(false, true, true);
        SimpleString queueName1 = new SimpleString("queue1");
        SimpleString queueName2 = new SimpleString("queue2");
        coreSession.createQueue(new QueueConfiguration(queueName1).setAddress("forwardAddress").setDurable(Boolean.valueOf(false)));
        coreSession.createQueue(new QueueConfiguration(queueName2).setAddress("testAddress").setDurable(Boolean.valueOf(false)));
        ClientProducer producer = coreSession.createProducer(new SimpleString("testAddress"));
        boolean numMessages = true;
        SimpleString propKey = new SimpleString("testkey");
        for (int i = 0; i < 1; ++i) {
            ClientMessage message = coreSession.createMessage(false);
            message.putIntProperty(propKey, i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        coreSession.close();
        this.factory = new ActiveMQConnectionFactory("tcp://localhost:61616?wireFormat.cacheEnabled=true");
        try (Connection openwireConnection = this.factory.createConnection();){
            Message message;
            int i;
            Session session = openwireConnection.createSession(false, 1);
            openwireConnection.start();
            Queue q1 = session.createQueue(CompositeAddress.toFullyQualified((String)"testAddress", (String)"queue1"));
            Queue q2 = session.createQueue(CompositeAddress.toFullyQualified((String)"forwardAddress", (String)"queue2"));
            MessageConsumer consumer1 = session.createConsumer((Destination)q1);
            MessageConsumer consumer2 = session.createConsumer((Destination)q2);
            for (i = 0; i < 1; ++i) {
                message = consumer1.receive(3000L);
                Assert.assertNotNull((Object)message);
                Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey.toString()));
                message.acknowledge();
            }
            Assert.assertNull((Object)consumer1.receive(50L));
            for (i = 0; i < 1; ++i) {
                message = consumer2.receive(3000L);
                Assert.assertNotNull((Object)message);
                Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey.toString()));
                message.acknowledge();
            }
            Assert.assertNull((Object)consumer2.receive(50L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleNonExclusiveDivertOpenWirePublisher() throws Exception {
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession coreSession = sf.createSession(false, true, true);
        SimpleString queueName1 = new SimpleString("queue1");
        SimpleString queueName2 = new SimpleString("queue2");
        coreSession.createQueue(new QueueConfiguration(queueName1).setAddress("forwardAddress").setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        coreSession.createQueue(new QueueConfiguration(queueName2).setAddress("testAddress").setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        coreSession.close();
        this.factory = new ActiveMQConnectionFactory("tcp://localhost:61616?wireFormat.cacheEnabled=true");
        try (Connection openwireConnection = this.factory.createConnection();){
            Message message;
            int i;
            Session session = openwireConnection.createSession(false, 1);
            openwireConnection.start();
            MessageProducer producer = session.createProducer((Destination)session.createQueue("testAddress"));
            int numMessages = 10;
            String propKey = "testkey";
            for (int i2 = 0; i2 < 10; ++i2) {
                Message message2 = session.createMessage();
                message2.setIntProperty("testkey", i2);
                producer.send(message2);
            }
            Queue q1 = session.createQueue(CompositeAddress.toFullyQualified((String)"testAddress", (String)"queue1"));
            Queue q2 = session.createQueue(CompositeAddress.toFullyQualified((String)"forwardAddress", (String)"queue2"));
            MessageConsumer consumer1 = session.createConsumer((Destination)q1);
            MessageConsumer consumer2 = session.createConsumer((Destination)q2);
            for (i = 0; i < 10; ++i) {
                message = consumer1.receive(3000L);
                Assert.assertNotNull((Object)message);
                Assert.assertEquals((Object)i, (Object)message.getObjectProperty("testkey".toString()));
                message.acknowledge();
            }
            Assert.assertNull((Object)consumer1.receive(50L));
            for (i = 0; i < 10; ++i) {
                message = consumer2.receive(3000L);
                Assert.assertNotNull((Object)message);
                Assert.assertEquals((Object)i, (Object)message.getObjectProperty("testkey".toString()));
                message.acknowledge();
            }
            Assert.assertNull((Object)consumer2.receive(50L));
        }
    }
}

