/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.jms.client.ActiveMQQueue;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LargeMessageQueueAutoCreationTest
extends BasicOpenWireTest {
    Queue queue1;
    Random random = new Random();
    ActiveMQConnection testConn;
    ClientSession clientSession;
    @Parameterized.Parameter
    public boolean usingCore;

    @Parameterized.Parameters(name="isCore={0}")
    public static Collection<Object[]> params() {
        return Arrays.asList({true}, {false});
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        String randomSuffix = new BigInteger(130, this.random).toString(32);
        this.testConn = (ActiveMQConnection)this.coreCf.createConnection();
        this.clientSession = this.testConn.getSessionFactory().createSession();
        this.queue1 = this.createCoreQueue("queue1_" + randomSuffix);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.testConn.close();
        super.tearDown();
    }

    @Override
    protected void extraServerConfig(Configuration serverConfig) {
        serverConfig.setJournalType(JournalType.NIO);
        Map map = serverConfig.getAddressesSettings();
        Map.Entry entry = map.entrySet().iterator().next();
        AddressSettings settings = (AddressSettings)entry.getValue();
        settings.setAutoCreateQueues(Boolean.valueOf(true));
    }

    protected Queue createCoreQueue(String queueName) throws Exception {
        SimpleString address = SimpleString.toSimpleString((String)queueName);
        this.clientSession.createAddress(address, RoutingType.ANYCAST, false);
        return new ActiveMQQueue(queueName);
    }

    @Test(timeout=30000L)
    public void testSmallString() throws Exception {
        this.sendStringOfSize(1024);
    }

    @Test(timeout=30000L)
    public void testHugeString() throws Exception {
        this.sendStringOfSize(0x100000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStringOfSize(int msgSize) throws JMSException {
        ConnectionFactory factoryToUse = this.usingCore ? this.coreCf : this.factory;
        try (Connection conn = factoryToUse.createConnection();){
            Session session = conn.createSession(false, 1);
            MessageProducer prod = session.createProducer((Destination)this.queue1);
            TextMessage m = session.createTextMessage();
            m.setJMSDeliveryMode(2);
            StringBuffer buffer = new StringBuffer();
            while (buffer.length() < msgSize) {
                buffer.append(UUIDGenerator.getInstance().generateStringUUID());
            }
            String originalString = buffer.toString();
            m.setText(originalString);
            prod.send((Message)m);
            conn.close();
            conn = factoryToUse.createConnection();
            session = conn.createSession(false, 1);
            MessageConsumer cons = session.createConsumer((Destination)this.queue1);
            conn.start();
            TextMessage rm = (TextMessage)cons.receive(5000L);
            Assert.assertNotNull((Object)rm);
            String str = rm.getText();
            Assert.assertEquals((Object)originalString, (Object)str);
        }
    }
}

