/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt.imported;

import java.net.URL;
import java.util.Arrays;
import org.apache.activemq.artemis.tests.integration.mqtt.imported.MQTTTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.fusesource.mqtt.client.BlockingConnection;
import org.fusesource.mqtt.client.MQTT;
import org.junit.Test;

public class MQTTSecurityPerAcceptorTest
extends MQTTTestSupport {
    @Override
    public boolean isSecurityEnabled() {
        return true;
    }

    @Override
    public void configureBroker() throws Exception {
        this.server = this.createServer(true, this.createDefaultConfig(true).setSecurityEnabled(true));
        this.server.getConfiguration().addAcceptorConfiguration("MQTT", "tcp://localhost:" + this.port + "?securityDomain=PropertiesLogin");
    }

    @Test(timeout=30000L)
    public void testConnectionPositive() throws Exception {
        this.internalTestConnection("first", true);
    }

    @Test(timeout=30000L)
    public void testConnectionNegative() throws Exception {
        this.internalTestConnection("fail", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalTestConnection(String username, boolean succeed) throws Exception {
        for (String version : Arrays.asList("3.1", "3.1.1")) {
            BlockingConnection connection = null;
            try {
                block7: {
                    MQTT mqtt = this.createMQTTConnection("test-" + version, true);
                    mqtt.setUserName(username);
                    mqtt.setPassword("secret");
                    mqtt.setConnectAttemptsMax(1L);
                    mqtt.setVersion(version);
                    connection = mqtt.blockingConnection();
                    try {
                        connection.connect();
                        if (!succeed) {
                            MQTTSecurityPerAcceptorTest.fail((String)"Connection should have failed");
                        }
                    }
                    catch (Exception e) {
                        if (!succeed) break block7;
                        MQTTSecurityPerAcceptorTest.fail((String)"Connection should have succeeded");
                    }
                }
                BlockingConnection finalConnection = connection;
                if (!succeed) continue;
                MQTTSecurityPerAcceptorTest.assertTrue((String)"Should be connected", (boolean)Wait.waitFor(() -> finalConnection.isConnected(), (long)2000L, (long)100L));
            }
            finally {
                if (connection == null || !connection.isConnected()) continue;
                connection.disconnect();
            }
        }
    }

    static {
        URL resource;
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = MQTTSecurityPerAcceptorTest.class.getClassLoader().getResource("login.config")) != null) {
            path = resource.getFile();
            System.setProperty("java.security.auth.login.config", path);
        }
    }
}

