/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.tests.integration.management.SecurityManagementTestBase;
import org.junit.Test;

public class SecurityManagementWithModifiedConfigurationTest
extends SecurityManagementTestBase {
    private final String configuredClusterPassword = "this is not the default password";

    @Test
    public void testSendManagementMessageWithModifiedClusterAdminUser() throws Exception {
        this.doSendManagementMessage(ActiveMQDefaultConfiguration.getDefaultClusterUser(), "this is not the default password", true);
    }

    @Test
    public void testSendManagementMessageWithDefaultClusterAdminUser() throws Exception {
        this.doSendManagementMessage(ActiveMQDefaultConfiguration.getDefaultClusterUser(), ActiveMQDefaultConfiguration.getDefaultClusterPassword(), false);
    }

    @Test
    public void testSendManagementMessageWithGuest() throws Exception {
        this.doSendManagementMessage("guest", "guest", false);
    }

    @Test
    public void testSendManagementMessageWithoutUserCredentials() throws Exception {
        this.doSendManagementMessage(null, null, false);
    }

    @Override
    protected ActiveMQServer setupAndStartActiveMQServer() throws Exception {
        Configuration conf = this.createDefaultInVMConfig().setSecurityEnabled(true).setClusterPassword("this is not the default password");
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)conf, (boolean)false));
        server.start();
        return server;
    }
}

