/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.management.BrokerBalancerControl;
import org.apache.activemq.artemis.core.server.balancing.targets.TargetKey;
import org.apache.activemq.artemis.tests.integration.balancing.BalancingTestBase;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BrokerBalancerControlTest
extends BalancingTestBase {
    private MBeanServer mbeanServer;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.mbeanServer = MBeanServerFactory.createMBeanServer();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        MBeanServerFactory.releaseMBeanServer(this.mbeanServer);
    }

    @Test
    public void testGetTarget() throws Exception {
        BrokerBalancerControl brokerBalancerControl = this.getBrokerBalancerControlForTarget();
        CompositeData targetData = brokerBalancerControl.getTarget("admin");
        Assert.assertNotNull((Object)targetData);
        String nodeID = (String)targetData.get("nodeID");
        Assert.assertEquals((Object)this.getServer(1).getNodeID().toString(), (Object)nodeID);
        Boolean local = (Boolean)targetData.get("local");
        Assert.assertEquals((Object)false, (Object)local);
        CompositeData connectorData = (CompositeData)targetData.get("connector");
        Assert.assertNotNull((Object)connectorData);
        TransportConfiguration connector = this.getDefaultServerConnector(1);
        String connectorName = (String)connectorData.get("name");
        Assert.assertEquals((Object)connector.getName(), (Object)connectorName);
        String connectorFactoryClassName = (String)connectorData.get("factoryClassName");
        Assert.assertEquals((Object)connector.getFactoryClassName(), (Object)connectorFactoryClassName);
        TabularData connectorParams = (TabularData)connectorData.get("params");
        Assert.assertNotNull((Object)connectorParams);
        for (Map.Entry param : connector.getParams().entrySet()) {
            CompositeData paramData = connectorParams.get(new Object[]{param.getKey()});
            Assert.assertEquals((Object)String.valueOf(param.getValue()), (Object)paramData.get("value"));
        }
    }

    @Test
    public void testGetTargetAsJSON() throws Exception {
        BrokerBalancerControl brokerBalancerControl = this.getBrokerBalancerControlForTarget();
        String targetJSON = brokerBalancerControl.getTargetAsJSON("admin");
        Assert.assertNotNull((Object)targetJSON);
        JsonObject targetData = JsonUtil.readJsonObject((String)targetJSON);
        Assert.assertNotNull((Object)targetData);
        String nodeID = targetData.getString("nodeID");
        Assert.assertEquals((Object)this.getServer(1).getNodeID().toString(), (Object)nodeID);
        Boolean local = targetData.getBoolean("local");
        Assert.assertEquals((Object)false, (Object)local);
        JsonObject connectorData = targetData.getJsonObject("connector");
        Assert.assertNotNull((Object)connectorData);
        TransportConfiguration connector = this.getDefaultServerConnector(1);
        String connectorName = connectorData.getString("name");
        Assert.assertEquals((Object)connector.getName(), (Object)connectorName);
        String connectorFactoryClassName = connectorData.getString("factoryClassName");
        Assert.assertEquals((Object)connector.getFactoryClassName(), (Object)connectorFactoryClassName);
        JsonObject connectorParams = connectorData.getJsonObject("params");
        Assert.assertNotNull((Object)connectorParams);
        for (Map.Entry param : connector.getParams().entrySet()) {
            JsonValue paramData = (JsonValue)connectorParams.get(param.getKey());
            Assert.assertEquals((Object)String.valueOf(param.getValue()), (Object)paramData.toString());
        }
    }

    @Test
    public void testGetLocalTarget() throws Exception {
        BrokerBalancerControl brokerBalancerControl = this.getBrokerBalancerControlForLocalTarget();
        CompositeData targetData = brokerBalancerControl.getTarget("admin");
        Assert.assertNotNull((Object)targetData);
        String nodeID = (String)targetData.get("nodeID");
        Assert.assertEquals((Object)this.getServer(0).getNodeID().toString(), (Object)nodeID);
        Boolean local = (Boolean)targetData.get("local");
        Assert.assertEquals((Object)true, (Object)local);
        CompositeData connectorData = (CompositeData)targetData.get("connector");
        Assert.assertNull((Object)connectorData);
    }

    @Test
    public void testGetLocalTargetAsJSON() throws Exception {
        BrokerBalancerControl brokerBalancerControl = this.getBrokerBalancerControlForLocalTarget();
        String targetJSON = brokerBalancerControl.getTargetAsJSON("admin");
        Assert.assertNotNull((Object)targetJSON);
        JsonObject targetData = JsonUtil.readJsonObject((String)targetJSON);
        Assert.assertNotNull((Object)targetData);
        String nodeID = targetData.getString("nodeID");
        Assert.assertEquals((Object)this.getServer(0).getNodeID().toString(), (Object)nodeID);
        Boolean local = targetData.getBoolean("local");
        Assert.assertEquals((Object)true, (Object)local);
        Assert.assertTrue((boolean)targetData.isNull("connector"));
    }

    private BrokerBalancerControl getBrokerBalancerControlForTarget() throws Exception {
        this.setupLiveServerWithDiscovery(0, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        this.setupBalancerServerWithDiscovery(0, TargetKey.USER_NAME, "FIRST_ELEMENT", null, false, null, 1);
        this.getServer(0).setMBeanServer(this.mbeanServer);
        this.setupLiveServerWithDiscovery(1, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        this.startServers(0, 1);
        return ManagementControlHelper.createBrokerBalancerControl("bb1", this.mbeanServer);
    }

    private BrokerBalancerControl getBrokerBalancerControlForLocalTarget() throws Exception {
        this.setupLiveServerWithDiscovery(0, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        this.setupBalancerServerWithDiscovery(0, TargetKey.USER_NAME, "FIRST_ELEMENT", null, true, null, 1);
        this.getServer(0).setMBeanServer(this.mbeanServer);
        this.startServers(0);
        return ManagementControlHelper.createBrokerBalancerControl("bb1", this.mbeanServer);
    }
}

