/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.List;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TextMessageTest
extends JMSTestBase {
    private Queue queue;

    @Test
    public void testSendReceiveNullBody() throws Exception {
        this.conn = this.cf.createConnection();
        Session sess = this.conn.createSession(false, 1);
        MessageProducer prod = sess.createProducer((Destination)this.queue);
        this.conn.start();
        MessageConsumer cons = sess.createConsumer((Destination)this.queue);
        TextMessage msg1 = sess.createTextMessage(null);
        prod.send((Message)msg1);
        TextMessage received1 = (TextMessage)cons.receive(1000L);
        Assert.assertNotNull((Object)received1);
        Assert.assertNull((Object)received1.getText());
        TextMessage msg2 = sess.createTextMessage();
        msg2.setText(null);
        prod.send((Message)msg2);
        TextMessage received2 = (TextMessage)cons.receive(1000L);
        Assert.assertNotNull((Object)received2);
        Assert.assertNull((Object)received2.getText());
        TextMessage msg3 = sess.createTextMessage();
        prod.send((Message)msg3);
        TextMessage received3 = (TextMessage)cons.receive(1000L);
        Assert.assertNotNull((Object)received3);
        Assert.assertNull((Object)received3.getText());
    }

    @Test
    public void testSendReceiveWithBody0() throws Exception {
        this.testSendReceiveWithBody(0);
    }

    @Test
    public void testSendReceiveWithBody1() throws Exception {
        this.testSendReceiveWithBody(1);
    }

    @Test
    public void testSendReceiveWithBody9() throws Exception {
        this.testSendReceiveWithBody(9);
    }

    @Test
    public void testSendReceiveWithBody20() throws Exception {
        this.testSendReceiveWithBody(20);
    }

    @Test
    public void testSendReceiveWithBody10000() throws Exception {
        this.testSendReceiveWithBody(10000);
    }

    @Test
    public void testSendReceiveWithBody0xffff() throws Exception {
        this.testSendReceiveWithBody(65535);
    }

    @Test
    public void testSendReceiveWithBody0xffffplus1() throws Exception {
        this.testSendReceiveWithBody(65536);
    }

    @Test
    public void testSendReceiveWithBody0xfffftimes2() throws Exception {
        this.testSendReceiveWithBody(131070);
    }

    private void testSendReceiveWithBody(int bodyLength) throws Exception {
        this.conn = this.cf.createConnection();
        char[] chrs = new char[bodyLength];
        for (int i = 0; i < bodyLength; ++i) {
            chrs[i] = RandomUtil.randomChar();
        }
        String str = new String(chrs);
        Session sess = this.conn.createSession(false, 1);
        MessageProducer prod = sess.createProducer((Destination)this.queue);
        this.conn.start();
        MessageConsumer cons = sess.createConsumer((Destination)this.queue);
        TextMessage msg1 = sess.createTextMessage(str);
        prod.send((Message)msg1);
        TextMessage received1 = (TextMessage)cons.receive(1000L);
        Assert.assertNotNull((Object)received1);
        Assert.assertEquals((Object)str, (Object)received1.getText());
        TextMessage msg2 = sess.createTextMessage();
        msg2.setText(str);
        prod.send((Message)msg2);
        TextMessage received2 = (TextMessage)cons.receive(1000L);
        Assert.assertNotNull((Object)received2);
        Assert.assertEquals((Object)str, (Object)received2.getText());
        TextMessageTest.assertEquals((Object)str, (Object)msg2.getText());
        prod.send((Message)received2);
        TextMessageTest.assertEquals((Object)str, (Object)received2.getText());
        TextMessage received3 = (TextMessage)cons.receive(1000L);
        Assert.assertNotNull((Object)received3);
        TextMessageTest.assertEquals((Object)str, (Object)received3.getText());
        prod.send((Message)received3);
        TextMessageTest.assertEquals((Object)str, (Object)received3.getText());
        TextMessage received4 = (TextMessage)cons.receive(1000L);
        Assert.assertNotNull((Object)received4);
        TextMessageTest.assertEquals((Object)str, (Object)received4.getText());
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.queue = this.createQueue("queue1");
    }

    @Override
    protected void createCF(List<TransportConfiguration> connectorConfigs, String ... jndiBindings) throws Exception {
        int retryInterval = 1000;
        double retryIntervalMultiplier = 1.0;
        int reconnectAttempts = -1;
        int callTimeout = 30000;
        this.jmsServer.createConnectionFactory("ManualReconnectionToSingleServerTest", false, JMSFactoryType.CF, (List)this.registerConnectors(this.server, connectorConfigs), null, ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD, ActiveMQClient.DEFAULT_CONNECTION_TTL, (long)callTimeout, 30000L, true, 102400, false, 0x100000, -1, -1, 65536, -1, false, true, false, false, false, ActiveMQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME, 0x100000, 0x100000, true, 5, -1, (long)retryInterval, retryIntervalMultiplier, ActiveMQClient.DEFAULT_MAX_RETRY_INTERVAL, reconnectAttempts, false, null, jndiBindings);
    }
}

