/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.interceptors;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientConsumerImpl;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.ServerSessionPacketHandler;
import org.apache.activemq.artemis.core.protocol.core.impl.ChannelImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.RemotingConnectionImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateQueueMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.MessagePacket;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionCreateConsumerMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionReceiveMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionSendMessage;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.integration.interceptors.Incoming;
import org.apache.activemq.artemis.tests.integration.interceptors.Outgoing;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InterceptorTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private final SimpleString QUEUE = new SimpleString("InterceptorTestQueue");
    private ServerLocator locator;
    private static final String key = "fruit";

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false, true);
        this.server.start();
        this.locator = this.createNettyNonHALocator();
    }

    private boolean isForceDeliveryResponse(Packet packet) {
        SessionReceiveMessage msg;
        return packet.getType() == 75 && (msg = (SessionReceiveMessage)packet).getMessage().containsProperty(ClientConsumerImpl.FORCED_DELIVERY_MESSAGE);
    }

    @Test
    public void testServerInterceptorChangeProperty() throws Exception {
        ClientMessage message;
        int i;
        MyInterceptor1 interceptor = new MyInterceptor1();
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)interceptor);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true, true);
        session.createQueue(new QueueConfiguration(this.QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 10;
        for (int i2 = 0; i2 < 10; ++i2) {
            ClientMessage message2 = session.createMessage(false);
            message2.putIntProperty("count", i2);
            message2.putStringProperty(key, "apple");
            producer.send((org.apache.activemq.artemis.api.core.Message)message2);
        }
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        session.start();
        for (i = 0; i < 10; ++i) {
            message = consumer.receive(1000L);
            InterceptorTest.assertNotNull((Object)message);
            InterceptorTest.assertEquals((long)i, (long)message.getIntProperty("count").intValue());
            Assert.assertEquals((Object)"orange", (Object)message.getStringProperty(key));
        }
        this.server.getRemotingService().removeIncomingInterceptor((BaseInterceptor)interceptor);
        for (i = 0; i < 10; ++i) {
            message = session.createMessage(false);
            message.putStringProperty(key, "apple");
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        for (i = 0; i < 10; ++i) {
            message = consumer.receive(1000L);
            Assert.assertEquals((Object)"apple", (Object)message.getStringProperty(key));
        }
        session.close();
    }

    @Test
    public void testInterceptUsernameOnQueues() throws Exception {
        SimpleString ANOTHER_QUEUE = this.QUEUE.concat("another");
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)this.server.getSecurityManager();
        securityManager.getConfiguration().addUser("dumb", "dumber");
        securityManager.getConfiguration().addUser("an", "other");
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)new InterceptUserOnCreateQueue());
        this.locator.setBlockOnDurableSend(true);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession("dumb", "dumber", false, false, false, false, 0);
        ClientSession sessionAnotherUser = sf.createSession("an", "other", false, false, false, false, 0);
        session.createQueue(new QueueConfiguration(this.QUEUE));
        sessionAnotherUser.createQueue(new QueueConfiguration(ANOTHER_QUEUE).setAddress(this.QUEUE));
        ClientProducer prod = session.createProducer(this.QUEUE);
        ClientProducer prodAnother = sessionAnotherUser.createProducer(this.QUEUE);
        ClientMessage msg = session.createMessage(true);
        prod.send((org.apache.activemq.artemis.api.core.Message)msg);
        session.commit();
        prodAnother.send((org.apache.activemq.artemis.api.core.Message)msg);
        sessionAnotherUser.commit();
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        ClientConsumer consumerAnother = sessionAnotherUser.createConsumer(ANOTHER_QUEUE);
        session.start();
        sessionAnotherUser.start();
        msg = consumer.receive(1000L);
        InterceptorTest.assertNotNull((Object)msg);
        InterceptorTest.assertEquals((Object)"dumb", (Object)msg.getStringProperty("userName"));
        msg.acknowledge();
        InterceptorTest.assertNull((Object)consumer.receiveImmediate());
        msg = consumerAnother.receive(1000L);
        InterceptorTest.assertNotNull((Object)msg);
        InterceptorTest.assertEquals((Object)"an", (Object)msg.getStringProperty("userName"));
        msg.acknowledge();
        InterceptorTest.assertNull((Object)consumerAnother.receiveImmediate());
        session.close();
        sessionAnotherUser.close();
    }

    @Test
    public void testInterceptUsernameOnConsumer() throws Exception {
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)this.server.getSecurityManager();
        securityManager.getConfiguration().addUser("dumb", "dumber");
        securityManager.getConfiguration().addUser("an", "other");
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)new InterceptUserOnCreateConsumer());
        this.locator.setBlockOnDurableSend(true);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession("dumb", "dumber", false, false, false, false, 0);
        ClientSession sessionAnotherUser = sf.createSession("an", "other", false, false, false, false, 0);
        session.createQueue(new QueueConfiguration(this.QUEUE));
        ClientProducer prod = session.createProducer(this.QUEUE);
        ClientProducer prodAnother = sessionAnotherUser.createProducer(this.QUEUE);
        ClientMessage msg = session.createMessage(true);
        prod.send((org.apache.activemq.artemis.api.core.Message)msg);
        session.commit();
        prodAnother.send((org.apache.activemq.artemis.api.core.Message)msg);
        sessionAnotherUser.commit();
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        ClientConsumer consumerAnother = sessionAnotherUser.createConsumer(this.QUEUE);
        session.start();
        sessionAnotherUser.start();
        msg = consumer.receive(1000L);
        InterceptorTest.assertNotNull((Object)msg);
        InterceptorTest.assertEquals((Object)"dumb", (Object)msg.getStringProperty("userName"));
        msg.acknowledge();
        InterceptorTest.assertNull((Object)consumer.receiveImmediate());
        msg = consumerAnother.receive(1000L);
        InterceptorTest.assertNotNull((Object)msg);
        InterceptorTest.assertEquals((Object)"an", (Object)msg.getStringProperty("userName"));
        msg.acknowledge();
        InterceptorTest.assertNull((Object)consumerAnother.receiveImmediate());
        session.close();
        sessionAnotherUser.close();
    }

    @Test
    public void testServerInterceptorRejectPacket() throws Exception {
        ClientMessage message;
        MyInterceptor2 interceptor = new MyInterceptor2();
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)interceptor);
        this.locator.setBlockOnNonDurableSend(false);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true, true);
        session.createQueue(new QueueConfiguration(this.QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 10;
        for (int i = 0; i < 10; ++i) {
            message = session.createMessage(false);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        session.start();
        message = consumer.receiveImmediate();
        Assert.assertNull((Object)message);
        session.close();
    }

    @Test
    public void testClientInterceptorChangeProperty() throws Exception {
        ClientMessage message;
        int i;
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        MyInterceptor3 interceptor = new MyInterceptor3();
        sf.getServerLocator().addIncomingInterceptor((Interceptor)interceptor);
        ClientSession session = sf.createSession(false, true, true, true);
        session.createQueue(new QueueConfiguration(this.QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 10;
        for (int i2 = 0; i2 < 10; ++i2) {
            ClientMessage message2 = session.createMessage(false);
            message2.putStringProperty(key, "apple");
            producer.send((org.apache.activemq.artemis.api.core.Message)message2);
        }
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        session.start();
        for (i = 0; i < 10; ++i) {
            message = consumer.receive(1000L);
            Assert.assertEquals((Object)"orange", (Object)message.getStringProperty(key));
        }
        sf.getServerLocator().removeIncomingInterceptor((Interceptor)interceptor);
        for (i = 0; i < 10; ++i) {
            message = session.createMessage(false);
            message.putStringProperty(key, "apple");
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        for (i = 0; i < 10; ++i) {
            message = consumer.receive(1000L);
            Assert.assertEquals((Object)"apple", (Object)message.getStringProperty(key));
        }
        session.close();
    }

    @Test
    public void testClientOutgoingInterceptorChangeProperty() throws Exception {
        ClientMessage message;
        int i;
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        MyOutgoingInterceptor3 interceptor = new MyOutgoingInterceptor3();
        sf.getServerLocator().addOutgoingInterceptor((Interceptor)interceptor);
        ClientSession session = sf.createSession(false, true, true, true);
        session.createQueue(new QueueConfiguration(this.QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 10;
        for (int i2 = 0; i2 < 10; ++i2) {
            ClientMessage message2 = session.createMessage(false);
            message2.putStringProperty(key, "apple");
            producer.send((org.apache.activemq.artemis.api.core.Message)message2);
        }
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        session.start();
        for (i = 0; i < 10; ++i) {
            message = consumer.receive(1000L);
            Assert.assertEquals((Object)"orange", (Object)message.getStringProperty(key));
        }
        sf.getServerLocator().removeOutgoingInterceptor((Interceptor)interceptor);
        for (i = 0; i < 10; ++i) {
            message = session.createMessage(false);
            message.putStringProperty(key, "apple");
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        for (i = 0; i < 10; ++i) {
            message = consumer.receive(1000L);
            Assert.assertEquals((Object)"apple", (Object)message.getStringProperty(key));
        }
        session.close();
    }

    @Test
    public void testClientInterceptorRejectPacket() throws Exception {
        ClientMessage message;
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        MyInterceptor4 interceptor = new MyInterceptor4();
        sf.getServerLocator().addIncomingInterceptor((Interceptor)interceptor);
        ClientSession session = sf.createSession(false, true, true, true);
        session.createQueue(new QueueConfiguration(this.QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 10;
        for (int i = 0; i < 10; ++i) {
            message = session.createMessage(false);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        session.start();
        message = consumer.receive(100L);
        Assert.assertNull((Object)message);
        session.close();
    }

    @Test
    public void testClientOutgoingInterceptorRejectPacketOnNonBlockingSend() throws Exception {
        ClientMessage message;
        this.locator.setBlockOnNonDurableSend(false);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        MyOutgoingInterceptor4 interceptor = new MyOutgoingInterceptor4();
        sf.getServerLocator().addOutgoingInterceptor((Interceptor)interceptor);
        ClientSession session = sf.createSession(false, true, true, true);
        session.createQueue(new QueueConfiguration(this.QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 10;
        for (int i = 0; i < 10; ++i) {
            message = session.createMessage(false);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        session.start();
        message = consumer.receive(100L);
        Assert.assertNull((Object)message);
        session.close();
    }

    @Test
    public void testClientOutgoingInterceptorRejectPacketOnBlockingSend() throws Exception {
        this.locator.setBlockOnNonDurableSend(true);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        MyOutgoingInterceptor4 interceptor = new MyOutgoingInterceptor4();
        sf.getServerLocator().addOutgoingInterceptor((Interceptor)interceptor);
        ClientSession session = sf.createSession(false, true, true, true);
        session.createQueue(new QueueConfiguration(this.QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.QUEUE);
        ClientMessage message = session.createMessage(false);
        try {
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            Assert.fail();
        }
        catch (ActiveMQException e) {
            Assert.assertTrue((e.getType().getCode() == ActiveMQExceptionType.INTERCEPTOR_REJECTED_PACKET.getCode() ? (byte)1 : 0) != 0);
        }
    }

    @Test
    public void testServerMultipleInterceptors() throws Exception {
        ClientMessage message;
        int i;
        MyInterceptor5 interceptor1 = new MyInterceptor5("a", 1);
        MyInterceptor5 interceptor2 = new MyInterceptor5("b", 2);
        MyInterceptor5 interceptor3 = new MyInterceptor5("c", 3);
        MyInterceptor5 interceptor4 = new MyInterceptor5("d", 4);
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)interceptor1);
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)interceptor2);
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)interceptor3);
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)interceptor4);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true, true);
        session.createQueue(new QueueConfiguration(this.QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 10;
        for (int i2 = 0; i2 < 10; ++i2) {
            ClientMessage message2 = session.createMessage(false);
            producer.send((org.apache.activemq.artemis.api.core.Message)message2);
        }
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        session.start();
        for (i = 0; i < 10; ++i) {
            message = consumer.receive(1000L);
            Assert.assertEquals((long)1L, (long)message.getIntProperty("a").intValue());
            Assert.assertEquals((long)2L, (long)message.getIntProperty("b").intValue());
            Assert.assertEquals((long)3L, (long)message.getIntProperty("c").intValue());
            Assert.assertEquals((long)4L, (long)message.getIntProperty("d").intValue());
        }
        this.server.getRemotingService().removeIncomingInterceptor((BaseInterceptor)interceptor2);
        for (i = 0; i < 10; ++i) {
            message = session.createMessage(false);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        for (i = 0; i < 10; ++i) {
            message = consumer.receive(1000L);
            Assert.assertEquals((long)1L, (long)message.getIntProperty("a").intValue());
            Assert.assertFalse((boolean)message.containsProperty("b"));
            Assert.assertEquals((long)3L, (long)message.getIntProperty("c").intValue());
            Assert.assertEquals((long)4L, (long)message.getIntProperty("d").intValue());
        }
        interceptor3.setReject(true);
        interceptor1.setWasCalled(false);
        interceptor2.setWasCalled(false);
        interceptor3.setWasCalled(false);
        interceptor4.setWasCalled(false);
        for (i = 0; i < 10; ++i) {
            message = session.createMessage(false);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        ClientMessage message3 = consumer.receiveImmediate();
        Assert.assertNull((Object)message3);
        Assert.assertTrue((boolean)interceptor1.wasCalled());
        Assert.assertFalse((boolean)interceptor2.wasCalled());
        Assert.assertTrue((boolean)interceptor3.wasCalled());
        Assert.assertFalse((boolean)interceptor4.wasCalled());
        session.close();
    }

    @Test
    public void testClientMultipleInterceptors() throws Exception {
        ClientMessage message;
        int i;
        MyInterceptor6 interceptor1 = new MyInterceptor6("a", 1);
        MyInterceptor6 interceptor2 = new MyInterceptor6("b", 2);
        MyInterceptor6 interceptor3 = new MyInterceptor6("c", 3);
        MyInterceptor6 interceptor4 = new MyInterceptor6("d", 4);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        sf.getServerLocator().addIncomingInterceptor((Interceptor)interceptor1);
        sf.getServerLocator().addIncomingInterceptor((Interceptor)interceptor2);
        sf.getServerLocator().addIncomingInterceptor((Interceptor)interceptor3);
        sf.getServerLocator().addIncomingInterceptor((Interceptor)interceptor4);
        ClientSession session = sf.createSession(false, true, true, true);
        session.createQueue(new QueueConfiguration(this.QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 10;
        for (int i2 = 0; i2 < 10; ++i2) {
            ClientMessage message2 = session.createMessage(false);
            producer.send((org.apache.activemq.artemis.api.core.Message)message2);
        }
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        session.start();
        for (i = 0; i < 10; ++i) {
            message = consumer.receive(1000L);
            Assert.assertEquals((long)1L, (long)message.getIntProperty("a").intValue());
            Assert.assertEquals((long)2L, (long)message.getIntProperty("b").intValue());
            Assert.assertEquals((long)3L, (long)message.getIntProperty("c").intValue());
            Assert.assertEquals((long)4L, (long)message.getIntProperty("d").intValue());
        }
        sf.getServerLocator().removeIncomingInterceptor((Interceptor)interceptor2);
        for (i = 0; i < 10; ++i) {
            message = session.createMessage(false);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        for (i = 0; i < 10; ++i) {
            message = consumer.receive(1000L);
            Assert.assertEquals((long)1L, (long)message.getIntProperty("a").intValue());
            Assert.assertFalse((boolean)message.containsProperty("b"));
            Assert.assertEquals((long)3L, (long)message.getIntProperty("c").intValue());
            Assert.assertEquals((long)4L, (long)message.getIntProperty("d").intValue());
        }
        interceptor3.setReject(true);
        interceptor1.setWasCalled(false);
        interceptor2.setWasCalled(false);
        interceptor3.setWasCalled(false);
        interceptor4.setWasCalled(false);
        for (i = 0; i < 10; ++i) {
            message = session.createMessage(false);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        ClientMessage message3 = consumer.receive(100L);
        Assert.assertNull((Object)message3);
        Assert.assertTrue((boolean)interceptor1.wasCalled());
        Assert.assertFalse((boolean)interceptor2.wasCalled());
        Assert.assertTrue((boolean)interceptor3.wasCalled());
        Assert.assertFalse((boolean)interceptor4.wasCalled());
        session.close();
    }

    @Test
    public void testServerOutgoingInterceptorChangeProperty() throws Exception {
        ClientMessage message;
        int i;
        MyOutgoingInterceptor1 interceptor = new MyOutgoingInterceptor1();
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)interceptor);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true, true);
        session.createQueue(new QueueConfiguration(this.QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 10;
        for (int i2 = 0; i2 < 10; ++i2) {
            ClientMessage message2 = session.createMessage(false);
            message2.putIntProperty("count", i2);
            message2.putStringProperty(key, "apple");
            producer.send((org.apache.activemq.artemis.api.core.Message)message2);
        }
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        session.start();
        for (i = 0; i < 10; ++i) {
            message = consumer.receive(1000L);
            InterceptorTest.assertNotNull((Object)message);
            InterceptorTest.assertEquals((long)i, (long)message.getIntProperty("count").intValue());
            Assert.assertEquals((Object)"orange", (Object)message.getStringProperty(key));
        }
        this.server.getRemotingService().removeOutgoingInterceptor((BaseInterceptor)interceptor);
        for (i = 0; i < 10; ++i) {
            message = session.createMessage(false);
            message.putStringProperty(key, "apple");
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        for (i = 0; i < 10; ++i) {
            message = consumer.receive(1000L);
            Assert.assertEquals((Object)"apple", (Object)message.getStringProperty(key));
        }
        session.close();
    }

    @Test
    public void testServerOutgoingInterceptorRejectMessage() throws Exception {
        ClientMessage message;
        MyOutgoingInterceptor2 interceptor = new MyOutgoingInterceptor2();
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)interceptor);
        this.locator.setBlockOnNonDurableSend(false);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true, true);
        session.createQueue(new QueueConfiguration(this.QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 10;
        for (int i = 0; i < 10; ++i) {
            message = session.createMessage(false);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        session.start();
        message = consumer.receiveImmediate();
        Assert.assertNull((Object)message);
        session.close();
    }

    @Test
    public void testInterceptorOnURI() throws Exception {
        this.locator.close();
        this.server.createQueue(new QueueConfiguration(this.QUEUE).setRoutingType(RoutingType.ANYCAST));
        String uri = "tcp://localhost:61616?incomingInterceptorList=" + Incoming.class.getCanonicalName() + "&outgoingInterceptorList=" + Outgoing.class.getName();
        this.instanceLog.debug((Object)uri);
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(uri);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.close();
        objectOutputStream.writeObject(factory);
        ByteArrayInputStream input = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ObjectInputStream objectInputStream = new ObjectInputStream(input);
        factory = (ActiveMQConnectionFactory)objectInputStream.readObject();
        Connection connection = factory.createConnection();
        Session session = connection.createSession();
        MessageProducer producer = session.createProducer((Destination)session.createQueue(this.QUEUE.toString()));
        producer.send((Message)session.createTextMessage("HelloMessage"));
        connection.start();
        MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(this.QUEUE.toString()));
        TextMessage msg = (TextMessage)consumer.receive(5000L);
        Assert.assertNotNull((Object)msg);
        Assert.assertEquals((Object)"HelloMessage", (Object)msg.getText());
        Assert.assertEquals((Object)"was here", (Object)msg.getStringProperty("Incoming"));
        Assert.assertEquals((Object)"sending", (Object)msg.getStringProperty("Outgoing"));
        connection.close();
        factory.close();
    }

    private class MyInterceptor6
    implements Interceptor {
        private final String key;
        private final int num;
        private volatile boolean reject;
        private volatile boolean wasCalled;

        MyInterceptor6(String key, int num) {
            this.key = key;
            this.num = num;
        }

        public void setReject(boolean reject) {
            this.reject = reject;
        }

        public boolean wasCalled() {
            return this.wasCalled;
        }

        public void setWasCalled(boolean wasCalled) {
            this.wasCalled = wasCalled;
        }

        public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
            if (InterceptorTest.this.isForceDeliveryResponse(packet)) {
                return true;
            }
            if (packet.getType() == 75) {
                SessionReceiveMessage p = (SessionReceiveMessage)packet;
                ICoreMessage sm = p.getMessage();
                sm.putIntProperty(this.key, this.num);
                this.wasCalled = true;
                return !this.reject;
            }
            return true;
        }
    }

    private class MyInterceptor5
    implements Interceptor {
        private final String key;
        private final int num;
        private volatile boolean reject;
        private volatile boolean wasCalled;

        MyInterceptor5(String key, int num) {
            this.key = key;
            this.num = num;
        }

        public void setReject(boolean reject) {
            this.reject = reject;
        }

        public boolean wasCalled() {
            return this.wasCalled;
        }

        public void setWasCalled(boolean wasCalled) {
            this.wasCalled = wasCalled;
        }

        public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
            if (packet.getType() == 71) {
                SessionSendMessage p = (SessionSendMessage)packet;
                ICoreMessage sm = p.getMessage();
                sm.putIntProperty(this.key, this.num);
                this.wasCalled = true;
                return !this.reject;
            }
            return true;
        }
    }

    private class MyOutgoingInterceptor4
    implements Interceptor {
        private MyOutgoingInterceptor4() {
        }

        public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
            if (InterceptorTest.this.isForceDeliveryResponse(packet)) {
                return true;
            }
            return packet.getType() != 71;
        }
    }

    private class MyInterceptor4
    implements Interceptor {
        private MyInterceptor4() {
        }

        public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
            if (InterceptorTest.this.isForceDeliveryResponse(packet)) {
                return true;
            }
            return packet.getType() != 75;
        }
    }

    private class MyOutgoingInterceptor3
    implements Interceptor {
        private MyOutgoingInterceptor3() {
        }

        public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
            if (packet.getType() == 71) {
                SessionSendMessage p = (SessionSendMessage)packet;
                ClientMessage cm = (ClientMessage)p.getMessage();
                cm.putStringProperty(InterceptorTest.key, "orange");
            }
            return true;
        }
    }

    private class MyInterceptor3
    implements Interceptor {
        private MyInterceptor3() {
        }

        public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
            if (packet.getType() == 75) {
                SessionReceiveMessage p = (SessionReceiveMessage)packet;
                ClientMessage cm = (ClientMessage)p.getMessage();
                cm.putStringProperty(InterceptorTest.key, "orange");
            }
            return true;
        }
    }

    private class MyOutgoingInterceptor2
    implements Interceptor {
        private MyOutgoingInterceptor2() {
        }

        public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
            if (InterceptorTest.this.isForceDeliveryResponse(packet)) {
                return true;
            }
            return packet.getType() != 75;
        }
    }

    private class MyInterceptor2
    implements Interceptor {
        private MyInterceptor2() {
        }

        public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
            return packet.getType() != 71;
        }
    }

    private class MyOutgoingInterceptor1
    implements Interceptor {
        private MyOutgoingInterceptor1() {
        }

        public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
            if (packet.getType() == 75) {
                SessionReceiveMessage p = (SessionReceiveMessage)packet;
                ICoreMessage sm = p.getMessage();
                sm.putStringProperty(InterceptorTest.key, "orange");
            }
            return true;
        }
    }

    private class InterceptUserOnCreateConsumer
    implements Interceptor {
        private InterceptUserOnCreateConsumer() {
        }

        public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
            if (packet.getType() == 40) {
                String userName = this.getUsername(packet, connection);
                SessionCreateConsumerMessage createQueue = (SessionCreateConsumerMessage)packet;
                createQueue.setFilterString(new SimpleString("userName='" + userName + "'"));
                InterceptorTest.this.instanceLog.debug((Object)("userName = " + userName));
            } else if (packet.getType() == 71) {
                String userName = this.getUsername(packet, connection);
                MessagePacket msgPacket = (MessagePacket)packet;
                msgPacket.getMessage().putStringProperty("userName", userName);
                InterceptorTest.this.instanceLog.debug((Object)("userName on send = " + userName));
            }
            return true;
        }

        public String getUsername(Packet packet, RemotingConnection connection) {
            RemotingConnectionImpl impl = (RemotingConnectionImpl)connection;
            ChannelImpl channel = (ChannelImpl)impl.getChannel(packet.getChannelID(), -1);
            ServerSessionPacketHandler sessionHandler = (ServerSessionPacketHandler)channel.getHandler();
            return sessionHandler.getSession().getUsername();
        }
    }

    private class InterceptUserOnCreateQueue
    implements Interceptor {
        private InterceptUserOnCreateQueue() {
        }

        public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
            if (packet.getType() == 34 || packet.getType() == -12) {
                String userName = this.getUsername(packet, connection);
                CreateQueueMessage createQueue = (CreateQueueMessage)packet;
                createQueue.setFilterString(new SimpleString("userName='" + userName + "'"));
                InterceptorTest.this.instanceLog.debug((Object)("userName on createQueue = " + userName));
            } else if (packet.getType() == 71) {
                String userName = this.getUsername(packet, connection);
                MessagePacket msgPacket = (MessagePacket)packet;
                msgPacket.getMessage().putStringProperty("userName", userName);
                InterceptorTest.this.instanceLog.debug((Object)("userName on send = " + userName));
            }
            return true;
        }

        public String getUsername(Packet packet, RemotingConnection connection) {
            RemotingConnectionImpl impl = (RemotingConnectionImpl)connection;
            ChannelImpl channel = (ChannelImpl)impl.getChannel(packet.getChannelID(), -1);
            ServerSessionPacketHandler sessionHandler = (ServerSessionPacketHandler)channel.getHandler();
            return sessionHandler.getSession().getUsername();
        }
    }

    private class MyInterceptor1
    implements Interceptor {
        private MyInterceptor1() {
        }

        public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
            if (packet.getType() == 71) {
                SessionSendMessage p = (SessionSendMessage)packet;
                ICoreMessage sm = p.getMessage();
                sm.putStringProperty(InterceptorTest.key, "orange");
            }
            return true;
        }
    }
}

