/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.HashSet;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.util.SameProcessActiveMQServer;
import org.jboss.logging.Logger;
import org.junit.Before;

public abstract class ClusterWithBackupFailoverTestBase
extends ClusterTestBase {
    protected static final String QUEUE_NAME = "queue0";
    protected static final String QUEUES_TESTADDRESS = "queues.testaddress";
    protected static final Logger log = Logger.getLogger(ClusterWithBackupFailoverTestBase.class);

    protected abstract void setupCluster(MessageLoadBalancingType var1) throws Exception;

    protected abstract void setupServers() throws Exception;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.setupServers();
    }

    protected boolean isNetty() {
        return false;
    }

    protected void waitForBindings() throws Exception {
        this.waitForBindings(0, QUEUES_TESTADDRESS, 1, 1, true);
        this.waitForBindings(1, QUEUES_TESTADDRESS, 1, 1, true);
        this.waitForBindings(2, QUEUES_TESTADDRESS, 1, 1, true);
        this.waitForBindings(0, QUEUES_TESTADDRESS, 2, 2, false);
        this.waitForBindings(1, QUEUES_TESTADDRESS, 2, 2, false);
        this.waitForBindings(2, QUEUES_TESTADDRESS, 2, 2, false);
    }

    protected void setupCluster() throws Exception {
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
    }

    protected void failNode(int node) throws Exception {
        this.failNode(node, node);
    }

    protected void failNode(int node, int originalLiveNode) throws Exception {
        log.debug((Object)("*** failing node " + node));
        ActiveMQServer server = this.getServer(node);
        SameProcessActiveMQServer tstServer = new SameProcessActiveMQServer(server);
        ClientSession[] sessionsArray = this.exploreSessions(originalLiveNode);
        tstServer.crash(sessionsArray);
    }

    private ClientSession[] exploreSessions(int node) {
        HashSet<ClientSession> sessions = new HashSet<ClientSession>();
        for (ClusterTestBase.ConsumerHolder holder : this.consumers) {
            if (holder == null || holder.getNode() != node || holder.getSession() == null) continue;
            sessions.add(holder.getSession());
        }
        ClientSession[] sessionsArray = sessions.toArray(new ClientSession[sessions.size()]);
        return sessionsArray;
    }
}

