/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreMasterPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreSlavePolicyConfiguration;
import org.apache.activemq.artemis.core.server.cluster.BackupManager;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.Assert;
import org.junit.Test;

public class BackupManagerInheritedConfigTest
extends FailoverTestBase {
    @Override
    protected void createConfigs() throws Exception {
        this.nodeManager = this.createNodeManager();
        TransportConfiguration liveConnector = this.getConnectorTransportConfiguration(true);
        TransportConfiguration backupConnector = this.getConnectorTransportConfiguration(false);
        this.backupConfig = super.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(false)).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreSlavePolicyConfiguration()).addConnectorConfiguration(liveConnector.getName(), liveConnector).addConnectorConfiguration(backupConnector.getName(), backupConnector).addClusterConfiguration(this.createBasicClusterConfig(backupConnector.getName(), new String[]{liveConnector.getName()}).setRetryInterval(333L).setClientFailureCheckPeriod(1000L).setConnectionTTL(5000L));
        this.backupServer = this.createTestableServer(this.backupConfig);
        this.liveConfig = super.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(true)).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreMasterPolicyConfiguration()).addClusterConfiguration(this.createBasicClusterConfig(liveConnector.getName(), new String[0]).setRetryInterval(333L)).addConnectorConfiguration(liveConnector.getName(), liveConnector);
        this.liveServer = this.createTestableServer(this.liveConfig);
    }

    @Test
    public void testValidateInheritedClusterConnectionConfig() {
        ActiveMQServerImpl server = (ActiveMQServerImpl)this.backupServer.getServer();
        for (BackupManager.BackupConnector backupConnector : server.getBackupManager().getBackupConnectors()) {
            Wait.assertTrue(() -> backupConnector.getBackupServerLocator() != null);
            Assert.assertEquals((long)333L, (long)backupConnector.getBackupServerLocator().getRetryInterval());
            Assert.assertEquals((long)-1L, (long)backupConnector.getBackupServerLocator().getReconnectAttempts());
            Assert.assertEquals((long)1000L, (long)backupConnector.getBackupServerLocator().getClientFailureCheckPeriod());
            Assert.assertEquals((long)5000L, (long)backupConnector.getBackupServerLocator().getConnectionTTL());
        }
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMAcceptor(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMConnector(live);
    }
}

