/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.junit.Before;
import org.junit.Test;

public class URISimpleClusterTest
extends ClusterTestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.setupServers();
    }

    protected boolean isNetty() {
        return true;
    }

    @Test
    public void testBasicRoundRobin() throws Exception {
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
        this.startServers();
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.setupSessionFactory(3, this.isNetty());
        this.setupSessionFactory(4, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.createQueue(3, "queues.testaddress", "queue0", null, false);
        this.createQueue(4, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.addConsumer(3, 3, "queue0", null);
        this.addConsumer(4, 4, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(3, "queues.testaddress", 1, 1, true);
        this.waitForBindings(4, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 4, 4, false);
        this.waitForBindings(1, "queues.testaddress", 4, 4, false);
        this.waitForBindings(2, "queues.testaddress", 4, 4, false);
        this.waitForBindings(3, "queues.testaddress", 4, 4, false);
        this.waitForBindings(4, "queues.testaddress", 4, 4, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(10, 0, 1, 2, 3, 4);
        this.verifyNotReceive(0, 1, 2, 3, 4);
    }

    protected static String generateURI(int serverID) {
        return "tcp://127.0.0.1:" + (61616 + serverID);
    }

    protected void setupCluster(MessageLoadBalancingType messageLoadBalancingType) throws Exception {
        for (int i = 0; i < 5; ++i) {
            this.servers[i].getConfiguration().addConnectorConfiguration("netty-connector", URISimpleClusterTest.generateURI(i));
        }
        this.setupClusterConnection("cluster", "static://(" + URISimpleClusterTest.generateURI(1) + "," + URISimpleClusterTest.generateURI(2) + "," + URISimpleClusterTest.generateURI(3) + "," + URISimpleClusterTest.generateURI(4) + ")?connectorName=netty-connector;retryInterval=500;messageLoadBalancingType=" + messageLoadBalancingType.toString() + ";maxHops=1;address=queues", 0);
        this.setupClusterConnection("cluster", "static://(" + URISimpleClusterTest.generateURI(0) + "," + URISimpleClusterTest.generateURI(2) + "," + URISimpleClusterTest.generateURI(3) + "," + URISimpleClusterTest.generateURI(4) + ")?connectorName=netty-connector;retryInterval=500;messageLoadBalancingType=" + messageLoadBalancingType.toString() + ";maxHops=1;address=queues", 1);
        this.setupClusterConnection("cluster", "static://(" + URISimpleClusterTest.generateURI(0) + "," + URISimpleClusterTest.generateURI(1) + "," + URISimpleClusterTest.generateURI(3) + "," + URISimpleClusterTest.generateURI(4) + ")?connectorName=netty-connector;retryInterval=500;messageLoadBalancingType=" + messageLoadBalancingType.toString() + ";maxHops=1;address=queues", 2);
        this.setupClusterConnection("cluster", "static://(" + URISimpleClusterTest.generateURI(0) + "," + URISimpleClusterTest.generateURI(1) + "," + URISimpleClusterTest.generateURI(2) + "," + URISimpleClusterTest.generateURI(4) + ")?connectorName=netty-connector;retryInterval=500;messageLoadBalancingType=" + messageLoadBalancingType.toString() + ";maxHops=1;address=queues", 3);
        this.setupClusterConnection("cluster", "static://(" + URISimpleClusterTest.generateURI(0) + "," + URISimpleClusterTest.generateURI(1) + "," + URISimpleClusterTest.generateURI(2) + "," + URISimpleClusterTest.generateURI(3) + ")?connectorName=netty-connector;retryInterval=500;messageLoadBalancingType=" + messageLoadBalancingType.toString() + ";maxHops=1;address=queues", 4);
    }

    protected void setupServers() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupServer(2, this.isFileStorage(), this.isNetty());
        this.setupServer(3, this.isFileStorage(), this.isNetty());
        this.setupServer(4, this.isFileStorage(), this.isNetty());
    }

    protected void startServers() throws Exception {
        this.startServers(0, 1, 2, 3, 4);
    }

    protected void stopServers() throws Exception {
        this.closeAllConsumers();
        this.closeAllSessionFactories();
        this.closeAllServerLocatorsFactories();
        this.stopServers(0, 1, 2, 3, 4);
    }

    @Override
    protected boolean isFileStorage() {
        return false;
    }
}

