/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TemporaryQueueClusterTest
extends ClusterTestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.setupServers();
    }

    protected boolean isNetty() {
        return false;
    }

    @Test
    public void testSendToTempQueueFromAnotherClusterNode() throws Exception {
        this.setupCluster();
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        String tempAddress = "queues.tempaddress";
        String tempQueue = "tempqueue";
        ClientSession session = this.sfs[0].createSession(false, true, true);
        session.createQueue(new QueueConfiguration(tempQueue).setAddress(tempAddress).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        ClientConsumer consumer = session.createConsumer(tempQueue);
        this.waitForBindings(1, tempAddress, 1, 1, false);
        this.send(1, tempAddress, 10, false, null);
        session.start();
        for (int j = 0; j < 10; ++j) {
            ClientMessage message = consumer.receive(5000L);
            if (message == null) {
                Assert.assertNotNull((String)("consumer did not receive message on temp queue " + j), (Object)message);
            }
            message.acknowledge();
        }
        consumer.close();
        session.deleteQueue(tempQueue);
        session.close();
    }

    protected void setupCluster() throws Exception {
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
    }

    protected void setupCluster(MessageLoadBalancingType messageLoadBalancingType) throws Exception {
        this.setupClusterConnection("cluster0", "queues", messageLoadBalancingType, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "queues", messageLoadBalancingType, 1, this.isNetty(), 1, 0);
    }

    protected void setupServers() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
    }
}

