/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import java.util.Map;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.junit.Before;
import org.junit.Test;

public class ExclusiveDivertWithClusterTest
extends ClusterTestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.start();
    }

    protected ActiveMQServer createServer(boolean realFiles, Configuration configuration, int pageSize, long maxAddressSize, Map<String, AddressSettings> settings) {
        DivertConfiguration divertConf = new DivertConfiguration().setName("notifications-divert").setAddress("*.Provider.*.Agent.*.Status").setForwardingAddress("Notifications").setExclusive(true);
        configuration.addDivertConfiguration(divertConf);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)configuration, (boolean)realFiles));
        if (settings != null) {
            for (Map.Entry<String, AddressSettings> setting : settings.entrySet()) {
                server.getAddressSettingsRepository().addMatch(setting.getKey(), (Object)setting.getValue());
            }
        }
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(pageSize).setRedeliveryDelay(0L).setMaxSizeBytes(maxAddressSize).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE).setRedistributionDelay(0L).setAutoCreateQueues(Boolean.valueOf(true)).setAutoCreateAddresses(Boolean.valueOf(true));
        server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        return server;
    }

    @Test
    public void testExclusiveDivertDoesNotDuplicateMessageInCluster() throws Exception {
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty(), false);
        this.setupSessionFactory(1, this.isNetty(), false);
        this.createQueue(0, "Notifications", "Notifications", null, false, RoutingType.ANYCAST);
        this.createQueue(1, "Notifications", "Notifications", null, false, RoutingType.ANYCAST);
        this.addConsumer(0, 0, "Notifications", null, true);
        this.createQueue(0, "x.Provider.y.Agent.z.Status", "x.Provider.y.Agent.z.Status", null, false, RoutingType.ANYCAST);
        this.createQueue(1, "x.Provider.y.Agent.z.Status", "x.Provider.y.Agent.z.Status", null, false, RoutingType.ANYCAST);
        this.waitForBindings(0, "Notifications", 1, 1, true);
        this.waitForBindings(0, "Notifications", 1, 0, false);
        this.waitForBindings(1, "Notifications", 1, 0, true);
        this.waitForBindings(1, "Notifications", 1, 1, false);
        this.send(0, "x.Provider.y.Agent.z.Status", 1, false, null);
        int messagesAdded = this.getMessagesAdded(this.servers[0].getPostOffice(), "Notifications");
        ExclusiveDivertWithClusterTest.assertEquals((long)1L, (long)messagesAdded);
    }

    protected void start() throws Exception {
        this.setupServers();
    }

    protected void setupServers() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
    }

    protected void setupCluster(MessageLoadBalancingType messageLoadBalancingType) throws Exception {
        this.setupClusterConnection("cluster0", "", messageLoadBalancingType, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "", messageLoadBalancingType, 1, this.isNetty(), 1, 0);
    }

    protected void stopServers() throws Exception {
        this.closeAllConsumers();
        this.closeAllSessionFactories();
        this.closeAllServerLocatorsFactories();
        this.stopServers(0, 1);
        this.clearServer(0, 1);
    }

    protected boolean isNetty() {
        return false;
    }
}

