/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQObjectClosedException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerPolicy;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerThresholdMeasurementUnit;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SlowConsumerTest
extends ActiveMQTestBase {
    private static final Logger logger = Logger.getLogger(SlowConsumerTest.class);
    private int threshold = 10;
    private long checkPeriod = 1L;
    private boolean isNetty = true;
    private ActiveMQServer server;
    private final SimpleString QUEUE = new SimpleString("ConsumerTestQueue");
    private ServerLocator locator;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(true, this.isNetty);
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setSlowConsumerCheckPeriod(this.checkPeriod);
        addressSettings.setSlowConsumerThreshold((long)this.threshold);
        addressSettings.setSlowConsumerThresholdMeasurementUnit(SlowConsumerThresholdMeasurementUnit.MESSAGES_PER_SECOND);
        addressSettings.setSlowConsumerPolicy(SlowConsumerPolicy.KILL);
        addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        addressSettings.setMaxSizeBytes(10240L);
        addressSettings.setPageSizeBytes(1024);
        this.server.start();
        this.server.getAddressSettingsRepository().addMatch(this.QUEUE.toString(), (Object)addressSettings);
        this.server.createQueue(new QueueConfiguration(this.QUEUE).setRoutingType(RoutingType.ANYCAST)).getPageSubscription().getPagingStore().startPaging();
        this.locator = this.createFactory(this.isNetty);
    }

    @Test
    public void testSlowConsumerKilled() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(sf.createSession(false, true, true, false));
        ClientProducer producer = this.addClientProducer(session.createProducer(this.QUEUE));
        int numMessages = 25;
        for (int i = 0; i < 25; ++i) {
            producer.send((Message)this.createTextMessage(session, "m" + i));
        }
        ClientConsumer consumer = this.addClientConsumer(session.createConsumer(this.QUEUE));
        session.start();
        Thread.sleep(3000L);
        try {
            consumer.receiveImmediate();
            SlowConsumerTest.fail();
        }
        catch (ActiveMQObjectClosedException e) {
            SlowConsumerTest.assertEquals((Object)e.getType(), (Object)ActiveMQExceptionType.OBJECT_CLOSED);
        }
    }

    @Test
    public void testSlowConsumerKilledAfterBurst() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(sf.createSession(false, true, true, false));
        ClientProducer producer = this.addClientProducer(session.createProducer(this.QUEUE));
        int numMessages = 3 * this.threshold;
        for (int i = 0; i < numMessages; ++i) {
            producer.send((Message)this.createTextMessage(session, "m" + i));
        }
        ClientConsumer consumer = this.addClientConsumer(session.createConsumer(this.QUEUE));
        session.start();
        for (int i = 0; i < this.threshold; ++i) {
            consumer.receiveImmediate().individualAcknowledge();
        }
        Thread.sleep(3L * this.checkPeriod * 1000L);
        try {
            consumer.receiveImmediate();
            SlowConsumerTest.fail();
        }
        catch (ActiveMQObjectClosedException e) {
            SlowConsumerTest.assertEquals((Object)e.getType(), (Object)ActiveMQExceptionType.OBJECT_CLOSED);
        }
    }

    @Test
    public void testSlowConsumerSparedAfterBurst() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(sf.createSession(false, true, true, false));
        ClientProducer producer = this.addClientProducer(session.createProducer(this.QUEUE));
        int numMessages = 3 * this.threshold + 1;
        for (int i = 0; i < numMessages; ++i) {
            producer.send((Message)this.createTextMessage(session, "m" + i));
        }
        ClientConsumer consumer = this.addClientConsumer(session.createConsumer(this.QUEUE));
        session.start();
        for (int i = 0; i < 3 * this.threshold; ++i) {
            consumer.receiveImmediate().individualAcknowledge();
        }
        Thread.sleep(3L * this.checkPeriod * 1000L);
        SlowConsumerTest.assertNotNull((Object)consumer.receiveImmediate());
    }

    @Test
    public void testSlowConsumerNotification() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(sf.createSession(false, true, true, false));
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setSlowConsumerCheckPeriod(2L);
        addressSettings.setSlowConsumerThreshold(10L);
        addressSettings.setSlowConsumerPolicy(SlowConsumerPolicy.NOTIFY);
        this.server.getAddressSettingsRepository().removeMatch(this.QUEUE.toString());
        this.server.getAddressSettingsRepository().addMatch(this.QUEUE.toString(), (Object)addressSettings);
        ClientProducer producer = this.addClientProducer(session.createProducer(this.QUEUE));
        int numMessages = 25;
        for (int i = 0; i < 25; ++i) {
            producer.send((Message)this.createTextMessage(session, "m" + i));
        }
        SimpleString notifQueue = RandomUtil.randomSimpleString();
        session.createQueue(new QueueConfiguration(notifQueue).setAddress(ActiveMQDefaultConfiguration.getDefaultManagementNotificationAddress()).setDurable(Boolean.valueOf(false)));
        ClientConsumer notifConsumer = session.createConsumer(notifQueue.toString(), ManagementHelper.HDR_NOTIFICATION_TYPE + "='" + CoreNotificationType.CONSUMER_SLOW + "'");
        final CountDownLatch notifLatch = new CountDownLatch(1);
        notifConsumer.setMessageHandler(new MessageHandler(){

            public void onMessage(ClientMessage message) {
                Assert.assertEquals((Object)CoreNotificationType.CONSUMER_SLOW.toString(), (Object)message.getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TYPE).toString());
                Assert.assertEquals((Object)SlowConsumerTest.this.QUEUE.toString(), (Object)message.getObjectProperty(ManagementHelper.HDR_ADDRESS).toString());
                Assert.assertEquals((Object)1, (Object)message.getIntProperty(ManagementHelper.HDR_CONSUMER_COUNT));
                if (SlowConsumerTest.this.isNetty) {
                    Assert.assertTrue((boolean)message.getSimpleStringProperty(ManagementHelper.HDR_REMOTE_ADDRESS).toString().startsWith("/127.0.0.1"));
                } else {
                    Assert.assertEquals((Object)SimpleString.toSimpleString((String)"invm:0"), (Object)message.getSimpleStringProperty(ManagementHelper.HDR_REMOTE_ADDRESS));
                }
                Assert.assertNotNull((Object)message.getSimpleStringProperty(ManagementHelper.HDR_CONNECTION_NAME));
                Assert.assertNotNull((Object)message.getSimpleStringProperty(ManagementHelper.HDR_CONSUMER_NAME));
                Assert.assertNotNull((Object)message.getSimpleStringProperty(ManagementHelper.HDR_SESSION_NAME));
                try {
                    message.acknowledge();
                }
                catch (ActiveMQException e) {
                    e.printStackTrace();
                }
                notifLatch.countDown();
            }
        });
        ClientConsumer consumer = this.addClientConsumer(session.createConsumer(this.QUEUE));
        session.start();
        SlowConsumerTest.assertTrue((boolean)notifLatch.await(15L, TimeUnit.SECONDS));
    }

    @Test
    public void testSlowConsumerSpared() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(sf.createSession(true, true));
        ClientProducer producer = this.addClientProducer(session.createProducer(this.QUEUE));
        int numMessages = 5;
        for (int i = 0; i < 5; ++i) {
            producer.send((Message)this.createTextMessage(session, "m" + i));
        }
        ClientConsumer consumer = this.addClientConsumer(session.createConsumer(this.QUEUE));
        session.start();
        Thread.sleep(3000L);
        for (int i = 0; i < 5; ++i) {
            SlowConsumerTest.assertNotNull((Object)consumer.receive(500L));
        }
    }

    @Test
    public void testFastThenSlowConsumerSpared() throws Exception {
        this.locator.setAckBatchSize(0);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(sf.createSession(true, true));
        final ClientSession producerSession = this.addClientSession(sf.createSession(true, true));
        final ClientProducer producer = this.addClientProducer(producerSession.createProducer(this.QUEUE));
        final AtomicLong messagesProduced = new AtomicLong(0L);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                ClientMessage m = SlowConsumerTest.this.createTextMessage(producerSession, "m", true);
                while (System.currentTimeMillis() < start + 3000L) {
                    try {
                        producer.send((Message)m);
                        messagesProduced.incrementAndGet();
                    }
                    catch (ActiveMQException e) {
                        e.printStackTrace();
                        return;
                    }
                }
                start = System.currentTimeMillis();
                while (System.currentTimeMillis() < start + 10000L) {
                    try {
                        producer.send((Message)m);
                        messagesProduced.incrementAndGet();
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                }
            }
        });
        t.start();
        ClientConsumer consumer = this.addClientConsumer(session.createConsumer(this.QUEUE));
        session.start();
        ClientMessage m = null;
        long messagesConsumed = 0L;
        do {
            if ((m = consumer.receive(1500L)) == null) continue;
            m.acknowledge();
            ++messagesConsumed;
        } while (m != null);
        SlowConsumerTest.assertEquals((long)messagesProduced.longValue(), (long)messagesConsumed);
    }

    @Test
    public void testSlowWildcardConsumer() throws Exception {
        SimpleString addressAB = new SimpleString("a.b");
        SimpleString addressAC = new SimpleString("a.c");
        SimpleString address = new SimpleString("a.*");
        SimpleString queueName1 = new SimpleString("Q1");
        SimpleString queueName2 = new SimpleString("Q2");
        SimpleString queueName = new SimpleString("Q");
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setSlowConsumerCheckPeriod(2L);
        addressSettings.setSlowConsumerThreshold(10L);
        addressSettings.setSlowConsumerPolicy(SlowConsumerPolicy.KILL);
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(sf.createSession(false, true, true, false));
        session.createQueue(new QueueConfiguration(queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(addressAB);
        ClientProducer producer2 = session.createProducer(addressAC);
        int numMessages = 20;
        for (int i = 0; i < 20; ++i) {
            producer.send((Message)this.createTextMessage(session, "m1" + i));
            producer2.send((Message)this.createTextMessage(session, "m2" + i));
        }
        ClientConsumer consumer = this.addClientConsumer(session.createConsumer(queueName));
        session.start();
        Thread.sleep(3000L);
        try {
            consumer.receiveImmediate();
            SlowConsumerTest.fail();
        }
        catch (ActiveMQObjectClosedException e) {
            SlowConsumerTest.assertEquals((Object)e.getType(), (Object)ActiveMQExceptionType.OBJECT_CLOSED);
        }
    }

    @Test
    public void testOneMinuteKilledInVM() throws Exception {
        this.testMinuteKilled(false);
    }

    @Test
    public void testOneMinuteKilled() throws Exception {
        this.testMinuteKilled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMinuteKilled(boolean netty) throws Exception {
        this.locator.close();
        this.locator = this.createFactory(netty);
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setSlowConsumerCheckPeriod(2L);
        addressSettings.setSlowConsumerThresholdMeasurementUnit(SlowConsumerThresholdMeasurementUnit.MESSAGES_PER_MINUTE);
        addressSettings.setSlowConsumerThreshold(60L);
        addressSettings.setSlowConsumerPolicy(SlowConsumerPolicy.KILL);
        this.server.getAddressSettingsRepository().removeMatch(this.QUEUE.toString());
        this.server.getAddressSettingsRepository().addMatch(this.QUEUE.toString(), (Object)addressSettings);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(sf.createSession(false, true, true, false));
        ClientProducer producer = this.addClientProducer(session.createProducer(this.QUEUE));
        int messages = 200;
        for (int i = 0; i < messages; ++i) {
            producer.send((Message)session.createMessage(true));
        }
        session.commit();
        ConcurrentHashSet receivedMessages = new ConcurrentHashSet();
        FixedRateConsumer consumer = new FixedRateConsumer(40, SlowConsumerThresholdMeasurementUnit.MESSAGES_PER_MINUTE, (Set<ClientMessage>)receivedMessages, sf, this.QUEUE, 0);
        consumer.start();
        Queue queue = this.server.locateQueue(this.QUEUE);
        Wait.assertEquals((int)1, () -> ((Queue)queue).getConsumerCount());
        try {
            Wait.assertEquals((int)0, () -> ((Queue)queue).getConsumerCount());
        }
        finally {
            consumer.stopRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDaysKilled() throws Exception {
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setSlowConsumerCheckPeriod(2L);
        addressSettings.setSlowConsumerThresholdMeasurementUnit(SlowConsumerThresholdMeasurementUnit.MESSAGES_PER_DAY);
        addressSettings.setSlowConsumerThreshold(TimeUnit.DAYS.toSeconds(1L));
        addressSettings.setSlowConsumerPolicy(SlowConsumerPolicy.KILL);
        this.server.getAddressSettingsRepository().removeMatch(this.QUEUE.toString());
        this.server.getAddressSettingsRepository().addMatch(this.QUEUE.toString(), (Object)addressSettings);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(sf.createSession(false, true, true, false));
        ClientProducer producer = this.addClientProducer(session.createProducer(this.QUEUE));
        int messages = 200;
        for (int i = 0; i < messages; ++i) {
            producer.send((Message)session.createMessage(true));
        }
        session.commit();
        ConcurrentHashSet receivedMessages = new ConcurrentHashSet();
        FixedRateConsumer consumer = new FixedRateConsumer(30, SlowConsumerThresholdMeasurementUnit.MESSAGES_PER_MINUTE, (Set<ClientMessage>)receivedMessages, sf, this.QUEUE, 0);
        consumer.start();
        Queue queue = this.server.locateQueue(this.QUEUE);
        Wait.assertEquals((int)1, () -> ((Queue)queue).getConsumerCount());
        try {
            Wait.assertEquals((int)0, () -> ((Queue)queue).getConsumerCount());
        }
        finally {
            consumer.stopRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDaysKilledPaging() throws Exception {
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setSlowConsumerCheckPeriod(2L);
        addressSettings.setSlowConsumerThresholdMeasurementUnit(SlowConsumerThresholdMeasurementUnit.MESSAGES_PER_DAY);
        addressSettings.setSlowConsumerThreshold(TimeUnit.DAYS.toSeconds(1L));
        addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        addressSettings.setMaxSizeBytes(10240L);
        addressSettings.setPageSizeBytes(1024);
        addressSettings.setSlowConsumerPolicy(SlowConsumerPolicy.KILL);
        this.server.getAddressSettingsRepository().removeMatch(this.QUEUE.toString());
        this.server.getAddressSettingsRepository().addMatch(this.QUEUE.toString(), (Object)addressSettings);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(sf.createSession(false, true, true, false));
        ClientProducer producer = this.addClientProducer(session.createProducer(this.QUEUE));
        int messages = 200;
        Queue queue = this.server.locateQueue(this.QUEUE);
        queue.getPagingStore().startPaging();
        Assert.assertTrue((boolean)queue.getPagingStore().isPaging());
        for (int i = 0; i < messages; ++i) {
            producer.send((Message)session.createMessage(true));
        }
        session.commit();
        ConcurrentHashSet receivedMessages = new ConcurrentHashSet();
        FixedRateConsumer consumer = new FixedRateConsumer(30, SlowConsumerThresholdMeasurementUnit.MESSAGES_PER_MINUTE, (Set<ClientMessage>)receivedMessages, sf, this.QUEUE, 0);
        consumer.start();
        Wait.assertEquals((int)1, () -> ((Queue)queue).getConsumerCount());
        try {
            Wait.assertEquals((int)0, () -> ((Queue)queue).getConsumerCount());
        }
        finally {
            consumer.stopRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDaysSurviving() throws Exception {
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setSlowConsumerCheckPeriod(2L);
        addressSettings.setSlowConsumerThresholdMeasurementUnit(SlowConsumerThresholdMeasurementUnit.MESSAGES_PER_DAY);
        addressSettings.setSlowConsumerThreshold(TimeUnit.DAYS.toSeconds(1L));
        addressSettings.setSlowConsumerPolicy(SlowConsumerPolicy.KILL);
        this.server.getAddressSettingsRepository().removeMatch(this.QUEUE.toString());
        this.server.getAddressSettingsRepository().addMatch(this.QUEUE.toString(), (Object)addressSettings);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(sf.createSession(false, true, true, false));
        ClientProducer producer = this.addClientProducer(session.createProducer(this.QUEUE));
        int messages = 10;
        for (int i = 0; i < messages; ++i) {
            producer.send((Message)session.createMessage(true));
        }
        session.commit();
        ConcurrentHashSet receivedMessages = new ConcurrentHashSet();
        FixedRateConsumer consumer = new FixedRateConsumer(70, SlowConsumerThresholdMeasurementUnit.MESSAGES_PER_MINUTE, (Set<ClientMessage>)receivedMessages, sf, this.QUEUE, 0);
        consumer.start();
        Queue queue = this.server.locateQueue(this.QUEUE);
        Wait.assertEquals((int)1, () -> ((Queue)queue).getConsumerCount());
        try {
            Wait.assertEquals((long)messages, () -> ((Queue)queue).getMessagesAcknowledged());
            Wait.assertEquals((int)messages, () -> receivedMessages.size());
        }
        finally {
            consumer.stopRunning();
        }
        Wait.assertEquals((int)0, () -> ((Queue)queue).getConsumerCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMinuteSurviving() throws Exception {
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setSlowConsumerCheckPeriod(2L);
        addressSettings.setSlowConsumerThresholdMeasurementUnit(SlowConsumerThresholdMeasurementUnit.MESSAGES_PER_MINUTE);
        addressSettings.setSlowConsumerThreshold(60L);
        addressSettings.setSlowConsumerPolicy(SlowConsumerPolicy.KILL);
        this.server.getAddressSettingsRepository().removeMatch(this.QUEUE.toString());
        this.server.getAddressSettingsRepository().addMatch(this.QUEUE.toString(), (Object)addressSettings);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(sf.createSession(false, true, true, false));
        ClientProducer producer = this.addClientProducer(session.createProducer(this.QUEUE));
        int messages = 10;
        for (int i = 0; i < messages; ++i) {
            producer.send((Message)session.createMessage(true));
        }
        session.commit();
        ConcurrentHashSet receivedMessages = new ConcurrentHashSet();
        FixedRateConsumer consumer = new FixedRateConsumer(80, SlowConsumerThresholdMeasurementUnit.MESSAGES_PER_MINUTE, (Set<ClientMessage>)receivedMessages, sf, this.QUEUE, 0);
        consumer.start();
        Queue queue = this.server.locateQueue(this.QUEUE);
        try {
            Wait.assertEquals((long)messages, () -> ((Queue)queue).getMessagesAcknowledged());
            Assert.assertEquals((long)1L, (long)queue.getConsumerCount());
            Wait.assertEquals((int)messages, () -> receivedMessages.size());
        }
        finally {
            consumer.stopRunning();
        }
        Wait.assertEquals((int)0, () -> ((Queue)queue).getConsumerCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleConsumersOneQueue() throws Exception {
        this.locator.setAckBatchSize(0);
        Queue queue = this.server.locateQueue(this.QUEUE);
        ClientSessionFactory sf1 = this.createSessionFactory(this.locator);
        ClientSessionFactory sf2 = this.createSessionFactory(this.locator);
        ClientSessionFactory sf3 = this.createSessionFactory(this.locator);
        ClientSessionFactory sf4 = this.createSessionFactory(this.locator);
        int messages = 10 * this.threshold;
        FixedRateProducer producer = new FixedRateProducer(this.threshold * 2, SlowConsumerThresholdMeasurementUnit.MESSAGES_PER_SECOND, sf1, this.QUEUE, messages);
        ConcurrentHashSet consumers = new ConcurrentHashSet();
        ConcurrentHashSet receivedMessages = new ConcurrentHashSet();
        consumers.add(new FixedRateConsumer(this.threshold, SlowConsumerThresholdMeasurementUnit.MESSAGES_PER_SECOND, (Set<ClientMessage>)receivedMessages, sf2, this.QUEUE, 1));
        consumers.add(new FixedRateConsumer(this.threshold, SlowConsumerThresholdMeasurementUnit.MESSAGES_PER_SECOND, (Set<ClientMessage>)receivedMessages, sf3, this.QUEUE, 2));
        consumers.add(new FixedRateConsumer(this.threshold, SlowConsumerThresholdMeasurementUnit.MESSAGES_PER_SECOND, (Set<ClientMessage>)receivedMessages, sf4, this.QUEUE, 3));
        try {
            producer.start();
            for (FixedRateConsumer consumer : consumers) {
                consumer.start();
            }
            producer.join(10000L);
            Assert.assertEquals((long)3L, (long)queue.getConsumerCount());
            Wait.assertEquals((int)messages, ((Set)receivedMessages)::size);
        }
        catch (Throwable throwable) {
            producer.stopRunning();
            Assert.assertFalse((boolean)producer.failed);
            for (FixedRateConsumer consumer : consumers) {
                consumer.stopRunning();
                Assert.assertFalse((boolean)consumer.failed);
            }
            logger.debug((Object)("***report messages received: " + receivedMessages.size()));
            logger.debug((Object)("***consumers left: " + consumers.size()));
            throw throwable;
        }
        producer.stopRunning();
        Assert.assertFalse((boolean)producer.failed);
        for (FixedRateConsumer consumer : consumers) {
            consumer.stopRunning();
            Assert.assertFalse((boolean)consumer.failed);
        }
        logger.debug((Object)("***report messages received: " + receivedMessages.size()));
        logger.debug((Object)("***consumers left: " + consumers.size()));
    }

    private abstract class FixedRateClient
    extends Thread {
        protected ClientSessionFactory sf;
        protected SimpleString queue;
        protected ClientSession session;
        protected final int sleepTime;
        protected volatile boolean working;
        boolean failed;

        FixedRateClient(ClientSessionFactory sf, SimpleString queue, int rate, SlowConsumerThresholdMeasurementUnit unit) throws ActiveMQException {
            this.sf = sf;
            this.queue = queue;
            this.sleepTime = (int)(SlowConsumerThresholdMeasurementUnit.unitOf((int)unit.getValue()).toMillis(1L) / (long)rate);
            logger.debug((Object)(this.getClass() + " has  sleepTime = " + this.sleepTime + " which is " + TimeUnit.MILLISECONDS.toSeconds(this.sleepTime) + " seconds"));
        }

        protected void prepareWork() throws ActiveMQException {
            this.session = SlowConsumerTest.this.addClientSession(this.sf.createSession(true, true));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            this.working = true;
            try {
                this.prepareWork();
            }
            catch (ActiveMQException e) {
                logger.debug((Object)"got error in prepareWork(), aborting...");
                e.printStackTrace();
                return;
            }
            int count = 0;
            while (this.working) {
                try {
                    this.doWork(count);
                    logger.debug((Object)(this.getClass().getName() + " sleeping " + this.sleepTime));
                    Thread.sleep(this.sleepTime);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (Exception e) {
                    this.failed = true;
                    this.handleError(count, e);
                    this.working = false;
                    continue;
                }
                finally {
                    ++count;
                    continue;
                }
                break;
            }
            return;
        }

        protected abstract void doWork(int var1) throws Exception;

        protected void handleError(int count, Exception e) {
        }

        public void stopRunning() {
            this.working = false;
            try {
                this.session.close();
                this.interrupt();
                this.join(5000L);
                if (this.isAlive()) {
                    Assert.fail((String)"Interrupt is not working on Working Thread");
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                this.handleError(0, e);
            }
        }
    }

    private class FixedRateConsumer
    extends FixedRateClient {
        Set<FixedRateConsumer> consumers;
        ClientConsumer consumer;
        final Set<ClientMessage> receivedMessages;
        int id;

        FixedRateConsumer(int rate, SlowConsumerThresholdMeasurementUnit unit, Set<ClientMessage> receivedMessages, ClientSessionFactory sf, SimpleString queue, int id) throws ActiveMQException {
            super(sf, queue, rate, unit);
            this.id = id;
            this.receivedMessages = receivedMessages;
        }

        @Override
        protected void prepareWork() throws ActiveMQException {
            super.prepareWork();
            this.consumer = this.session.createConsumer(this.queue);
            this.session.start();
        }

        @Override
        protected void doWork(int count) throws Exception {
            ClientMessage m = this.consumer.receive(1000L);
            logger.debug((Object)("consumer " + this.id + " got m: " + m));
            if (m != null) {
                this.receivedMessages.add(m);
                m.acknowledge();
                this.session.commit();
                logger.debug((Object)(" consumer " + this.id + " acked " + m.getClass().getName() + "now total received: " + this.receivedMessages.size()));
            }
        }

        @Override
        protected void handleError(int count, Exception e) {
            this.failed = true;
            System.err.println("Got error receiving message " + count + " remove self " + this.id);
            e.printStackTrace();
        }

        @Override
        public String toString() {
            return "Consumer " + this.id;
        }
    }

    private class FixedRateProducer
    extends FixedRateClient {
        int messages;
        ClientProducer producer;

        FixedRateProducer(int rate, SlowConsumerThresholdMeasurementUnit unit, ClientSessionFactory sf, SimpleString queue, int messages) throws ActiveMQException {
            super(sf, queue, rate, unit);
            this.messages = messages;
        }

        @Override
        protected void prepareWork() throws ActiveMQException {
            super.prepareWork();
            this.producer = this.session.createProducer(this.queue);
        }

        @Override
        protected void doWork(int count) throws Exception {
            if (count < this.messages) {
                ClientMessage m = SlowConsumerTest.this.createTextMessage(this.session, "msg" + count);
                this.producer.send((Message)m);
                logger.debug((Object)("producer sent a message " + count));
            } else {
                this.working = false;
            }
        }

        @Override
        public String toString() {
            return "Producer";
        }
    }
}

