/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import javax.transaction.xa.XAException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SessionCloseTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ClientSessionFactory sf;

    @Test
    public void testCanNotUseAClosedSession() throws Exception {
        final ClientSession session = this.sf.createSession(false, true, true);
        session.close();
        Assert.assertTrue((boolean)session.isClosed());
        ActiveMQTestBase.expectActiveMQException((ActiveMQExceptionType)ActiveMQExceptionType.OBJECT_CLOSED, (ActiveMQTestBase.ActiveMQAction)new ActiveMQTestBase.ActiveMQAction(){

            public void run() throws ActiveMQException {
                session.createProducer();
            }
        });
        ActiveMQTestBase.expectActiveMQException((ActiveMQExceptionType)ActiveMQExceptionType.OBJECT_CLOSED, (ActiveMQTestBase.ActiveMQAction)new ActiveMQTestBase.ActiveMQAction(){

            public void run() throws ActiveMQException {
                session.createConsumer(org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString());
            }
        });
        ActiveMQTestBase.expectActiveMQException((ActiveMQExceptionType)ActiveMQExceptionType.OBJECT_CLOSED, (ActiveMQTestBase.ActiveMQAction)new ActiveMQTestBase.ActiveMQAction(){

            public void run() throws ActiveMQException {
                session.createQueue(new QueueConfiguration(org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString()).setDurable(Boolean.valueOf(org.apache.activemq.artemis.utils.RandomUtil.randomBoolean())));
            }
        });
        ActiveMQTestBase.expectActiveMQException((ActiveMQExceptionType)ActiveMQExceptionType.OBJECT_CLOSED, (ActiveMQTestBase.ActiveMQAction)new ActiveMQTestBase.ActiveMQAction(){

            public void run() throws ActiveMQException {
                session.createQueue(new QueueConfiguration(org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString()).setAddress(org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString()).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
            }
        });
        ActiveMQTestBase.expectActiveMQException((ActiveMQExceptionType)ActiveMQExceptionType.OBJECT_CLOSED, (ActiveMQTestBase.ActiveMQAction)new ActiveMQTestBase.ActiveMQAction(){

            public void run() throws ActiveMQException {
                session.start();
            }
        });
        ActiveMQTestBase.expectActiveMQException((ActiveMQExceptionType)ActiveMQExceptionType.OBJECT_CLOSED, (ActiveMQTestBase.ActiveMQAction)new ActiveMQTestBase.ActiveMQAction(){

            public void run() throws ActiveMQException {
                session.stop();
            }
        });
        ActiveMQTestBase.expectActiveMQException((ActiveMQExceptionType)ActiveMQExceptionType.OBJECT_CLOSED, (ActiveMQTestBase.ActiveMQAction)new ActiveMQTestBase.ActiveMQAction(){

            public void run() throws ActiveMQException {
                session.commit();
            }
        });
        ActiveMQTestBase.expectActiveMQException((ActiveMQExceptionType)ActiveMQExceptionType.OBJECT_CLOSED, (ActiveMQTestBase.ActiveMQAction)new ActiveMQTestBase.ActiveMQAction(){

            public void run() throws ActiveMQException {
                session.rollback();
            }
        });
        ActiveMQTestBase.expectActiveMQException((ActiveMQExceptionType)ActiveMQExceptionType.OBJECT_CLOSED, (ActiveMQTestBase.ActiveMQAction)new ActiveMQTestBase.ActiveMQAction(){

            public void run() throws ActiveMQException {
                session.queueQuery(org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString());
            }
        });
        ActiveMQTestBase.expectActiveMQException((ActiveMQExceptionType)ActiveMQExceptionType.OBJECT_CLOSED, (ActiveMQTestBase.ActiveMQAction)new ActiveMQTestBase.ActiveMQAction(){

            public void run() throws ActiveMQException {
                session.addressQuery(org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString());
            }
        });
    }

    @Test
    public void testCanNotUseXAWithClosedSession() throws Exception {
        final ClientSession session = this.sf.createSession(true, false, false);
        session.close();
        Assert.assertTrue((boolean)session.isXA());
        Assert.assertTrue((boolean)session.isClosed());
        ActiveMQTestBase.expectXAException((int)-7, (ActiveMQTestBase.ActiveMQAction)new ActiveMQTestBase.ActiveMQAction(){

            public void run() throws XAException {
                session.commit(RandomUtil.randomXid(), true);
            }
        });
        ActiveMQTestBase.expectXAException((int)4, (ActiveMQTestBase.ActiveMQAction)new ActiveMQTestBase.ActiveMQAction(){

            public void run() throws XAException {
                session.commit(RandomUtil.randomXid(), false);
            }
        });
        ActiveMQTestBase.expectXAException((int)-7, (ActiveMQTestBase.ActiveMQAction)new ActiveMQTestBase.ActiveMQAction(){

            public void run() throws XAException {
                session.end(RandomUtil.randomXid(), 0x4000000);
            }
        });
        ActiveMQTestBase.expectXAException((int)-7, (ActiveMQTestBase.ActiveMQAction)new ActiveMQTestBase.ActiveMQAction(){

            public void run() throws XAException {
                session.forget(RandomUtil.randomXid());
            }
        });
        ActiveMQTestBase.expectXAException((int)-7, (ActiveMQTestBase.ActiveMQAction)new ActiveMQTestBase.ActiveMQAction(){

            public void run() throws XAException {
                session.prepare(RandomUtil.randomXid());
            }
        });
        ActiveMQTestBase.expectXAException((int)-7, (ActiveMQTestBase.ActiveMQAction)new ActiveMQTestBase.ActiveMQAction(){

            public void run() throws XAException {
                session.recover(0x1000000);
            }
        });
        ActiveMQTestBase.expectXAException((int)-7, (ActiveMQTestBase.ActiveMQAction)new ActiveMQTestBase.ActiveMQAction(){

            public void run() throws XAException {
                session.rollback(RandomUtil.randomXid());
            }
        });
        ActiveMQTestBase.expectXAException((int)-7, (ActiveMQTestBase.ActiveMQAction)new ActiveMQTestBase.ActiveMQAction(){

            public void run() throws XAException {
                session.start(RandomUtil.randomXid(), 0);
            }
        });
    }

    @Test
    public void testCloseHierarchy() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        SimpleString queue = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        ClientSession session = this.sf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(address);
        ClientConsumer consumer = session.createConsumer(queue);
        session.close();
        Assert.assertTrue((boolean)session.isClosed());
        Assert.assertTrue((boolean)producer.isClosed());
        Assert.assertTrue((boolean)consumer.isClosed());
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig(), (boolean)false));
        this.server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(locator);
    }
}

