/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.connect;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPMirrorBrokerConnectionElement;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.protocol.amqp.broker.ActiveMQProtonRemotingConnection;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerTarget;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonAbstractReceiver;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PagedMirrorTest
extends ActiveMQTestBase {
    private static final Logger logger = Logger.getLogger(PagedMirrorTest.class);
    ActiveMQServer server1;
    ActiveMQServer server2;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server1 = this.createServer(true, this.createDefaultConfig(0, true), 1024, 10240L);
        this.server1.getConfiguration().getAcceptorConfigurations().clear();
        this.server1.getConfiguration().addAcceptorConfiguration("server", "tcp://localhost:61616");
        AMQPBrokerConnectConfiguration brokerConnectConfiguration = new AMQPBrokerConnectConfiguration("other", "tcp://localhost:61617").setReconnectAttempts(-1).setRetryInterval(1000);
        brokerConnectConfiguration.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement());
        this.server1.getConfiguration().addAMQPConnection(brokerConnectConfiguration);
        this.server2 = this.createServer(true, this.createDefaultConfig(1, true), 1024, 10240L);
        this.server2.getConfiguration().getAcceptorConfigurations().clear();
        this.server2.getConfiguration().addAcceptorConfiguration("server", "tcp://localhost:61617");
        brokerConnectConfiguration = new AMQPBrokerConnectConfiguration("other", "tcp://localhost:61616").setReconnectAttempts(-1).setRetryInterval(1000);
        brokerConnectConfiguration.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement());
        this.server2.getConfiguration().addAMQPConnection(brokerConnectConfiguration);
        this.server1.start();
        this.server2.start();
    }

    @Test
    public void testPaged() throws Throwable {
        TextMessage message;
        int i;
        jakarta.jms.Queue jmsQueue;
        String sendURI = "tcp://localhost:61616";
        String consumeURI = "tcp://localhost:61616";
        String secondConsumeURI = "tcp://localhost:61617";
        Wait.waitFor(() -> this.server1.locateQueue("$ACTIVEMQ_ARTEMIS_MIRROR_other") != null);
        Wait.waitFor(() -> this.server2.locateQueue("$ACTIVEMQ_ARTEMIS_MIRROR_other") != null);
        Queue snf1 = this.server2.locateQueue("$ACTIVEMQ_ARTEMIS_MIRROR_other");
        Assert.assertNotNull((Object)snf1);
        Queue snf2 = this.server1.locateQueue("$ACTIVEMQ_ARTEMIS_MIRROR_other");
        Assert.assertNotNull((Object)snf2);
        File countJournalLocation = this.server1.getConfiguration().getJournalLocation();
        Assert.assertTrue((countJournalLocation.exists() && countJournalLocation.isDirectory() ? (byte)1 : 0) != 0);
        String protocol = "amqp";
        ConnectionFactory sendCF = CFUtil.createConnectionFactory(protocol, sendURI);
        ConnectionFactory consumeCF = CFUtil.createConnectionFactory(protocol, consumeURI);
        ConnectionFactory secondConsumeCF = CFUtil.createConnectionFactory(protocol, secondConsumeURI);
        StringBuffer buffer = new StringBuffer();
        for (int i2 = 0; i2 < 1024; ++i2) {
            buffer.append("*");
        }
        String bodyBuffer = buffer.toString();
        int NUMBER_OF_MESSAGES = 200;
        int ACK_I = 77;
        try (Connection sendConnecton = sendCF.createConnection();){
            Session sendSession = sendConnecton.createSession(true, 0);
            jmsQueue = sendSession.createQueue("someQueue");
            MessageProducer producer = sendSession.createProducer((Destination)jmsQueue);
            for (i = 0; i < NUMBER_OF_MESSAGES; ++i) {
                message = sendSession.createTextMessage(bodyBuffer);
                message.setIntProperty("i", i);
                producer.send((Message)message);
            }
            sendSession.commit();
        }
        Wait.assertEquals((long)0L, () -> ((Queue)snf1).getMessageCount());
        Wait.assertEquals((long)0L, () -> ((Queue)snf2).getMessageCount());
        var15_16 = null;
        try (Connection consumeConnection = consumeCF.createConnection();){
            Session consumeSession = consumeConnection.createSession(false, 101);
            jmsQueue = consumeSession.createQueue("someQueue");
            MessageConsumer consumer = consumeSession.createConsumer((Destination)jmsQueue);
            consumeConnection.start();
            for (i = 0; i < NUMBER_OF_MESSAGES; ++i) {
                message = (TextMessage)consumer.receive(6000L);
                if (message.getIntProperty("i") != ACK_I) continue;
                message.acknowledge();
            }
            Assert.assertNull((Object)consumer.receiveNoWait());
        }
        catch (Throwable throwable) {
            var15_16 = throwable;
            throw throwable;
        }
        Wait.assertEquals((long)0L, () -> ((Queue)snf1).getMessageCount());
        Wait.assertEquals((long)0L, () -> ((Queue)snf2).getMessageCount());
        Wait.assertEquals((int)1, () -> this.acksCount(countJournalLocation), (long)5000L, (long)1000L);
        HashSet<Integer> receivedIDs = new HashSet<Integer>();
        try (Connection consumeConnection = secondConsumeCF.createConnection();){
            int i3;
            Session consumeSession = consumeConnection.createSession(true, 0);
            jakarta.jms.Queue jmsQueue2 = consumeSession.createQueue("someQueue");
            MessageConsumer consumer = consumeSession.createConsumer((Destination)jmsQueue2);
            consumeConnection.start();
            for (i3 = 0; i3 < NUMBER_OF_MESSAGES - 1; ++i3) {
                TextMessage message2 = (TextMessage)consumer.receive(6000L);
                Assert.assertNotNull((Object)message2);
                Assert.assertNotEquals((long)ACK_I, (long)message2.getIntProperty("i"));
                receivedIDs.add(message2.getIntProperty("i"));
            }
            Assert.assertNull((Object)consumer.receiveNoWait());
            Assert.assertEquals((long)(NUMBER_OF_MESSAGES - 1), (long)receivedIDs.size());
            for (i3 = 0; i3 < NUMBER_OF_MESSAGES; ++i3) {
                if (i3 == ACK_I) continue;
                Assert.assertTrue((boolean)receivedIDs.contains(i3));
            }
        }
    }

    @Test
    public void testAckWithScan() throws Throwable {
        Object producer;
        String sendURI = "tcp://localhost:61616";
        String consumeURI = "tcp://localhost:61617";
        Wait.waitFor(() -> this.server1.locateQueue("$ACTIVEMQ_ARTEMIS_MIRROR_other") != null);
        Wait.waitFor(() -> this.server2.locateQueue("$ACTIVEMQ_ARTEMIS_MIRROR_other") != null);
        Queue snf1 = this.server2.locateQueue("$ACTIVEMQ_ARTEMIS_MIRROR_other");
        Assert.assertNotNull((Object)snf1);
        Queue snf2 = this.server1.locateQueue("$ACTIVEMQ_ARTEMIS_MIRROR_other");
        Assert.assertNotNull((Object)snf2);
        File countJournalLocation = this.server1.getConfiguration().getJournalLocation();
        Assert.assertTrue((countJournalLocation.exists() && countJournalLocation.isDirectory() ? (byte)1 : 0) != 0);
        String protocol = "amqp";
        ConnectionFactory sendCF = CFUtil.createConnectionFactory(protocol, sendURI);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < 1024; ++i) {
            buffer.append("*");
        }
        String bodyBuffer = buffer.toString();
        int NUMBER_OF_MESSAGES = 200;
        try (Connection sendConnecton = sendCF.createConnection();){
            Session sendSession = sendConnecton.createSession(true, 0);
            jakarta.jms.Queue jmsQueue = sendSession.createQueue("someQueue");
            producer = sendSession.createProducer((Destination)jmsQueue);
            for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
                TextMessage message = sendSession.createTextMessage(bodyBuffer);
                message.setIntProperty("i", i);
                producer.send((Message)message);
            }
            sendSession.commit();
        }
        Wait.assertEquals((long)0L, () -> ((Queue)snf1).getMessageCount());
        Wait.assertEquals((long)0L, () -> ((Queue)snf2).getMessageCount());
        Queue serverQueue2 = this.server2.locateQueue("someQueue");
        Assert.assertNotNull((Object)serverQueue2);
        Queue serverQueue1 = this.server1.locateQueue("someQueue");
        Assert.assertNotNull((Object)serverQueue1);
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)serverQueue2).getMessageCount());
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)serverQueue1).getMessageCount());
        ConnectionFactory consumeCF = CFUtil.createConnectionFactory(protocol, consumeURI);
        Connection connection = consumeCF.createConnection();
        producer = null;
        try {
            connection.start();
            Session session = connection.createSession(true, 0);
            jakarta.jms.Queue jmsQueue = session.createQueue("someQueue");
            MessageConsumer consumer = session.createConsumer((Destination)jmsQueue);
            for (int i = 0; i < 10; ++i) {
                Message recMessage = consumer.receive(5000L);
                Assert.assertNotNull((Object)recMessage);
            }
            session.commit();
        }
        catch (Throwable session) {
            producer = session;
            throw session;
        }
        finally {
            if (connection != null) {
                if (producer != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable session) {
                        ((Throwable)producer).addSuppressed(session);
                    }
                } else {
                    connection.close();
                }
            }
        }
        Wait.assertEquals((long)(NUMBER_OF_MESSAGES - 10), () -> ((Queue)serverQueue2).getMessageCount());
        LinkedList refs = new LinkedList();
        serverQueue2.forEach(t -> refs.add(t));
        AMQPMirrorControllerTarget controllerTarget = PagedMirrorTest.locateMirrorTarget(this.server2);
        final CountDownLatch latch = new CountDownLatch(refs.size());
        IOCallback callback = new IOCallback(){

            public void done() {
                latch.countDown();
            }

            public void onError(int errorCode, String errorMessage) {
            }
        };
        for (MessageReference r : refs) {
            Long messageID = (Long)r.getMessage().getBrokerProperty(SimpleString.toSimpleString((String)"x-opt-amq-mr-id"));
            Object nodeID = r.getMessage().getBrokerProperty(SimpleString.toSimpleString((String)"x-opt-amq-bkr-id"));
            controllerTarget.performAckOnPage(nodeID.toString(), messageID.longValue(), serverQueue2, callback);
        }
        Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        Wait.assertEquals((long)(NUMBER_OF_MESSAGES - 10 - refs.size()), () -> ((Queue)serverQueue2).getMessageCount());
    }

    protected static AMQPMirrorControllerTarget locateMirrorTarget(ActiveMQServer server) {
        ActiveMQServerImpl theServer = (ActiveMQServerImpl)server;
        for (RemotingConnection connection : theServer.getRemotingService().getConnections()) {
            if (!(connection instanceof ActiveMQProtonRemotingConnection)) continue;
            ActiveMQProtonRemotingConnection protonRC = (ActiveMQProtonRemotingConnection)connection;
            for (AMQPSessionContext sessionContext : protonRC.getAmqpConnection().getSessions().values()) {
                for (ProtonAbstractReceiver receiver : sessionContext.getReceivers().values()) {
                    if (!(receiver instanceof AMQPMirrorControllerTarget)) continue;
                    return (AMQPMirrorControllerTarget)receiver;
                }
            }
        }
        return null;
    }

    private int acksCount(File countJournalLocation) throws Exception {
        HashMap countJournal = this.countJournal(countJournalLocation, 0xA00000, 2, 2);
        AtomicInteger acksCount = (AtomicInteger)countJournal.get(39);
        return acksCount != null ? acksCount.get() : 0;
    }
}

