/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.connect;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.CoreAddressConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionAddressType;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPMirrorBrokerConnectionElement;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.Assert;
import org.junit.Test;

public class AMQPScheduledCoreOverBrokerConnectTest
extends AmqpClientTestSupport {
    protected static final int AMQP_PORT_2 = 5673;
    ActiveMQServer server_2;

    @Override
    protected ActiveMQServer createServer() throws Exception {
        return this.createServer(5672, false);
    }

    @Override
    protected String getConfiguredProtocols() {
        return "AMQP,OPENWIRE,CORE";
    }

    @Test
    public void testWithDeliveryDelayCoreSendingConversion() throws Exception {
        String queueName = "withScheduled";
        this.server.setIdentity("targetServer");
        this.server.start();
        this.server.addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)queueName), RoutingType.ANYCAST));
        this.server.createQueue(new QueueConfiguration(queueName).setRoutingType(RoutingType.ANYCAST));
        this.server_2 = this.createServer(5673, false);
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:5672");
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement().setType(AMQPBrokerConnectionAddressType.MIRROR));
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server_2.getConfiguration().addAddressConfiguration(new CoreAddressConfiguration().setName(queueName).addRoutingType(RoutingType.ANYCAST));
        this.server_2.getConfiguration().addQueueConfiguration(new QueueConfiguration(queueName).setRoutingType(RoutingType.ANYCAST));
        this.server_2.setIdentity("serverWithBridge");
        this.server_2.start();
        Wait.assertTrue(() -> ((ActiveMQServer)this.server_2).isStarted());
        ConnectionFactory factory = CFUtil.createConnectionFactory("CORE", "tcp://localhost:5673");
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)session.createQueue(queueName));
        producer.setDeliveryMode(2);
        producer.setDeliveryDelay(300000L);
        producer.send(session.createMessage());
        ConnectionFactory factory2 = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        Connection connection2 = factory2.createConnection();
        Session session2 = connection2.createSession(false, 1);
        connection2.start();
        MessageConsumer consumer = session2.createConsumer((Destination)session2.createQueue(queueName));
        Assert.assertNull((Object)consumer.receive(500L));
    }
}

