/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSMessageGroupsTest
extends JMSClientTestSupport {
    protected static final Logger LOG = LoggerFactory.getLogger(JMSMessageGroupsTest.class);
    private static final int ITERATIONS = 10;
    private static final int MESSAGE_COUNT = 10;
    private static final int MESSAGE_SIZE = 10240;
    private static final int RECEIVE_TIMEOUT = 1000;
    private static final String JMSX_GROUP_ID = "JmsGroupsTest";
    private JMSClientTestSupport.ConnectionSupplier AMQPConnection = () -> this.createConnection();
    private JMSClientTestSupport.ConnectionSupplier CoreConnection = () -> this.createCoreConnection();
    private JMSClientTestSupport.ConnectionSupplier OpenWireConnection = () -> this.createOpenWireConnection();

    @Override
    protected String getConfiguredProtocols() {
        return "AMQP,OPENWIRE,CORE";
    }

    @Override
    protected void configureAddressPolicy(ActiveMQServer server) {
        super.configureAddressPolicy(server);
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        addressSettings.setAutoCreateQueues(Boolean.valueOf(this.isAutoCreateQueues()));
        addressSettings.setAutoCreateAddresses(Boolean.valueOf(this.isAutoCreateAddresses()));
        addressSettings.setDeadLetterAddress(SimpleString.toSimpleString((String)this.getDeadLetterAddress()));
        addressSettings.setExpiryAddress(SimpleString.toSimpleString((String)this.getDeadLetterAddress()));
        addressSettings.setDefaultGroupFirstKey(SimpleString.toSimpleString((String)"JMSXFirstInGroupID"));
        server.getConfiguration().getAddressesSettings().put("GroupFirst.#", addressSettings);
    }

    @Test(timeout=60000L)
    public void testMessageGroupsAMQPProducerAMQPConsumer() throws Exception {
        this.testMessageGroups(this.AMQPConnection, this.AMQPConnection);
    }

    @Test(timeout=60000L)
    public void testMessageGroupsCoreProducerCoreConsumer() throws Exception {
        this.testMessageGroups(this.CoreConnection, this.CoreConnection);
    }

    @Test(timeout=60000L)
    public void testMessageGroupsCoreProducerAMQPConsumer() throws Exception {
        this.testMessageGroups(this.CoreConnection, this.AMQPConnection);
    }

    @Test(timeout=60000L)
    public void testMessageGroupsAMQPProducerCoreConsumer() throws Exception {
        this.testMessageGroups(this.AMQPConnection, this.CoreConnection);
    }

    @Test(timeout=60000L)
    public void testMessageGroupsOpenWireProducerOpenWireConsumer() throws Exception {
        this.testMessageGroups(this.OpenWireConnection, this.OpenWireConnection);
    }

    @Test(timeout=60000L)
    public void testMessageGroupsCoreProducerOpenWireConsumer() throws Exception {
        this.testMessageGroups(this.CoreConnection, this.OpenWireConnection);
    }

    @Test(timeout=60000L)
    public void testMessageGroupsOpenWireProducerCoreConsumer() throws Exception {
        this.testMessageGroups(this.OpenWireConnection, this.CoreConnection);
    }

    @Test(timeout=60000L)
    public void testMessageGroupsAMQPProducerOpenWireConsumer() throws Exception {
        this.testMessageGroups(this.AMQPConnection, this.OpenWireConnection);
    }

    @Test(timeout=60000L)
    public void testMessageGroupsOpenWireProducerAMQPConsumer() throws Exception {
        this.testMessageGroups(this.OpenWireConnection, this.AMQPConnection);
    }

    public void testMessageGroups(JMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, JMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        this.testGroupSeqIsNeverLost(producerConnectionSupplier, consumerConnectionSupplier);
        this.testGroupSeqCloseGroup(producerConnectionSupplier, consumerConnectionSupplier);
        this.testGroupFirst(producerConnectionSupplier, consumerConnectionSupplier);
        this.testGroupFirstDefaultOff(producerConnectionSupplier, consumerConnectionSupplier);
    }

    public void testGroupSeqCloseGroup(JMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, JMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)this.getQueueName()));
        try (Connection producerConnection = producerConnectionSupplier.createConnection();
             Session producerSession = producerConnection.createSession(false, 1);
             MessageProducer producer = producerSession.createProducer((Destination)producerSession.createQueue(this.getQueueName()));
             Connection consumerConnection = producerConnectionSupplier.createConnection();
             Session consumerSession = consumerConnection.createSession(false, 1);
             MessageConsumer consumer1 = consumerSession.createConsumer((Destination)consumerSession.createQueue(this.getQueueName()));
             MessageConsumer consumer2 = consumerSession.createConsumer((Destination)consumerSession.createQueue(this.getQueueName()));
             MessageConsumer consumer3 = consumerSession.createConsumer((Destination)consumerSession.createQueue(this.getQueueName()));){
            producerConnection.start();
            consumerConnection.start();
            this.sendAndConsumeAndThenCloseGroup(producerSession, producer, consumer1, consumer2, consumer3, queueBinding);
            this.sendAndConsumeAndThenCloseGroup(producerSession, producer, consumer2, consumer3, consumer1, queueBinding);
            this.sendAndConsumeAndThenCloseGroup(producerSession, producer, consumer3, consumer1, consumer1, queueBinding);
        }
    }

    private void sendAndConsumeAndThenCloseGroup(Session producerSession, MessageProducer producer, MessageConsumer expectedGroupConsumer, MessageConsumer consumerA, MessageConsumer consumerB, QueueBinding queueBinding) throws JMSException {
        int j;
        for (j = 1; j <= 10; ++j) {
            TextMessage message = producerSession.createTextMessage();
            message.setStringProperty("JMSXGroupID", JMSX_GROUP_ID);
            message.setIntProperty("JMSXGroupSeq", j);
            message.setText("Message" + j);
            producer.send((Message)message);
        }
        for (j = 1; j <= 10; ++j) {
            TextMessage tm = (TextMessage)expectedGroupConsumer.receive(1000L);
            JMSMessageGroupsTest.assertNotNull((Object)tm);
            JMSMessageGroupsTest.assertEquals((Object)JMSX_GROUP_ID, (Object)tm.getStringProperty("JMSXGroupID"));
            JMSMessageGroupsTest.assertEquals((long)j, (long)tm.getIntProperty("JMSXGroupSeq"));
            JMSMessageGroupsTest.assertEquals((Object)("Message" + j), (Object)tm.getText());
            JMSMessageGroupsTest.assertNull((Object)consumerA.receiveNoWait());
            JMSMessageGroupsTest.assertNull((Object)consumerB.receiveNoWait());
        }
        JMSMessageGroupsTest.assertEquals((long)1L, (long)queueBinding.getQueue().getGroupCount());
        TextMessage message = producerSession.createTextMessage();
        message.setStringProperty("JMSXGroupID", JMSX_GROUP_ID);
        message.setIntProperty("JMSXGroupSeq", -1);
        message.setText("Message group close");
        producer.send((Message)message);
        TextMessage receivedGroupCloseMessage = (TextMessage)expectedGroupConsumer.receive(1000L);
        JMSMessageGroupsTest.assertNotNull((Object)receivedGroupCloseMessage);
        JMSMessageGroupsTest.assertEquals((Object)JMSX_GROUP_ID, (Object)receivedGroupCloseMessage.getStringProperty("JMSXGroupID"));
        JMSMessageGroupsTest.assertEquals((long)-1L, (long)receivedGroupCloseMessage.getIntProperty("JMSXGroupSeq"));
        JMSMessageGroupsTest.assertEquals((String)"group close should goto the existing group consumer", (Object)"Message group close", (Object)receivedGroupCloseMessage.getText());
        JMSMessageGroupsTest.assertNull((Object)consumerA.receiveNoWait());
        JMSMessageGroupsTest.assertNull((Object)consumerB.receiveNoWait());
        JMSMessageGroupsTest.assertEquals((long)0L, (long)queueBinding.getQueue().getGroupCount());
    }

    public void testGroupSeqIsNeverLost(JMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, JMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        AtomicInteger sequenceCounter = new AtomicInteger();
        AtomicInteger consumedSequenceCounter = new AtomicInteger();
        String queueName = this.getQueueName();
        for (int i = 0; i < 10; ++i) {
            try (Connection producerConnection = producerConnectionSupplier.createConnection();
                 Connection consumerConnection = consumerConnectionSupplier.createConnection();){
                this.sendMessagesToBroker(queueName, producerConnection, 10, sequenceCounter);
                this.readMessagesOnBroker(queueName, consumerConnection, 10, consumedSequenceCounter, null);
                continue;
            }
        }
    }

    public void testGroupFirst(JMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, JMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        AtomicInteger sequenceCounter = new AtomicInteger();
        AtomicInteger consumedSequenceCounter = new AtomicInteger();
        String queueName = "GroupFirst." + this.getQueueName();
        for (int i = 0; i < 10; ++i) {
            try (Connection producerConnection = producerConnectionSupplier.createConnection();
                 Connection consumerConnection = consumerConnectionSupplier.createConnection();){
                this.sendMessagesToBroker(queueName, producerConnection, 10, sequenceCounter);
                this.readMessagesOnBroker(queueName, consumerConnection, 10, consumedSequenceCounter, this::groupFirstCheck);
                continue;
            }
        }
    }

    private void groupFirstCheck(int i, Message message) {
        try {
            if (i == 0) {
                JMSMessageGroupsTest.assertTrue((String)"Message should be marked with first in Group", (boolean)message.getBooleanProperty("JMSXFirstInGroupID"));
            } else {
                JMSMessageGroupsTest.assertFalse((String)"Message should NOT be marked with first in Group", (boolean)message.propertyExists("JMSXFirstInGroupID"));
            }
        }
        catch (JMSException e) {
            JMSMessageGroupsTest.fail((String)e.getMessage());
        }
    }

    public void testGroupFirstDefaultOff(JMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, JMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        AtomicInteger sequenceCounter = new AtomicInteger();
        AtomicInteger consumedSequenceCounter = new AtomicInteger();
        String queueName = this.getQueueName();
        for (int i = 0; i < 10; ++i) {
            try (Connection producerConnection = producerConnectionSupplier.createConnection();
                 Connection consumerConnection = consumerConnectionSupplier.createConnection();){
                this.sendMessagesToBroker(queueName, producerConnection, 10, sequenceCounter);
                this.readMessagesOnBroker(queueName, consumerConnection, 10, consumedSequenceCounter, this::groupFirstOffCheck);
                continue;
            }
        }
    }

    private void groupFirstOffCheck(int i, Message message) {
        try {
            JMSMessageGroupsTest.assertFalse((String)"Message should NOT be marked with first in Group", (boolean)message.propertyExists("JMSXFirstInGroupID"));
        }
        catch (JMSException e) {
            JMSMessageGroupsTest.fail((String)e.getMessage());
        }
    }

    protected void readMessagesOnBroker(String queueName, Connection connection, int count, AtomicInteger sequence, BiConsumer<Integer, Message> additionalCheck) throws Exception {
        Session session = connection.createSession(false, 1);
        Queue queue = session.createQueue(queueName);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        for (int i = 0; i < 10; ++i) {
            Message message = consumer.receive(1000L);
            JMSMessageGroupsTest.assertNotNull((Object)message);
            LOG.debug("Read message #{}: type = {}", (Object)i, (Object)message.getClass().getSimpleName());
            String gid = message.getStringProperty("JMSXGroupID");
            int seq = message.getIntProperty("JMSXGroupSeq");
            LOG.debug("Message assigned JMSXGroupID := {}", (Object)gid);
            LOG.debug("Message assigned JMSXGroupSeq := {}", (Object)seq);
            JMSMessageGroupsTest.assertEquals((String)"Sequence order should match", (long)sequence.incrementAndGet(), (long)seq);
            if (additionalCheck == null) continue;
            additionalCheck.accept(i, message);
        }
        session.close();
    }

    protected void sendMessagesToBroker(String queueName, Connection connection, int count, AtomicInteger sequence) throws Exception {
        Session session = connection.createSession(false, 1);
        Queue queue = session.createQueue(queueName);
        MessageProducer producer = session.createProducer((Destination)queue);
        byte[] buffer = new byte[10240];
        for (count = 0; count < 10240; ++count) {
            String s = String.valueOf(count % 10);
            Character c = Character.valueOf(s.charAt(0));
            char value = c.charValue();
            buffer[count] = (byte)value;
        }
        LOG.debug("Sending {} messages to destination: {}", (Object)10, (Object)queue);
        for (int i = 1; i <= 10; ++i) {
            BytesMessage message = session.createBytesMessage();
            message.setJMSDeliveryMode(2);
            message.setStringProperty("JMSXGroupID", JMSX_GROUP_ID);
            message.setIntProperty("JMSXGroupSeq", sequence.incrementAndGet());
            message.writeBytes(buffer);
            producer.send((Message)message);
        }
        session.close();
    }
}

