/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import java.net.URI;
import java.util.LinkedList;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSConnectionFactory;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Before;

public abstract class JMSClientTestSupport
extends AmqpClientTestSupport {
    private static final Logger logger = Logger.getLogger(JMSClientTestSupport.class);
    protected LinkedList<Connection> jmsConnections = new LinkedList();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.disableCheckThread();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        try {
            for (Connection connection : this.jmsConnections) {
                try {
                    connection.close();
                }
                catch (Throwable ignored) {
                    ignored.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
        this.jmsConnections.clear();
        super.tearDown();
    }

    protected Connection trackJMSConnection(Connection connection) {
        this.jmsConnections.add(connection);
        return connection;
    }

    protected String getJmsConnectionURIOptions() {
        return "";
    }

    protected String getBrokerQpidJMSConnectionString() {
        try {
            int port = 5672;
            String uri = null;
            uri = this.isUseSSL() ? (this.isUseWebSockets() ? "amqpwss://127.0.0.1:" + port : "amqps://127.0.0.1:" + port) : (this.isUseWebSockets() ? "amqpws://127.0.0.1:" + port : "amqp://127.0.0.1:" + port);
            if (!this.getJmsConnectionURIOptions().isEmpty()) {
                uri = uri + "?" + this.getJmsConnectionURIOptions();
            }
            return uri;
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    protected URI getBrokerQpidJMSConnectionURI() {
        try {
            return new URI(this.getBrokerQpidJMSConnectionString());
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    protected URI getBrokerQpidJMSFailoverConnectionURI() {
        try {
            return new URI("failover:(" + this.getBrokerQpidJMSConnectionString() + ")");
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    protected Connection createConnection() throws JMSException {
        return this.createConnection(this.getBrokerQpidJMSConnectionURI(), null, null, null, true);
    }

    protected Connection createFailoverConnection() throws JMSException {
        return this.createConnection(this.getBrokerQpidJMSFailoverConnectionURI(), null, null, null, true);
    }

    protected Connection createConnection(boolean start) throws JMSException {
        return this.createConnection(this.getBrokerQpidJMSConnectionURI(), null, null, null, start);
    }

    protected Connection createConnection(String clientId) throws JMSException {
        return this.createConnection(this.getBrokerQpidJMSConnectionURI(), null, null, clientId, true);
    }

    protected Connection createConnection(String clientId, boolean start) throws JMSException {
        return this.createConnection(this.getBrokerQpidJMSConnectionURI(), null, null, clientId, start);
    }

    protected Connection createConnection(String username, String password) throws JMSException {
        return this.createConnection(this.getBrokerQpidJMSConnectionURI(), username, password, null, true);
    }

    protected Connection createConnection(String username, String password, String clientId) throws JMSException {
        return this.createConnection(this.getBrokerQpidJMSConnectionURI(), username, password, clientId, true);
    }

    protected Connection createConnection(String username, String password, String clientId, boolean start) throws JMSException {
        return this.createConnection(this.getBrokerQpidJMSConnectionURI(), username, password, clientId, start);
    }

    private Connection createConnection(URI remoteURI, String username, String password, String clientId, boolean start) throws JMSException {
        JmsConnectionFactory factory = new JmsConnectionFactory(remoteURI);
        Connection connection = this.trackJMSConnection(factory.createConnection(username, password));
        connection.setExceptionListener(new ExceptionListener(){

            public void onException(JMSException exception) {
                exception.printStackTrace();
            }
        });
        if (clientId != null && !clientId.isEmpty()) {
            connection.setClientID(clientId);
        }
        if (start) {
            connection.start();
        }
        return connection;
    }

    protected String getBrokerCoreJMSConnectionString() {
        try {
            int port = 5672;
            String uri = null;
            uri = this.isUseSSL() ? "tcp://127.0.0.1:" + port : "tcp://127.0.0.1:" + port;
            if (!this.getJmsConnectionURIOptions().isEmpty()) {
                uri = uri + "?" + this.getJmsConnectionURIOptions();
            }
            return uri;
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    protected Connection createCoreConnection() throws JMSException {
        return this.createCoreConnection(this.getBrokerCoreJMSConnectionString(), null, null, null, true);
    }

    protected Connection createCoreConnection(boolean start) throws JMSException {
        return this.createCoreConnection(this.getBrokerCoreJMSConnectionString(), null, null, null, start);
    }

    private Connection createCoreConnection(String connectionString, String username, String password, String clientId, boolean start) throws JMSException {
        ActiveMQJMSConnectionFactory factory = new ActiveMQJMSConnectionFactory(connectionString);
        Connection connection = this.trackJMSConnection(factory.createConnection(username, password));
        connection.setExceptionListener(new ExceptionListener(){

            public void onException(JMSException exception) {
                exception.printStackTrace();
            }
        });
        if (clientId != null && !clientId.isEmpty()) {
            connection.setClientID(clientId);
        }
        if (start) {
            connection.start();
        }
        return connection;
    }

    protected String getBrokerOpenWireJMSConnectionString() {
        try {
            int port = 5672;
            String uri = null;
            uri = this.isUseSSL() ? "tcp://127.0.0.1:" + port : "tcp://127.0.0.1:" + port;
            uri = !this.getJmsConnectionURIOptions().isEmpty() ? uri + "?" + this.getJmsConnectionURIOptions() : uri + "?wireFormat.cacheEnabled=true";
            return uri;
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    protected Connection createOpenWireConnection() throws JMSException {
        return this.createOpenWireConnection(this.getBrokerOpenWireJMSConnectionString(), null, null, null, true);
    }

    protected Connection createOpenWireConnection(boolean start) throws JMSException {
        return this.createOpenWireConnection(this.getBrokerOpenWireJMSConnectionString(), null, null, null, false);
    }

    private Connection createOpenWireConnection(String connectionString, String username, String password, String clientId, boolean start) throws JMSException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(connectionString);
        Connection connection = this.trackJMSConnection(factory.createConnection(username, password));
        connection.setExceptionListener(new ExceptionListener(){

            public void onException(JMSException exception) {
                exception.printStackTrace();
            }
        });
        if (clientId != null && !clientId.isEmpty()) {
            connection.setClientID(clientId);
        }
        if (start) {
            connection.start();
        }
        return connection;
    }

    static interface ConnectionSupplier {
        public Connection createConnection() throws JMSException;
    }
}

