/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import java.security.Principal;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.transport.jms.JMSConfiguration;

public final class SecurityContextFactory {
    private SecurityContextFactory() {
    }

    public static SecurityContext buildSecurityContext(Message message, JMSConfiguration config) throws JMSException {
        String tempUserName = message.getStringProperty("JMSXUserID");
        if (tempUserName == null && config.isJmsProviderTibcoEms()) {
            tempUserName = message.getStringProperty("JMS_TIBCO_SENDER");
        }
        if (tempUserName == null) {
            return null;
        }
        final String jmsUserName = tempUserName;
        final Principal principal = new Principal(){

            @Override
            public String getName() {
                return jmsUserName;
            }
        };
        return new SecurityContext(){

            public Principal getUserPrincipal() {
                return principal;
            }

            public boolean isUserInRole(String role) {
                return false;
            }
        };
    }
}

