/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.hibernate.HibernateException;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeReference;
import org.hibernate.type.CustomType;
import org.hibernate.type.ProcedureParameterExtractionAware;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.internal.BasicTypeImpl;
import org.hibernate.type.internal.ConvertedBasicTypeImpl;
import org.hibernate.type.internal.CustomMutabilityConvertedBasicTypeImpl;
import org.hibernate.type.internal.ImmutableNamedBasicTypeImpl;
import org.hibernate.type.internal.NamedBasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.UserType;

public class BasicTypeRegistry
implements Serializable {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(BasicTypeRegistry.class);
    private final TypeConfiguration typeConfiguration;
    private final Map<JdbcType, Map<JavaType<?>, BasicType<?>>> registryValues = new ConcurrentHashMap();
    private boolean primed;
    private final Map<String, BasicType<?>> typesByName = new ConcurrentHashMap();
    private final Map<String, BasicTypeReference<?>> typeReferencesByName = new ConcurrentHashMap();

    public BasicTypeRegistry(TypeConfiguration typeConfiguration) {
        this.typeConfiguration = typeConfiguration;
    }

    public <J> BasicType<J> getRegisteredType(String key) {
        BasicType<?> basicType = this.typesByName.get(key);
        if (basicType == null) {
            basicType = this.resolveTypeReference(key);
        }
        return basicType;
    }

    private BasicType<?> resolveTypeReference(String name) {
        ProcedureParameterExtractionAware<Object> type;
        BasicType<?> basicType;
        BasicTypeReference<?> typeReference = this.typeReferencesByName.get(name);
        if (typeReference == null) {
            return null;
        }
        if (!name.equals(typeReference.getName()) && (basicType = this.typesByName.get(typeReference.getName())) != null) {
            return basicType;
        }
        JavaType javaType = this.typeConfiguration.getJavaTypeRegistry().getDescriptor(typeReference.getBindableJavaType());
        JdbcType jdbcType = this.typeConfiguration.getJdbcTypeRegistry().getDescriptor(typeReference.getSqlTypeCode());
        if (typeReference.getConverter() == null) {
            type = typeReference.isForceImmutable() ? new ImmutableNamedBasicTypeImpl(javaType, jdbcType, typeReference.getName()) : new NamedBasicTypeImpl(javaType, jdbcType, typeReference.getName());
        } else {
            BasicValueConverter<?, ?> converter = typeReference.getConverter();
            assert (javaType == converter.getDomainJavaType());
            type = typeReference.isForceImmutable() ? new CustomMutabilityConvertedBasicTypeImpl(typeReference.getName(), jdbcType, converter, ImmutableMutabilityPlan.instance()) : new ConvertedBasicTypeImpl(typeReference.getName(), jdbcType, converter);
        }
        this.primeRegistryEntry((BasicType<?>)((Object)type));
        this.typesByName.put(typeReference.getName(), (BasicType<?>)((Object)type));
        this.typesByName.put(name, (BasicType<?>)((Object)type));
        return type;
    }

    public <J> BasicType<J> getRegisteredType(java.lang.reflect.Type javaType) {
        if (javaType instanceof Class) {
            return this.getRegisteredType((Class)javaType);
        }
        return this.getRegisteredType(javaType.getTypeName());
    }

    public <J> BasicType<J> getRegisteredType(Class<J> javaType) {
        return this.getRegisteredType(javaType.getName());
    }

    public <J> BasicType<J> resolve(BasicTypeReference<J> basicTypeReference) {
        return this.getRegisteredType(basicTypeReference.getName());
    }

    public <J> BasicType<J> resolve(Class<J> javaType, int sqlTypeCode) {
        return this.resolve((java.lang.reflect.Type)javaType, sqlTypeCode);
    }

    public <J> BasicType<J> resolve(java.lang.reflect.Type javaType, int sqlTypeCode) {
        return this.resolve(this.typeConfiguration.getJavaTypeRegistry().getDescriptor(javaType), sqlTypeCode);
    }

    public <J> BasicType<J> resolve(JavaType<J> jtdToUse, int sqlTypeCode) {
        return this.resolve(jtdToUse, this.typeConfiguration.getJdbcTypeRegistry().getDescriptor(sqlTypeCode));
    }

    public <J> BasicType<J> resolve(JavaType<J> jtdToUse, JdbcType stdToUse) {
        return this.resolve(jtdToUse, stdToUse, () -> {
            BasicTypeImpl basicType = new BasicTypeImpl(jtdToUse, stdToUse);
            try {
                this.typeConfiguration.getMetadataBuildingContext().getBootstrapContext().registerAdHocBasicType(basicType);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return basicType;
        });
    }

    public <J> BasicType<J> resolve(JavaType<J> jtdToUse, JdbcType stdToUse, String baseTypeName) {
        return this.resolve(jtdToUse, stdToUse, () -> new NamedBasicTypeImpl(jtdToUse, stdToUse, baseTypeName));
    }

    public <J> BasicType<J> resolve(JavaType<J> jtdToUse, JdbcType stdToUse, Supplier<BasicType<J>> creator) {
        Map typeByJtdForStd = this.registryValues.computeIfAbsent(stdToUse, sqlTypeDescriptor -> new ConcurrentHashMap());
        BasicType foundBasicType = (BasicType)typeByJtdForStd.get(jtdToUse);
        if (foundBasicType != null) {
            return foundBasicType;
        }
        BasicType<J> basicType = this.getRegisteredType(jtdToUse.getJavaType());
        if (basicType != null) {
            if (basicType.getJdbcType() == stdToUse) {
                return basicType;
            }
            return new NamedBasicTypeImpl<J>(jtdToUse, stdToUse, basicType.getName());
        }
        BasicType<J> createdBasicType = creator.get();
        typeByJtdForStd.put(jtdToUse, createdBasicType);
        return createdBasicType;
    }

    public void register(BasicType<?> type) {
        this.register(type, type.getRegistrationKeys());
    }

    public void register(BasicType<?> type, String key) {
        this.typesByName.put(key, type);
    }

    public void register(BasicType<?> type, String ... keys) {
        if (!this.isPrimed()) {
            throw new IllegalStateException("BasicTypeRegistry not yet primed.  Calls to `#register` not valid until after primed");
        }
        if (type == null) {
            throw new HibernateException("Type to register cannot be null");
        }
        this.applyOrOverwriteEntry(type);
        if (CollectionHelper.isEmpty(keys)) {
            LOG.typeDefinedNoRegistrationKeys(type);
        } else {
            this.applyRegistrationKeys(type, keys);
        }
    }

    private void applyOrOverwriteEntry(BasicType<?> type) {
        Map mappingsForStdToUse = this.registryValues.computeIfAbsent(type.getJdbcType(), sqlTypeDescriptor -> new ConcurrentHashMap());
        BasicType<?> existing = mappingsForStdToUse.put(type.getMappedJavaType(), type);
        if (existing != null) {
            LOG.debugf("BasicTypeRegistry registration overwritten (%s + %s); previous =`%s`", type.getJdbcType().getFriendlyName(), type.getJavaTypeDescriptor(), existing);
        }
    }

    public <T> CustomType<T> register(UserType<T> type, String ... keys) {
        CustomType<T> customType = new CustomType<T>(type, keys, this.typeConfiguration);
        this.register(customType);
        return customType;
    }

    public void unregister(String ... keys) {
        for (String key : keys) {
            this.typesByName.remove(key);
        }
    }

    public boolean isPrimed() {
        return this.primed;
    }

    public void primed() {
        this.primed = true;
    }

    public void addPrimeEntry(BasicType<?> type, String legacyTypeClassName, String[] registrationKeys) {
        if (this.primed) {
            throw new IllegalStateException("BasicTypeRegistry already primed");
        }
        if (type == null) {
            throw new HibernateException("Type to register cannot be null");
        }
        this.primeRegistryEntry(type);
        if (StringHelper.isNotEmpty(legacyTypeClassName)) {
            this.typesByName.put(legacyTypeClassName, type);
        }
        if (registrationKeys == null || registrationKeys.length == 0) {
            LOG.typeDefinedNoRegistrationKeys(type);
        } else {
            this.applyRegistrationKeys(type, registrationKeys);
        }
    }

    public void addPrimeEntry(BasicTypeReference<?> type, String legacyTypeClassName, String[] registrationKeys) {
        if (this.primed) {
            throw new IllegalStateException("BasicTypeRegistry already primed");
        }
        if (type == null) {
            throw new HibernateException("Type to register cannot be null");
        }
        if (StringHelper.isNotEmpty(legacyTypeClassName)) {
            this.typeReferencesByName.put(legacyTypeClassName, type);
        }
        if (registrationKeys == null || registrationKeys.length == 0) {
            LOG.typeDefinedNoRegistrationKeys(type);
        } else {
            this.applyRegistrationKeys(type, registrationKeys);
        }
    }

    private void primeRegistryEntry(BasicType<?> type) {
        Map mappingsForStdToUse = this.registryValues.computeIfAbsent(type.getJdbcType(), sqlTypeDescriptor -> new ConcurrentHashMap());
        BasicType existing = (BasicType)mappingsForStdToUse.get(type.getMappedJavaType());
        if (existing != null) {
            LOG.debugf("Skipping registration of BasicType (%s + %s); still priming.  existing = %s", type.getJdbcType().getFriendlyName(), type.getJavaTypeDescriptor(), existing);
        } else {
            mappingsForStdToUse.put(type.getMappedJavaType(), type);
        }
    }

    private void applyRegistrationKeys(BasicType<?> type, String[] keys) {
        for (String key : keys) {
            if (key == null) continue;
            key = key.intern();
            LOG.debugf("Adding type registration %s -> %s", key, type);
            Type old = this.typesByName.put(key, type);
            if (old == null || old == type) continue;
            LOG.debugf("Type registration key [%s] overrode previous entry : `%s`", key, old);
        }
    }

    private void applyRegistrationKeys(BasicTypeReference<?> type, String[] keys) {
        for (String key : keys) {
            if (key == null) continue;
            key = key.intern();
            LOG.debugf("Adding type registration %s -> %s", key, type);
            BasicTypeReference<?> old = this.typeReferencesByName.put(key, type);
            if (old == null || old == type) continue;
            LOG.debugf("Type registration key [%s] overrode previous entry : `%s`", key, old);
        }
    }
}

