/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.function.BiConsumer;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.internal.AbstractCompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetchable;

public class EmbeddedIdentifierMappingImpl
extends AbstractCompositeIdentifierMapping
implements SingleAttributeIdentifierMapping {
    private final String name;
    private final EmbeddableMappingType embeddableDescriptor;
    private final PropertyAccess propertyAccess;

    public EmbeddedIdentifierMappingImpl(EntityMappingType entityMapping, String name, EmbeddableMappingType embeddableDescriptor, PropertyAccess propertyAccess, String tableExpression, MappingModelCreationProcess creationProcess) {
        super(entityMapping, tableExpression, creationProcess);
        this.name = name;
        this.embeddableDescriptor = embeddableDescriptor;
        this.propertyAccess = propertyAccess;
    }

    @Override
    public String getPartName() {
        return this.name;
    }

    @Override
    public EmbeddableMappingType getPartMappingType() {
        return this.embeddableDescriptor;
    }

    @Override
    public EmbeddableMappingType getMappedIdEmbeddableTypeDescriptor() {
        return this.getMappedType();
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.getEmbeddableTypeDescriptor().applySqlSelections(navigablePath, tableGroup, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        this.getEmbeddableTypeDescriptor().applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
    }

    @Override
    public Object getIdentifier(Object entity, SharedSessionContractImplementor session) {
        if (entity instanceof HibernateProxy) {
            return ((HibernateProxy)entity).getHibernateLazyInitializer().getIdentifier();
        }
        return this.propertyAccess.getGetter().get(entity);
    }

    @Override
    public Object getIdentifier(Object entity) {
        if (entity instanceof HibernateProxy) {
            return ((HibernateProxy)entity).getHibernateLazyInitializer().getIdentifier();
        }
        return this.propertyAccess.getGetter().get(entity);
    }

    @Override
    public void setIdentifier(Object entity, Object id, SharedSessionContractImplementor session) {
        this.propertyAccess.getSetter().set(entity, id);
    }

    @Override
    public String getSqlAliasStem() {
        return this.name;
    }

    @Override
    public String getFetchableName() {
        return this.name;
    }

    @Override
    public int getNumberOfFetchables() {
        return this.getEmbeddableTypeDescriptor().getNumberOfAttributeMappings();
    }

    @Override
    public Fetchable getFetchable(int position) {
        return this.getEmbeddableTypeDescriptor().getFetchable(position);
    }

    @Override
    public PropertyAccess getPropertyAccess() {
        return this.propertyAccess;
    }

    @Override
    public String getAttributeName() {
        return this.name;
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        this.getEmbeddableTypeDescriptor().breakDownJdbcValues(domainValue, valueConsumer, session);
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        return this.getEmbeddableTypeDescriptor().forEachDisassembledJdbcValue(value, clause, offset, valuesConsumer, session);
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        EmbeddableMappingType embeddableTypeDescriptor = this.getEmbeddableTypeDescriptor();
        Object[] result = new Object[embeddableTypeDescriptor.getNumberOfAttributeMappings()];
        embeddableTypeDescriptor.forEachAttributeMapping((i, mapping) -> {
            Object o = mapping.getPropertyAccess().getGetter().get(value);
            result[i] = mapping.disassemble(o, session);
        });
        return result;
    }
}

