/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import jakarta.persistence.Parameter;
import org.hibernate.FlushMode;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.spi.CollectionLoader;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.query.spi.QueryImplementor;

public class CollectionLoaderNamedQuery
implements CollectionLoader {
    private final CollectionPersister persister;
    private final NamedQueryMemento namedQueryMemento;

    public CollectionLoaderNamedQuery(CollectionPersister persister, NamedQueryMemento namedQueryMemento) {
        this.persister = persister;
        this.namedQueryMemento = namedQueryMemento;
    }

    @Override
    public PluralAttributeMapping getLoadable() {
        return this.persister.getAttributeMapping();
    }

    @Override
    public PersistentCollection<?> load(Object key, SharedSessionContractImplementor session) {
        QueryImplementor query = this.namedQueryMemento.toQuery(session);
        query.setParameter((Parameter)query.getParameters().iterator().next(), key);
        query.setHibernateFlushMode(FlushMode.MANUAL);
        return (PersistentCollection)query.getResultList().get(0);
    }
}

