/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.metamodel.mapping.JdbcMapping;

public class FilterDefinition
implements Serializable {
    private final String filterName;
    private final String defaultFilterCondition;
    private final Map<String, JdbcMapping> explicitParamJaMappings = new HashMap<String, JdbcMapping>();

    public FilterDefinition(String name, String defaultCondition, Map<String, JdbcMapping> explicitParamJaMappings) {
        this.filterName = name;
        this.defaultFilterCondition = defaultCondition;
        if (explicitParamJaMappings != null) {
            this.explicitParamJaMappings.putAll(explicitParamJaMappings);
        }
    }

    public String getFilterName() {
        return this.filterName;
    }

    public Set<String> getParameterNames() {
        return this.explicitParamJaMappings.keySet();
    }

    public JdbcMapping getParameterJdbcMapping(String parameterName) {
        return this.explicitParamJaMappings.get(parameterName);
    }

    public String getDefaultFilterCondition() {
        return this.defaultFilterCondition;
    }
}

