/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.composite;

import jakarta.ejb.TimerConfig;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.timerservice.composite.CompositeTimerService;
import org.jboss.as.ejb3.timerservice.composite.CompositeTimerServiceConfiguration;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerService;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerServiceConfiguration;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerServiceFactory;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerServiceFactoryConfiguration;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvokerFactory;
import org.jboss.as.ejb3.timerservice.spi.TimerListener;
import org.jboss.as.ejb3.timerservice.spi.TimerServiceRegistry;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;

public class CompositeTimerServiceFactoryServiceConfigurator
extends SimpleServiceNameProvider
implements ServiceConfigurator,
ManagedTimerServiceFactory {
    private final TimedObjectInvokerFactory invokerFactory;
    private final TimerServiceRegistry registry;
    private final SupplierDependency<ManagedTimerServiceFactory> transientFactory;
    private final SupplierDependency<ManagedTimerServiceFactory> persistentFactory;

    public CompositeTimerServiceFactoryServiceConfigurator(ServiceName name, ManagedTimerServiceFactoryConfiguration configuration) {
        super(name);
        this.invokerFactory = configuration.getInvokerFactory();
        this.registry = configuration.getTimerServiceRegistry();
        this.transientFactory = new ServiceSupplierDependency(ManagedTimerServiceConfiguration.TimerFilter.TRANSIENT.apply(name));
        this.persistentFactory = new ServiceSupplierDependency(ManagedTimerServiceConfiguration.TimerFilter.PERSISTENT.apply(name));
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceName name = this.getServiceName();
        ServiceBuilder builder = target.addService(name);
        Consumer factory = new CompositeDependency(new Dependency[]{this.transientFactory, this.persistentFactory}).register(builder).provides(new ServiceName[]{name});
        return builder.setInstance(Service.newInstance((Consumer)factory, (Object)this)).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public ManagedTimerService createTimerService(EJBComponent component) {
        final TimedObjectInvoker invoker = this.invokerFactory.createInvoker(component);
        final ManagedTimerService transientTimerService = ((ManagedTimerServiceFactory)this.transientFactory.get()).createTimerService(component);
        final ManagedTimerService persistentTimerService = ((ManagedTimerServiceFactory)this.persistentFactory.get()).createTimerService(component);
        final TimerServiceRegistry registry = this.registry;
        return new CompositeTimerService(new CompositeTimerServiceConfiguration(){

            @Override
            public TimedObjectInvoker getInvoker() {
                return invoker;
            }

            @Override
            public TimerServiceRegistry getTimerServiceRegistry() {
                return registry;
            }

            @Override
            public TimerListener getTimerListener() {
                return null;
            }

            @Override
            public ManagedTimerService getTransientTimerService() {
                return transientTimerService;
            }

            @Override
            public ManagedTimerService getPersistentTimerService() {
                return persistentTimerService;
            }

            @Override
            public Predicate<TimerConfig> getTimerFilter() {
                return ManagedTimerServiceConfiguration.TimerFilter.ALL;
            }
        });
    }
}

