/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.remote.LocalTransportProvider;
import org.jboss.as.ejb3.remote.RemotingProfileService;
import org.jboss.as.ejb3.subsystem.RemoteConnectorChannelCreationOptionResource;
import org.jboss.as.ejb3.subsystem.RemoteHttpConnectionDefinition;
import org.jboss.as.ejb3.subsystem.RemotingEjbReceiverDefinition;
import org.jboss.as.ejb3.subsystem.RemotingProfileResourceDefinition;
import org.jboss.as.ejb3.subsystem.StaticEJBDiscoveryDefinition;
import org.jboss.as.network.OutboundConnection;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.ejb.client.EJBTransportProvider;
import org.jboss.msc.Service;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.RemotingOptions;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.ServiceURL;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;

public class RemotingProfileAdd
extends AbstractAddStepHandler {
    private static final String OUTBOUND_CONNECTION_CAPABILITY_NAME = "org.wildfly.remoting.outbound-connection";

    RemotingProfileAdd(AttributeDefinition ... attributes) {
        super(attributes);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        context.addStep((context1, operation1) -> context1.addStep((OperationStepHandler)ServiceInstallStepHandler.INSTANCE, OperationContext.Stage.RUNTIME), OperationContext.Stage.RUNTIME);
    }

    protected void installServices(OperationContext context, PathAddress address, ModelNode profileNode) throws OperationFailedException {
        try {
            ModelNode staticEjbDiscoery = StaticEJBDiscoveryDefinition.INSTANCE.resolveModelAttribute(context, profileNode);
            List<StaticEJBDiscoveryDefinition.StaticEjbDiscovery> discoveryList = StaticEJBDiscoveryDefinition.createStaticEjbList(context, staticEjbDiscoery);
            ArrayList<ServiceURL> urls = new ArrayList<ServiceURL>();
            for (StaticEJBDiscoveryDefinition.StaticEjbDiscovery resource : discoveryList) {
                ServiceURL.Builder builder = new ServiceURL.Builder();
                builder.setAbstractType("ejb").setAbstractTypeAuthority("jboss").setUri(new URI(resource.getUrl()));
                String distinctName = resource.getDistinct() == null ? "" : resource.getDistinct();
                String appName = resource.getApp() == null ? "" : resource.getApp();
                String moduleName = resource.getModule();
                if (distinctName.isEmpty()) {
                    if (appName.isEmpty()) {
                        builder.addAttribute("ejb-module", AttributeValue.fromString((String)moduleName));
                    } else {
                        builder.addAttribute("ejb-module", AttributeValue.fromString((String)((String)appName + "/" + moduleName)));
                    }
                } else if (appName.isEmpty()) {
                    builder.addAttribute("ejb-module-distinct", AttributeValue.fromString((String)(moduleName + "/" + distinctName)));
                } else {
                    builder.addAttribute("ejb-module-distinct", AttributeValue.fromString((String)((String)appName + "/" + moduleName + "/" + distinctName)));
                }
                urls.add(builder.create());
            }
            HashMap<String, RemotingProfileService.RemotingConnectionSpec> map = new HashMap<String, RemotingProfileService.RemotingConnectionSpec>();
            ArrayList<RemotingProfileService.HttpConnectionSpec> httpConnectionSpecs = new ArrayList<RemotingProfileService.HttpConnectionSpec>();
            RemotingProfileService profileService = new RemotingProfileService(urls, map, httpConnectionSpecs);
            CapabilityServiceBuilder capabilityServiceBuilder = context.getCapabilityServiceTarget().addCapability(RemotingProfileResourceDefinition.REMOTING_PROFILE_CAPABILITY);
            capabilityServiceBuilder.setInstance((Service)profileService);
            if (profileNode.hasDefined("remoting-ejb-receiver")) {
                for (Object receiverProperty : profileNode.get("remoting-ejb-receiver").asPropertyList()) {
                    ModelNode receiverNode = receiverProperty.getValue();
                    String connectionRef = RemotingEjbReceiverDefinition.OUTBOUND_CONNECTION_REF.resolveModelAttribute(context, receiverNode).asString();
                    long timeout = RemotingEjbReceiverDefinition.CONNECT_TIMEOUT.resolveModelAttribute(context, receiverNode).asLong();
                    InjectedValue connectionInjector = new InjectedValue();
                    capabilityServiceBuilder.addCapabilityRequirement(OUTBOUND_CONNECTION_CAPABILITY_NAME, OutboundConnection.class, (Injector)connectionInjector, new String[]{connectionRef});
                    ModelNode channelCreationOptionsNode = receiverNode.get("channel-creation-options");
                    OptionMap channelCreationOptions = this.createChannelOptionMap(context, channelCreationOptionsNode);
                    map.put(connectionRef, new RemotingProfileService.RemotingConnectionSpec(connectionRef, (InjectedValue<OutboundConnection>)connectionInjector, channelCreationOptions, timeout));
                }
            }
            boolean isLocalReceiverExcluded = RemotingProfileResourceDefinition.EXCLUDE_LOCAL_RECEIVER.resolveModelAttribute(context, profileNode).asBoolean();
            if (profileNode.hasDefined("remote-http-connection")) {
                for (Property receiverProperty : profileNode.get("remote-http-connection").asPropertyList()) {
                    ModelNode receiverNode = receiverProperty.getValue();
                    String uri = RemoteHttpConnectionDefinition.URI.resolveModelAttribute(context, receiverNode).asString();
                    httpConnectionSpecs.add(new RemotingProfileService.HttpConnectionSpec(uri));
                }
            }
            if (!isLocalReceiverExcluded) {
                ModelNode passByValueNode = RemotingProfileResourceDefinition.LOCAL_RECEIVER_PASS_BY_VALUE.resolveModelAttribute(context, profileNode);
                if (passByValueNode.isDefined()) {
                    ServiceName localTransportProviderServiceName = passByValueNode.asBoolean() ? LocalTransportProvider.BY_VALUE_SERVICE_NAME : LocalTransportProvider.BY_REFERENCE_SERVICE_NAME;
                    capabilityServiceBuilder.addDependency(localTransportProviderServiceName, EJBTransportProvider.class, profileService.getLocalTransportProviderInjector());
                } else {
                    capabilityServiceBuilder.addDependency(LocalTransportProvider.DEFAULT_LOCAL_TRANSPORT_PROVIDER_SERVICE_NAME, EJBTransportProvider.class, profileService.getLocalTransportProviderInjector());
                }
            }
            capabilityServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            throw new OperationFailedException(e.getLocalizedMessage());
        }
    }

    private OptionMap createChannelOptionMap(OperationContext context, ModelNode channelCreationOptionsNode) throws OperationFailedException {
        OptionMap optionMap;
        if (channelCreationOptionsNode.isDefined()) {
            OptionMap.Builder optionMapBuilder = OptionMap.builder();
            ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
            for (Property optionProperty : channelCreationOptionsNode.asPropertyList()) {
                String name = optionProperty.getName();
                ModelNode propValueModel = optionProperty.getValue();
                String type = RemoteConnectorChannelCreationOptionResource.CHANNEL_CREATION_OPTION_TYPE.resolveModelAttribute(context, propValueModel).asString();
                String optionClassName = this.getClassNameForChannelOptionType(type);
                String fullyQualifiedOptionName = optionClassName + "." + name;
                Option option = Option.fromString((String)fullyQualifiedOptionName, (ClassLoader)loader);
                String value = RemoteConnectorChannelCreationOptionResource.CHANNEL_CREATION_OPTION_VALUE.resolveModelAttribute(context, propValueModel).asString();
                optionMapBuilder.set(option, option.parseValue(value, loader));
            }
            optionMap = optionMapBuilder.getMap();
        } else {
            optionMap = OptionMap.EMPTY;
        }
        return optionMap;
    }

    private String getClassNameForChannelOptionType(String optionType) {
        if ("remoting".equals(optionType)) {
            return RemotingOptions.class.getName();
        }
        if ("xnio".equals(optionType)) {
            return Options.class.getName();
        }
        throw EjbLogger.ROOT_LOGGER.unknownChannelCreationOptionType(optionType);
    }

    private static class ServiceInstallStepHandler
    implements OperationStepHandler {
        private static final ServiceInstallStepHandler INSTANCE = new ServiceInstallStepHandler();

        private ServiceInstallStepHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
            ModelNode model = Resource.Tools.readModel((Resource)resource);
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            RemotingProfileResourceDefinition.ADD_HANDLER.installServices(context, address, model);
        }
    }
}

