/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import jakarta.ejb.DependsOn;
import java.util.Set;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEApplicationDescription;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.metadata.ClassAnnotationInformation;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.singleton.SingletonComponentDescription;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.ejb.spec.SessionBean31MetaData;

public class EjbDependsOnMergingProcessor
extends AbstractMergingProcessor<EJBComponentDescription> {
    public EjbDependsOnMergingProcessor() {
        super(EJBComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription description) throws DeploymentUnitProcessingException {
        EEModuleClassDescription classDescription = applicationClasses.getClassByName(componentClass.getName());
        if (classDescription == null) {
            return;
        }
        EEApplicationDescription applicationDescription = (EEApplicationDescription)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_DESCRIPTION);
        ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT);
        ClassAnnotationInformation dependsOnClassAnnotationInformation = classDescription.getAnnotationInformation(DependsOn.class);
        if (dependsOnClassAnnotationInformation != null && !dependsOnClassAnnotationInformation.getClassLevelAnnotations().isEmpty()) {
            String[] annotationValues = (String[])dependsOnClassAnnotationInformation.getClassLevelAnnotations().get(0);
            this.setupDependencies(description, applicationDescription, deploymentRoot, annotationValues);
        }
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription description) throws DeploymentUnitProcessingException {
        SessionBean31MetaData metaData;
        EEApplicationDescription applicationDescription = (EEApplicationDescription)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_DESCRIPTION);
        ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT);
        if (description.getDescriptorData() instanceof SessionBean31MetaData && (metaData = (SessionBean31MetaData)description.getDescriptorData()).getDependsOn() != null) {
            this.setupDependencies(description, applicationDescription, deploymentRoot, metaData.getDependsOn());
        }
    }

    private void setupDependencies(EJBComponentDescription description, EEApplicationDescription applicationDescription, ResourceRoot deploymentRoot, String[] annotationValues) throws DeploymentUnitProcessingException {
        for (String annotationValue : annotationValues) {
            Set components = applicationDescription.getComponents(annotationValue, deploymentRoot.getRoot());
            if (components.isEmpty()) {
                throw EjbLogger.ROOT_LOGGER.failToFindEjbRefByDependsOn(annotationValue, description.getComponentClassName());
            }
            if (components.size() != 1) {
                throw EjbLogger.ROOT_LOGGER.failToCallEjbRefByDependsOn(annotationValue, description.getComponentClassName(), components);
            }
            ComponentDescription component = (ComponentDescription)components.iterator().next();
            description.addDependency(component.getStartServiceName());
            if (!(description instanceof SingletonComponentDescription)) continue;
            ((SingletonComponentDescription)description).getDependsOn().add(component.getStartServiceName());
            if (!EjbLogger.ROOT_LOGGER.isDebugEnabled()) continue;
            EjbLogger.ROOT_LOGGER.debugf(description.getEJBName() + " bean is dependent on " + component.getComponentName(), new Object[0]);
        }
    }
}

