/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import jakarta.ejb.ConcurrencyManagement;
import jakarta.ejb.ConcurrencyManagementType;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.metadata.ClassAnnotationInformation;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.ejb.spec.SessionBean31MetaData;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;

public class ConcurrencyManagementMergingProcessor
extends AbstractMergingProcessor<SessionBeanComponentDescription> {
    public ConcurrencyManagementMergingProcessor() {
        super(SessionBeanComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, SessionBeanComponentDescription componentConfiguration) throws DeploymentUnitProcessingException {
        EEModuleClassDescription clazz = applicationClasses.getClassByName(componentClass.getName());
        if (clazz == null) {
            return;
        }
        ClassAnnotationInformation management = clazz.getAnnotationInformation(ConcurrencyManagement.class);
        if (management == null) {
            return;
        }
        if (!management.getClassLevelAnnotations().isEmpty()) {
            componentConfiguration.setConcurrencyManagementType((ConcurrencyManagementType)management.getClassLevelAnnotations().get(0));
        }
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, SessionBeanComponentDescription componentConfiguration) throws DeploymentUnitProcessingException {
        SessionBean31MetaData descriptor;
        ConcurrencyManagementType type;
        if (componentConfiguration.getDescriptorData() == null) {
            return;
        }
        SessionBeanMetaData data = componentConfiguration.getDescriptorData();
        if (data instanceof SessionBean31MetaData && (type = (descriptor = (SessionBean31MetaData)data).getConcurrencyManagementType()) != null) {
            componentConfiguration.setConcurrencyManagementType(type);
        }
    }
}

