/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jboss.as.ejb3.deployment.DeploymentModuleIdentifier;
import org.jboss.as.ejb3.deployment.DeploymentRepository;
import org.jboss.as.ejb3.deployment.DeploymentRepositoryListener;
import org.jboss.as.ejb3.deployment.ModuleDeployment;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class DeploymentRepositoryService
implements DeploymentRepository,
Service<DeploymentRepository> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ee", "deploymentRepository"});
    private volatile Map<DeploymentModuleIdentifier, DeploymentHolder> modules;
    private final List<DeploymentRepositoryListener> listeners = new ArrayList<DeploymentRepositoryListener>();
    private volatile boolean suspended = false;

    public void start(StartContext context) throws StartException {
        this.modules = Collections.emptyMap();
    }

    public void stop(StopContext context) {
        this.modules = Collections.emptyMap();
    }

    public DeploymentRepository getValue() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(DeploymentModuleIdentifier identifier, ModuleDeployment deployment) {
        boolean suspended;
        ArrayList<DeploymentRepositoryListener> listeners;
        DeploymentRepositoryService deploymentRepositoryService = this;
        synchronized (deploymentRepositoryService) {
            HashMap<DeploymentModuleIdentifier, DeploymentHolder> modules = new HashMap<DeploymentModuleIdentifier, DeploymentHolder>(this.modules);
            modules.put(identifier, new DeploymentHolder(deployment));
            this.modules = Collections.unmodifiableMap(modules);
            listeners = new ArrayList<DeploymentRepositoryListener>(this.listeners);
            suspended = this.suspended;
        }
        for (DeploymentRepositoryListener listener : listeners) {
            try {
                listener.deploymentAvailable(identifier, deployment);
                if (!suspended) continue;
                listener.deploymentSuspended(identifier);
            }
            catch (Throwable t) {
                EjbLogger.DEPLOYMENT_LOGGER.deploymentAddListenerException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startDeployment(DeploymentModuleIdentifier identifier) {
        ArrayList<DeploymentRepositoryListener> listeners;
        DeploymentHolder deployment;
        DeploymentRepositoryService deploymentRepositoryService = this;
        synchronized (deploymentRepositoryService) {
            deployment = this.modules.get(identifier);
            if (deployment == null) {
                return false;
            }
            deployment.started = true;
            listeners = new ArrayList<DeploymentRepositoryListener>(this.listeners);
        }
        for (DeploymentRepositoryListener listener : listeners) {
            try {
                listener.deploymentStarted(identifier, deployment.deployment);
            }
            catch (Throwable t) {
                EjbLogger.DEPLOYMENT_LOGGER.deploymentAddListenerException(t);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(DeploymentRepositoryListener listener) {
        DeploymentRepositoryService deploymentRepositoryService = this;
        synchronized (deploymentRepositoryService) {
            this.listeners.add(listener);
        }
        listener.listenerAdded(this);
    }

    @Override
    public synchronized void removeListener(DeploymentRepositoryListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(DeploymentModuleIdentifier identifier) {
        ArrayList<DeploymentRepositoryListener> listeners;
        DeploymentRepositoryService deploymentRepositoryService = this;
        synchronized (deploymentRepositoryService) {
            HashMap<DeploymentModuleIdentifier, DeploymentHolder> modules = new HashMap<DeploymentModuleIdentifier, DeploymentHolder>(this.modules);
            modules.remove(identifier);
            this.modules = Collections.unmodifiableMap(modules);
            listeners = new ArrayList<DeploymentRepositoryListener>(this.listeners);
        }
        for (DeploymentRepositoryListener listener : listeners) {
            try {
                listener.deploymentRemoved(identifier);
            }
            catch (Throwable t) {
                EjbLogger.DEPLOYMENT_LOGGER.deploymentRemoveListenerException(t);
            }
        }
    }

    @Override
    public boolean isSuspended() {
        return this.suspended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspend() {
        ArrayList<DeploymentRepositoryListener> listeners;
        HashSet<DeploymentModuleIdentifier> moduleIdentifiers;
        DeploymentRepositoryService deploymentRepositoryService = this;
        synchronized (deploymentRepositoryService) {
            moduleIdentifiers = new HashSet<DeploymentModuleIdentifier>(this.modules.keySet());
            listeners = new ArrayList<DeploymentRepositoryListener>(this.listeners);
            this.suspended = true;
        }
        for (DeploymentRepositoryListener listener : listeners) {
            for (DeploymentModuleIdentifier moduleIdentifier : moduleIdentifiers) {
                try {
                    listener.deploymentSuspended(moduleIdentifier);
                }
                catch (Throwable t) {
                    EjbLogger.DEPLOYMENT_LOGGER.deploymentAddListenerException(t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        ArrayList<DeploymentRepositoryListener> listeners;
        HashSet<DeploymentModuleIdentifier> moduleIdentifiers;
        DeploymentRepositoryService deploymentRepositoryService = this;
        synchronized (deploymentRepositoryService) {
            moduleIdentifiers = new HashSet<DeploymentModuleIdentifier>(this.modules.keySet());
            listeners = new ArrayList<DeploymentRepositoryListener>(this.listeners);
            this.suspended = false;
        }
        for (DeploymentRepositoryListener listener : listeners) {
            for (DeploymentModuleIdentifier moduleIdentifier : moduleIdentifiers) {
                try {
                    listener.deploymentResumed(moduleIdentifier);
                }
                catch (Throwable t) {
                    EjbLogger.DEPLOYMENT_LOGGER.deploymentAddListenerException(t);
                }
            }
        }
    }

    @Override
    public Map<DeploymentModuleIdentifier, ModuleDeployment> getModules() {
        HashMap<DeploymentModuleIdentifier, ModuleDeployment> modules = new HashMap<DeploymentModuleIdentifier, ModuleDeployment>();
        for (Map.Entry<DeploymentModuleIdentifier, DeploymentHolder> entry : this.modules.entrySet()) {
            modules.put(entry.getKey(), entry.getValue().deployment);
        }
        return modules;
    }

    @Override
    public Map<DeploymentModuleIdentifier, ModuleDeployment> getStartedModules() {
        HashMap<DeploymentModuleIdentifier, ModuleDeployment> modules = new HashMap<DeploymentModuleIdentifier, ModuleDeployment>();
        for (Map.Entry<DeploymentModuleIdentifier, DeploymentHolder> entry : this.modules.entrySet()) {
            if (!entry.getValue().started) continue;
            modules.put(entry.getKey(), entry.getValue().deployment);
        }
        return modules;
    }

    private static final class DeploymentHolder {
        final ModuleDeployment deployment;
        volatile boolean started = false;

        private DeploymentHolder(ModuleDeployment deployment) {
            this.deployment = deployment;
        }
    }
}

