/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.gson.impl;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementTypes;

public final class GsonUtils {
    private GsonUtils() {
    }

    public static void setOrAppendToArray(JsonObject object, String propertyName, JsonElement newValue) {
        JsonElement currentValue = object.get(propertyName);
        if (currentValue == null) {
            object.add(propertyName, newValue);
        } else if (JsonElementTypes.ARRAY.isInstance(currentValue)) {
            JsonElementTypes.ARRAY.fromElement(currentValue).add(newValue);
        } else {
            JsonArray array = new JsonArray();
            array.add(currentValue);
            array.add(newValue);
            object.add(propertyName, (JsonElement)array);
        }
    }

    public static <T> T deepCopy(Gson gson, Class<T> objectType, T object) {
        return (T)gson.fromJson(gson.toJsonTree(object), objectType);
    }
}

