/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchIndexFieldReference;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.AbstractElasticsearchIndexCompositeNodeBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexNodeCollector;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexNodeContributor;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexCompositeNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexField;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexValueField;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.AbstractTypeMapping;
import org.hibernate.search.backend.elasticsearch.types.impl.ElasticsearchIndexValueFieldType;
import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldOptionsStep;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaBuildContext;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldInclusion;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

class ElasticsearchIndexValueFieldBuilder<F>
implements IndexSchemaFieldOptionsStep<ElasticsearchIndexValueFieldBuilder<F>, IndexFieldReference<F>>,
ElasticsearchIndexNodeContributor,
IndexSchemaBuildContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final AbstractElasticsearchIndexCompositeNodeBuilder parent;
    private final String relativeFieldName;
    private final String absoluteFieldPath;
    private final IndexFieldInclusion inclusion;
    private final ElasticsearchIndexValueFieldType<F> type;
    private boolean multiValued = false;
    private ElasticsearchIndexFieldReference<F> reference;

    ElasticsearchIndexValueFieldBuilder(AbstractElasticsearchIndexCompositeNodeBuilder parent, String relativeFieldName, IndexFieldInclusion inclusion, ElasticsearchIndexValueFieldType<F> type) {
        this.parent = parent;
        this.relativeFieldName = relativeFieldName;
        this.absoluteFieldPath = FieldPaths.compose((String)parent.getAbsolutePath(), (String)relativeFieldName);
        this.inclusion = inclusion;
        this.type = type;
    }

    public EventContext eventContext() {
        return this.parent.getRootNodeBuilder().getIndexEventContext().append(EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
    }

    public ElasticsearchIndexValueFieldBuilder<F> multiValued() {
        this.multiValued = true;
        return this;
    }

    public IndexFieldReference<F> toReference() {
        if (this.reference != null) {
            throw log.cannotCreateReferenceMultipleTimes(this.eventContext());
        }
        this.reference = new ElasticsearchIndexFieldReference();
        return this.reference;
    }

    @Override
    public void contribute(ElasticsearchIndexNodeCollector collector, ElasticsearchIndexCompositeNode parentNode, Map<String, ElasticsearchIndexField> staticChildrenByNameForParent, AbstractTypeMapping parentMapping) {
        if (this.reference == null) {
            throw log.incompleteFieldDefinition(this.eventContext());
        }
        ElasticsearchIndexValueField<F> fieldNode = new ElasticsearchIndexValueField<F>(parentNode, this.relativeFieldName, this.type, this.inclusion, this.multiValued);
        staticChildrenByNameForParent.put(this.relativeFieldName, fieldNode);
        collector.collect(this.absoluteFieldPath, fieldNode);
        if (IndexFieldInclusion.INCLUDED.equals((Object)fieldNode.inclusion())) {
            parentMapping.addProperty(this.relativeFieldName, this.type.mapping());
        }
        this.reference.setSchemaNode(fieldNode);
    }
}

