/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.reporting.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.hibernate.search.engine.reporting.EntityIndexingFailureContext;
import org.hibernate.search.engine.reporting.FailureContext;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.util.common.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LogFailureHandler
implements FailureHandler {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    public static final String NAME = "log";

    @Override
    public void handle(FailureContext context) {
        log.exceptionOccurred(this.formatMessage(context).toString(), context.throwable());
    }

    @Override
    public void handle(EntityIndexingFailureContext context) {
        log.exceptionOccurred(this.formatMessage(context).toString(), context.throwable());
    }

    private StringBuilder formatMessage(FailureContext context) {
        Throwable throwable = context.throwable();
        Object failingOperation = context.failingOperation();
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append("Exception occurred ").append(throwable).append("\n");
        messageBuilder.append("Failing operation:\n");
        messageBuilder.append(failingOperation);
        messageBuilder.append("\n");
        return messageBuilder;
    }

    private StringBuilder formatMessage(EntityIndexingFailureContext context) {
        List<Object> entityReferences = context.entityReferences();
        StringBuilder messageBuilder = this.formatMessage((FailureContext)context);
        if (!entityReferences.isEmpty()) {
            messageBuilder.append("Entities that could not be indexed correctly:\n");
            for (Object entityReference : entityReferences) {
                messageBuilder.append(entityReference);
                messageBuilder.append(" ");
            }
        }
        return messageBuilder;
    }
}

