/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.reporting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.search.engine.reporting.FailureContext;

public class EntityIndexingFailureContext
extends FailureContext {
    private final List<Object> entityReferences;

    public static Builder builder() {
        return new Builder();
    }

    private EntityIndexingFailureContext(Builder builder) {
        super(builder);
        this.entityReferences = builder.entityReferences == null ? Collections.emptyList() : Collections.unmodifiableList(builder.entityReferences);
    }

    public List<Object> entityReferences() {
        return this.entityReferences;
    }

    @Override
    public String toString() {
        return "EntityIndexingFailureContext{entityReferences=" + this.entityReferences + ", throwable=" + this.throwable + ", failingOperation=" + this.failingOperation + '}';
    }

    public static class Builder
    extends FailureContext.Builder {
        private List<Object> entityReferences;

        private Builder() {
        }

        public void entityReference(Object entityReference) {
            if (this.entityReferences == null) {
                this.entityReferences = new ArrayList<Object>();
            }
            this.entityReferences.add(entityReference);
        }

        @Override
        public EntityIndexingFailureContext build() {
            return new EntityIndexingFailureContext(this);
        }
    }
}

