/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.commons.util.ProcessorInfo;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.ThreadPoolConfigurationBuilder;
import org.infinispan.factories.threads.EnhancedQueueExecutorFactory;
import org.jboss.as.clustering.infinispan.executors.DefaultNonBlockingThreadFactory;
import org.jboss.as.clustering.infinispan.subsystem.GlobalComponentServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.threads.management.ManageableThreadPoolExecutorService;
import org.wildfly.clustering.context.DefaultThreadFactory;
import org.wildfly.clustering.service.ServiceConfigurator;

public class ThreadPoolServiceConfigurator
extends GlobalComponentServiceConfigurator<ThreadPoolConfiguration> {
    private final ThreadPoolConfigurationBuilder builder = new ThreadPoolConfigurationBuilder(null);
    private final ThreadPoolDefinition definition;

    ThreadPoolServiceConfigurator(ThreadPoolDefinition definition, PathAddress address) {
        super(definition, address);
        this.definition = definition;
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        int minThreads = this.definition.getMinThreads().resolveModelAttribute((ExpressionResolver)context, model).asInt();
        int maxThreads = this.definition.getMaxThreads().resolveModelAttribute((ExpressionResolver)context, model).asInt();
        int queueLength = this.definition.getQueueLength().resolveModelAttribute((ExpressionResolver)context, model).asInt();
        long keepAliveTime = this.definition.getKeepAliveTime().resolveModelAttribute((ExpressionResolver)context, model).asLong();
        boolean nonBlocking = this.definition.isNonBlocking();
        if (this.definition == ThreadPoolResourceDefinition.NON_BLOCKING) {
            int availableProcessors = ProcessorInfo.availableProcessors();
            minThreads *= availableProcessors;
            maxThreads *= availableProcessors;
        }
        this.builder.threadPoolFactory((ThreadPoolExecutorFactory)(nonBlocking ? new NonBlockingThreadPoolExecutorFactory(maxThreads, minThreads, queueLength, keepAliveTime) : new BlockingThreadPoolExecutorFactory(maxThreads, minThreads, queueLength, keepAliveTime)));
        return this;
    }

    @Override
    public ThreadPoolConfiguration get() {
        return this.builder.create();
    }

    private static class NonBlockingThreadPoolExecutorFactory
    extends org.infinispan.factories.threads.NonBlockingThreadPoolExecutorFactory {
        NonBlockingThreadPoolExecutorFactory(int maxThreads, int coreThreads, int queueLength, long keepAlive) {
            super(maxThreads, coreThreads, queueLength, keepAlive);
        }

        public ExecutorService createExecutor(ThreadFactory factory) {
            return super.createExecutor((ThreadFactory)((Object)new DefaultNonBlockingThreadFactory(factory)));
        }
    }

    private static class BlockingThreadPoolExecutorFactory
    extends EnhancedQueueExecutorFactory {
        BlockingThreadPoolExecutorFactory(int maxThreads, int coreThreads, int queueLength, long keepAlive) {
            super(maxThreads, coreThreads, queueLength, keepAlive);
        }

        public ManageableThreadPoolExecutorService createExecutor(ThreadFactory factory) {
            return super.createExecutor((ThreadFactory)new DefaultThreadFactory(factory));
        }
    }
}

