/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.lifecycle.Phase;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import jakarta.el.MethodExpression;
import jakarta.faces.FacesException;
import jakarta.faces.application.ProtectedViewException;
import jakarta.faces.application.ViewExpiredException;
import jakarta.faces.application.ViewHandler;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.component.visit.VisitHint;
import jakarta.faces.component.visit.VisitResult;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ComponentSystemEvent;
import jakarta.faces.event.ExceptionQueuedEvent;
import jakarta.faces.event.ExceptionQueuedEventContext;
import jakarta.faces.event.PhaseEvent;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PhaseListener;
import jakarta.faces.event.PostRestoreStateEvent;
import jakarta.faces.flow.FlowHandler;
import jakarta.faces.lifecycle.Lifecycle;
import jakarta.faces.render.ResponseStateManager;
import jakarta.faces.view.ViewDeclarationLanguage;
import jakarta.faces.view.ViewMetadata;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.EnumSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RestoreViewPhase
extends Phase {
    private static final String WEBAPP_ERROR_PAGE_MARKER = "jakarta.servlet.error.message";
    private static final Logger LOGGER = FacesLogger.LIFECYCLE.getLogger();
    private static String SKIP_ITERATION_HINT = "jakarta.faces.visit.SKIP_ITERATION";

    @Override
    public PhaseId getId() {
        return PhaseId.RESTORE_VIEW;
    }

    @Override
    public void doPhase(FacesContext context, Lifecycle lifecycle, ListIterator<PhaseListener> listeners) {
        Util.getViewHandler(context).initView(context);
        super.doPhase(context, lifecycle, listeners);
        this.notifyAfter(context, lifecycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(FacesContext facesContext) throws FacesException {
        LOGGER.fine("Entering RestoreViewPhase");
        if (facesContext == null) {
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_CONTEXT_ERROR", new Object[0]));
        }
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot != null) {
            LOGGER.fine("Found a pre created view in FacesContext");
            facesContext.getViewRoot().setLocale(facesContext.getExternalContext().getRequestLocale());
            this.deliverPostRestoreStateEvent(facesContext);
            if (!facesContext.isPostback()) {
                facesContext.renderResponse();
            }
            return;
        }
        FacesException thrownException = null;
        try {
            Map requestMap = facesContext.getExternalContext().getRequestMap();
            String viewId = (String)requestMap.get("jakarta.servlet.include.path_info");
            if (viewId == null) {
                viewId = facesContext.getExternalContext().getRequestPathInfo();
            }
            if (viewId == null) {
                viewId = (String)requestMap.get("jakarta.servlet.include.servlet_path");
            }
            if (viewId == null) {
                viewId = facesContext.getExternalContext().getRequestServletPath();
            }
            if (viewId == null) {
                throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_REQUEST_VIEW_ERROR", new Object[0]));
            }
            ViewHandler viewHandler = Util.getViewHandler(facesContext);
            if (facesContext.isPostback() && !RestoreViewPhase.isErrorPage(facesContext)) {
                facesContext.setProcessingEvents(false);
                viewRoot = viewHandler.restoreView(facesContext, viewId);
                if (viewRoot == null) {
                    Object[] params = new Object[]{viewId};
                    throw new ViewExpiredException(MessageUtils.getExceptionMessageString("com.sun.faces.RESTORE_VIEW_ERROR", params), viewId);
                }
                facesContext.setViewRoot(viewRoot);
                facesContext.setProcessingEvents(true);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Postback: restored view for " + viewId);
                }
            } else {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("New request: creating a view for " + viewId);
                }
                String logicalViewId = viewHandler.deriveLogicalViewId(facesContext, viewId);
                ViewDeclarationLanguage vdl = viewHandler.getViewDeclarationLanguage(facesContext, logicalViewId);
                this.maybeTakeProtectedViewAction(facesContext, viewHandler, vdl, logicalViewId);
                ViewMetadata metadata = null;
                if (vdl != null && (metadata = vdl.getViewMetadata(facesContext, logicalViewId)) != null && !ViewMetadata.hasMetadata((UIViewRoot)(viewRoot = metadata.createMetadataView(facesContext)))) {
                    facesContext.renderResponse();
                }
                if (vdl == null || metadata == null) {
                    facesContext.renderResponse();
                }
                if (viewRoot == null) {
                    viewRoot = Util.getViewHandler(facesContext).createView(facesContext, logicalViewId);
                }
                facesContext.setViewRoot(viewRoot);
            }
        }
        catch (Throwable fe) {
            thrownException = fe instanceof FacesException ? (FacesException)fe : new FacesException(fe);
        }
        finally {
            if (thrownException == null) {
                FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
                if (flowHandler != null) {
                    flowHandler.clientWindowTransition(facesContext);
                }
            } else {
                throw thrownException;
            }
            this.deliverPostRestoreStateEvent(facesContext);
        }
        LOGGER.fine("Exiting RestoreViewPhase");
    }

    private void maybeTakeProtectedViewAction(FacesContext context, ViewHandler viewHandler, ViewDeclarationLanguage vdl, String viewId) {
        Set urlPatterns = viewHandler.getProtectedViewsUnmodifiable();
        if (this.isProtectedView(viewId, urlPatterns)) {
            String origin;
            boolean originIsInProtectedSet;
            String referer;
            boolean refererIsInProtectedSet;
            ExternalContext extContext = context.getExternalContext();
            Map headers = extContext.getRequestHeaderMap();
            ResponseStateManager rsm = RenderKitUtils.getResponseStateManager(context, viewHandler.calculateRenderKitId(context));
            String incomingSecretKeyValue = (String)extContext.getRequestParameterMap().get("jakarta.faces.Token");
            if (incomingSecretKeyValue != null) {
                try {
                    incomingSecretKeyValue = URLEncoder.encode(incomingSecretKeyValue, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "Unable to re-encode value of request parameter jakarta.faces.Token:" + incomingSecretKeyValue, e);
                    }
                    incomingSecretKeyValue = null;
                }
            }
            String correctSecretKeyValue = rsm.getCryptographicallyStrongTokenFromSession(context);
            if (incomingSecretKeyValue == null || !correctSecretKeyValue.equals(incomingSecretKeyValue)) {
                LOGGER.log(Level.SEVERE, "correctSecretKeyValue = {0} incomingSecretKeyValue = {1}", new Object[]{correctSecretKeyValue, incomingSecretKeyValue});
                throw new ProtectedViewException();
            }
            if (headers.containsKey("Referer") && !(refererIsInProtectedSet = this.isProtectedView(referer = (String)headers.get("Referer"), urlPatterns))) {
                boolean refererOriginatesInThisWebapp = false;
                try {
                    refererOriginatesInThisWebapp = this.originatesInWebapp(context, referer, vdl);
                }
                catch (URISyntaxException ue) {
                    throw new ProtectedViewException((Throwable)ue);
                }
                if (!refererOriginatesInThisWebapp) {
                    String message = FacesLogger.LIFECYCLE.interpolateMessage(context, "faces.lifecycle.invalid.referer", new String[]{referer, viewId});
                    LOGGER.log(Level.SEVERE, message);
                    throw new ProtectedViewException(message);
                }
            }
            if (headers.containsKey("Origin") && !(originIsInProtectedSet = this.isProtectedView(origin = (String)headers.get("Origin"), urlPatterns))) {
                boolean originOriginatesInThisWebapp = false;
                try {
                    originOriginatesInThisWebapp = this.originatesInWebapp(context, origin, vdl);
                }
                catch (URISyntaxException ue) {
                    throw new ProtectedViewException((Throwable)ue);
                }
                if (!originOriginatesInThisWebapp) {
                    String message = FacesLogger.LIFECYCLE.interpolateMessage(context, "faces.lifecycle.invalid.origin", new String[]{origin, viewId});
                    LOGGER.log(Level.SEVERE, message);
                    throw new ProtectedViewException(message);
                }
            }
        }
    }

    private boolean isProtectedView(String viewToCheck, Set<String> urlPatterns) {
        boolean isProtected = false;
        for (String urlPattern : urlPatterns) {
            if (!urlPattern.equals(viewToCheck)) continue;
            isProtected = true;
            break;
        }
        return isProtected;
    }

    private boolean originatesInWebapp(FacesContext context, String view, ViewDeclarationLanguage vdl) throws URISyntaxException {
        boolean doesOriginate = false;
        ExternalContext extContext = context.getExternalContext();
        String sep = "/";
        URI uri = null;
        String path = null;
        boolean isAbsoluteURI = view.matches("^[a-z]+://.*");
        if (!isAbsoluteURI) {
            URI absoluteURI = null;
            URI relativeURI = null;
            String base = extContext.getRequestScheme() + ":" + sep + sep + extContext.getRequestServerName() + ":" + extContext.getRequestServerPort();
            absoluteURI = new URI(base);
            relativeURI = new URI(view);
            uri = absoluteURI.resolve(relativeURI);
        }
        boolean hostsMatch = false;
        boolean portsMatch = false;
        boolean contextPathsMatch = false;
        if (uri == null) {
            uri = new URI(view);
        }
        hostsMatch = uri.getHost() == null ? false : uri.getHost().equals(extContext.getRequestServerName());
        portsMatch = uri.getPort() == -1 ? Util.isOneOf(extContext.getRequestServerPort(), 80, 443) : uri.getPort() == extContext.getRequestServerPort();
        path = uri.getPath();
        contextPathsMatch = path.contains(extContext.getApplicationContextPath());
        boolean bl = doesOriginate = hostsMatch && portsMatch && contextPathsMatch;
        if (!doesOriginate) {
            int idx = path.lastIndexOf(sep);
            if (-1 != idx) {
                path = path.substring(idx);
            }
            doesOriginate = path != null && vdl.viewExists(context, path);
        }
        return doesOriginate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverPostRestoreStateEvent(FacesContext facesContext) throws FacesException {
        UIViewRoot root = facesContext.getViewRoot();
        PostRestoreStateEvent postRestoreStateEvent = new PostRestoreStateEvent((UIComponent)root);
        try {
            facesContext.getAttributes().put(SKIP_ITERATION_HINT, true);
            facesContext.getApplication().publishEvent(facesContext, PostRestoreStateEvent.class, (Object)root);
            EnumSet<VisitHint> hints = EnumSet.of(VisitHint.SKIP_ITERATION);
            VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext, null, hints);
            root.visitTree(visitContext, (context, target) -> {
                postRestoreStateEvent.setComponent(target);
                target.processEvent((ComponentSystemEvent)postRestoreStateEvent);
                return VisitResult.ACCEPT;
            });
        }
        catch (AbortProcessingException e) {
            facesContext.getApplication().publishEvent(facesContext, ExceptionQueuedEvent.class, (Object)new ExceptionQueuedEventContext(facesContext, (Throwable)e, null, PhaseId.RESTORE_VIEW));
        }
        finally {
            facesContext.getAttributes().remove(SKIP_ITERATION_HINT);
        }
    }

    private void notifyAfter(FacesContext context, Lifecycle lifecycle) {
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot == null) {
            return;
        }
        MethodExpression afterPhase = viewRoot.getAfterPhaseListener();
        if (afterPhase != null) {
            try {
                PhaseEvent event = new PhaseEvent(context, PhaseId.RESTORE_VIEW, lifecycle);
                afterPhase.invoke(context.getELContext(), new Object[]{event});
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "severe.component.unable_to_process_expression", new Object[]{afterPhase.getExpressionString(), "afterPhase"});
                }
                return;
            }
        }
    }

    private static boolean isErrorPage(FacesContext context) {
        return context.getExternalContext().getRequestMap().get(WEBAPP_ERROR_PAGE_MARKER) != null;
    }
}

