/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms;

import jakarta.jms.ConnectionMetaData;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ManagedConnectionFactory;
import java.io.PrintWriter;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jms.JmsConnectionFactoryImpl;
import org.jboss.resource.adapter.jms.JmsConnectionMetaData;
import org.jboss.resource.adapter.jms.JmsConnectionRequestInfo;
import org.jboss.resource.adapter.jms.JmsCred;
import org.jboss.resource.adapter.jms.JmsMCFProperties;
import org.jboss.resource.adapter.jms.JmsManagedConnection;
import org.jboss.resource.adapter.jms.util.Strings;

public class JmsManagedConnectionFactory
implements ManagedConnectionFactory {
    private static final long serialVersionUID = -923483284031773011L;
    private static final Logger log = Logger.getLogger(JmsManagedConnection.class);
    private final JmsMCFProperties mcfProperties = new JmsMCFProperties();
    private Boolean strict = true;
    private Integer useTryLock = 60;
    private Boolean deleteTemporaryDestinations = true;
    private Boolean jms_2_0 = true;

    public Object createConnectionFactory() throws ResourceException {
        return this.createConnectionFactory(null);
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        JmsConnectionFactoryImpl cf = new JmsConnectionFactoryImpl(this, cxManager);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created connection factory: " + cf + ", using connection manager: " + cxManager));
        }
        return cf;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        boolean trace = log.isTraceEnabled();
        info = this.getInfo(info);
        if (trace) {
            log.trace((Object)("connection request info: " + info));
        }
        JmsCred cred = JmsCred.getJmsCred(this, subject, info);
        if (trace) {
            log.trace((Object)("jms credentials: " + cred));
        }
        JmsManagedConnection mc = new JmsManagedConnection(this, info, cred.name, Strings.fromCharArray(cred.pwd));
        if (trace) {
            log.trace((Object)("created new managed connection: " + mc));
        }
        return mc;
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info) throws ResourceException {
        boolean trace = log.isTraceEnabled();
        info = this.getInfo(info);
        JmsCred cred = JmsCred.getJmsCred(this, subject, info);
        if (trace) {
            log.trace((Object)("Looking for connection matching credentials: " + cred));
        }
        for (Object obj : connectionSet) {
            if (!(obj instanceof JmsManagedConnection)) continue;
            JmsManagedConnection mc = (JmsManagedConnection)obj;
            JmsManagedConnectionFactory mcf = mc.getManagedConnectionFactory();
            if (mc.getUserName() != null && (mc.getUserName() == null || !mc.getUserName().equals(cred.name)) || !mcf.equals(this)) continue;
            if (info.equals((Object)mc.getInfo())) {
                if (trace) {
                    log.trace((Object)("Found matching connection: " + mc));
                }
                return mc;
            }
            log.trace((Object)("Current info " + info + " don't match : " + mc.getInfo()));
        }
        if (trace) {
            log.trace((Object)"No matching connection was found");
        }
        return null;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof JmsManagedConnectionFactory) {
            return this.mcfProperties.equals(((JmsManagedConnectionFactory)obj).getProperties());
        }
        return false;
    }

    public int hashCode() {
        return this.mcfProperties.hashCode();
    }

    public void setJndiParameters(String jndiParameters) {
        this.mcfProperties.setJndiParameters(jndiParameters);
    }

    public String getJndiParameters() {
        return this.mcfProperties.getJndiParameters();
    }

    public void setConnectionFactory(String connectionFactory) {
        this.mcfProperties.setConnectionFactory(connectionFactory);
    }

    public String getConnectionFactory() {
        return this.mcfProperties.getConnectionFactory();
    }

    public void setUserName(String userName) {
        this.mcfProperties.setUserName(userName);
    }

    public String getUserName() {
        return this.mcfProperties.getUserName();
    }

    public void setPassword(String password) {
        this.mcfProperties.setPassword(password);
    }

    public String getPassword() {
        return Strings.fromCharArray(this.mcfProperties.getPassword());
    }

    public String getClientID() {
        return this.mcfProperties.getClientID();
    }

    public void setClientID(String clientID) {
        this.mcfProperties.setClientID(clientID);
    }

    public Boolean isStrict() {
        return this.strict;
    }

    public void setStrict(Boolean strict) {
        this.strict = strict;
    }

    public Boolean isJMS20() {
        return this.jms_2_0;
    }

    public void setJMS20(Boolean jms_2_0) {
        this.jms_2_0 = jms_2_0;
    }

    public void setSessionDefaultType(String type) throws ResourceException {
        this.mcfProperties.setSessionDefaultType(type);
    }

    public String getSessionDefaultType() {
        return this.mcfProperties.getSessionDefaultType();
    }

    public Integer getUseTryLock() {
        return this.useTryLock;
    }

    public void setUseTryLock(Integer useTryLock) {
        this.useTryLock = useTryLock;
    }

    public void setDeleteTemporaryDestinations(Boolean deleteTemporaryDestinations) {
        this.deleteTemporaryDestinations = deleteTemporaryDestinations;
    }

    public Boolean isDeleteTemporaryDestinations() {
        return this.deleteTemporaryDestinations;
    }

    private ConnectionRequestInfo getInfo(ConnectionRequestInfo info) {
        if (info == null) {
            return new JmsConnectionRequestInfo(this.mcfProperties);
        }
        ((JmsConnectionRequestInfo)info).setDefaults(this.mcfProperties);
        return info;
    }

    public ConnectionMetaData getMetaData() {
        return new JmsConnectionMetaData();
    }

    protected JmsMCFProperties getProperties() {
        return this.mcfProperties;
    }
}

