/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.workmanager.selector;

import jakarta.resource.spi.work.DistributableWork;
import java.util.Map;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.spi.workmanager.Address;
import org.jboss.jca.core.workmanager.selector.AbstractSelector;
import org.jboss.logging.Logger;

public class MaxFreeThreads
extends AbstractSelector {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)MaxFreeThreads.class.getName());

    @Override
    public synchronized Address selectDistributedWorkManager(Address own, DistributableWork work) {
        Map<Address, Long> selectionMap = this.getSelectionMap(own.getWorkManagerId(), work);
        Address result = null;
        long freeThread = 0L;
        if (selectionMap != null) {
            for (Map.Entry<Address, Long> entry : selectionMap.entrySet()) {
                Long free;
                Address id = entry.getKey();
                if (own.equals((Object)id) || (free = entry.getValue()) == null || free <= 0L || free <= freeThread) continue;
                result = id;
                freeThread = free;
            }
        }
        log.tracef("WorkManager: %s (%s)", result, freeThread);
        return result;
    }
}

