/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.distribution;

import org.infinispan.configuration.cache.HashConfiguration;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.SingleSegmentKeyPartitioner;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.wildfly.clustering.infinispan.distribution.KeyGroup;

@DefaultFactoryFor(classes={KeyPartitioner.class})
public class KeyPartitionerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    public Object construct(String componentName) {
        if (!this.configuration.clustering().cacheMode().isClustered() && !this.configuration.persistence().usingSegmentedStore()) {
            return SingleSegmentKeyPartitioner.getInstance();
        }
        HashConfiguration hashConfiguration = this.configuration.clustering().hash();
        final KeyPartitioner partitioner = hashConfiguration.keyPartitioner();
        partitioner.init(hashConfiguration);
        this.basicComponentRegistry.wireDependencies((Object)partitioner, false);
        return new KeyPartitioner(){

            public int getSegment(Object key) {
                return partitioner.getSegment(key instanceof KeyGroup ? ((KeyGroup)key).getId() : key);
            }
        };
    }
}

