/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.openssl;

import java.security.Provider;
import java.security.Security;
import org.wildfly.openssl.OpenSSLContextSPI;

public final class OpenSSLProvider
extends Provider {
    private static boolean registered = false;
    private static final String javaSpecVersion = System.getProperty("java.specification.version");
    public static final OpenSSLProvider INSTANCE = new OpenSSLProvider();

    static int getJavaSpecVersion() {
        if ("1.8".equals(javaSpecVersion)) {
            return 8;
        }
        return Integer.parseInt(javaSpecVersion);
    }

    public OpenSSLProvider() {
        super("openssl", 1.0, "OpenSSL provider");
        this.put("SSLContext.openssl.TLS", OpenSSLContextSPI.class.getName() + "$" + OpenSSLContextSPI.OpenSSLTLSContextSpi.class.getSimpleName());
        this.put("SSLContext.openssl.TLSv1", OpenSSLContextSPI.class.getName() + "$" + OpenSSLContextSPI.OpenSSLTLS_1_0_ContextSpi.class.getSimpleName());
        this.put("SSLContext.openssl.TLSv1.1", OpenSSLContextSPI.class.getName() + "$" + OpenSSLContextSPI.OpenSSLTLS_1_1_ContextSpi.class.getSimpleName());
        this.put("SSLContext.openssl.TLSv1.2", OpenSSLContextSPI.class.getName() + "$" + OpenSSLContextSPI.OpenSSLTLS_1_2_ContextSpi.class.getSimpleName());
        if (OpenSSLProvider.getJavaSpecVersion() >= 11) {
            this.put("SSLContext.openssl.TLSv1.3", OpenSSLContextSPI.class.getName() + "$" + OpenSSLContextSPI.OpenSSLTLS_1_3_ContextSpi.class.getSimpleName());
        }
        this.put("SSLContext.TLS", OpenSSLContextSPI.class.getName() + "$" + OpenSSLContextSPI.OpenSSLTLSContextSpi.class.getSimpleName());
        this.put("SSLContext.TLSv1", OpenSSLContextSPI.class.getName() + "$" + OpenSSLContextSPI.OpenSSLTLS_1_0_ContextSpi.class.getSimpleName());
        this.put("SSLContext.TLSv1.1", OpenSSLContextSPI.class.getName() + "$" + OpenSSLContextSPI.OpenSSLTLS_1_1_ContextSpi.class.getSimpleName());
        this.put("SSLContext.TLSv1.2", OpenSSLContextSPI.class.getName() + "$" + OpenSSLContextSPI.OpenSSLTLS_1_2_ContextSpi.class.getSimpleName());
        if (OpenSSLProvider.getJavaSpecVersion() >= 11) {
            this.put("SSLContext.TLSv1.3", OpenSSLContextSPI.class.getName() + "$" + OpenSSLContextSPI.OpenSSLTLS_1_3_ContextSpi.class.getSimpleName());
        }
    }

    public static synchronized void register() {
        if (!registered) {
            registered = true;
            Security.addProvider(INSTANCE);
        }
    }

    public static synchronized void registerFirst() {
        if (!registered) {
            registered = true;
            Security.insertProviderAt(INSTANCE, 1);
        }
    }
}

