/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.transaction.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.ActiveMQTransactionTimeoutException;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.RefsOperation;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperation;
import org.apache.activemq.artemis.utils.ArtemisCloseable;
import org.jboss.logging.Logger;

public class TransactionImpl
implements Transaction {
    private static final Logger logger = Logger.getLogger(TransactionImpl.class);
    private List<TransactionOperation> operations;
    private List<TransactionOperation> storeOperations;
    private static final int INITIAL_NUM_PROPERTIES = 10;
    private Object[] properties = null;
    protected final StorageManager storageManager;
    private final Xid xid;
    private final long id;
    private volatile Transaction.State state = Transaction.State.ACTIVE;
    private ActiveMQException exception;
    private final Object timeoutLock = new Object();
    private final long createTime;
    private volatile boolean containsPersistent;
    private int timeoutSeconds = -1;
    private Object protocolData;

    private void ensurePropertiesCapacity(int capacity) {
        if (this.properties != null && this.properties.length >= capacity) {
            return;
        }
        this.createOrEnlargeProperties(capacity);
    }

    private void createOrEnlargeProperties(int capacity) {
        if (this.properties == null) {
            this.properties = new Object[Math.min(10, capacity)];
        } else {
            assert (this.properties.length < capacity);
            this.properties = Arrays.copyOf(this.properties, capacity);
        }
    }

    @Override
    public Object getProtocolData() {
        return this.protocolData;
    }

    @Override
    public void setProtocolData(Object protocolData) {
        this.protocolData = protocolData;
    }

    public TransactionImpl(StorageManager storageManager, int timeoutSeconds) {
        this(storageManager.generateID(), null, storageManager, timeoutSeconds);
    }

    public TransactionImpl(StorageManager storageManager) {
        this(storageManager.generateID(), null, storageManager, -1);
    }

    public TransactionImpl(Xid xid, StorageManager storageManager, int timeoutSeconds) {
        this(storageManager.generateID(), xid, storageManager, timeoutSeconds);
    }

    public TransactionImpl(long id, Xid xid, StorageManager storageManager) {
        this(id, xid, storageManager, -1);
    }

    private TransactionImpl(long id, Xid xid, StorageManager storageManager, int timeoutSeconds) {
        this.storageManager = storageManager;
        this.xid = xid;
        this.id = id;
        this.createTime = System.currentTimeMillis();
        this.timeoutSeconds = timeoutSeconds;
    }

    @Override
    public boolean isEffective() {
        return this.state == Transaction.State.PREPARED || this.state == Transaction.State.COMMITTED || this.state == Transaction.State.ROLLEDBACK;
    }

    @Override
    public void setContainsPersistent() {
        this.containsPersistent = true;
    }

    @Override
    public boolean isContainsPersistent() {
        return this.containsPersistent;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeoutSeconds = timeout;
    }

    @Override
    public RefsOperation createRefsOperation(Queue queue, AckReason reason) {
        return new RefsOperation(queue, reason, this.storageManager);
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public long getCreateTime() {
        return this.createTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasTimedOut(long currentTime, int defaultTimeout) {
        Object object = this.timeoutLock;
        synchronized (object) {
            boolean timedout;
            if (this.timeoutSeconds == -1) {
                timedout = this.getState() != Transaction.State.PREPARED && currentTime > this.createTime + (long)defaultTimeout * 1000L;
            } else {
                boolean bl = timedout = this.getState() != Transaction.State.PREPARED && currentTime > this.createTime + (long)this.timeoutSeconds * 1000L;
            }
            if (timedout) {
                this.markAsRollbackOnly((ActiveMQException)new ActiveMQTransactionTimeoutException());
            }
            return timedout;
        }
    }

    @Override
    public boolean hasTimedOut() {
        return this.state == Transaction.State.ROLLBACK_ONLY && this.exception != null && this.exception.getType() == ActiveMQExceptionType.TRANSACTION_TIMEOUT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void prepare() throws Exception {
        Throwable throwable;
        ArtemisCloseable lock;
        block28: {
            block29: {
                block26: {
                    block27: {
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("TransactionImpl::prepare::" + this));
                        }
                        lock = this.storageManager.closeableReadLock();
                        throwable = null;
                        Object object = this.timeoutLock;
                        // MONITORENTER : object
                        if (!this.isEffective()) break block26;
                        logger.debug((Object)("TransactionImpl::prepare::" + this + " is being ignored"));
                        // MONITOREXIT : object
                        if (lock == null) return;
                        if (throwable == null) break block27;
                        try {
                            lock.close();
                            return;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                            return;
                        }
                    }
                    lock.close();
                    return;
                }
                try {
                    if (this.state != Transaction.State.ROLLBACK_ONLY) break block28;
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("TransactionImpl::prepare::rollbackonly, rollingback " + this));
                    }
                    this.internalRollback();
                    if (this.exception != null) {
                        throw this.exception;
                    }
                    // MONITOREXIT : object
                    if (lock == null) return;
                    if (throwable == null) break block29;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                try {
                    lock.close();
                    return;
                }
                catch (Throwable throwable4) {
                    throwable.addSuppressed(throwable4);
                    return;
                }
            }
            lock.close();
            return;
        }
        try {
            if (this.state != Transaction.State.ACTIVE) {
                throw new IllegalStateException("Transaction is in invalid state " + (Object)((Object)this.state));
            }
            if (this.xid == null) {
                throw new IllegalStateException("Cannot prepare non XA transaction");
            }
            this.beforePrepare();
            this.storageManager.prepare(this.id, this.xid);
            this.state = Transaction.State.PREPARED;
            this.storageManager.afterCompleteOperations(new IOCallback(){

                public void onError(int errorCode, String errorMessage) {
                    ActiveMQServerLogger.LOGGER.ioErrorOnTX(errorCode, errorMessage);
                }

                public void done() {
                    TransactionImpl.this.afterPrepare();
                }
            });
            // MONITOREXIT : object
            return;
        }
        catch (Throwable throwable5) {
            throw throwable5;
        }
        finally {
            if (lock != null) {
                if (throwable != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                } else {
                    lock.close();
                }
            }
        }
    }

    @Override
    public void commit() throws Exception {
        this.commit(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(boolean onePhase) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("TransactionImpl::commit::" + this));
        }
        Object object = this.timeoutLock;
        synchronized (object) {
            if (this.state == Transaction.State.COMMITTED) {
                logger.debug((Object)("TransactionImpl::commit::" + this + " is being ignored"));
                return;
            }
            if (this.state == Transaction.State.ROLLBACK_ONLY) {
                this.internalRollback();
                if (this.exception != null) {
                    throw this.exception;
                }
                return;
            }
            if (this.xid != null ? onePhase && this.state != Transaction.State.ACTIVE || !onePhase && this.state != Transaction.State.PREPARED : this.state != Transaction.State.ACTIVE) {
                throw new ActiveMQIllegalStateException("Transaction is in invalid state " + (Object)((Object)this.state));
            }
            this.beforeCommit();
            this.doCommit();
            final List<TransactionOperation> operationsToComplete = this.operations;
            this.operations = null;
            this.storageManager.afterCompleteOperations(new IOCallback(){

                public void onError(int errorCode, String errorMessage) {
                    ActiveMQServerLogger.LOGGER.ioErrorOnTX(errorCode, errorMessage);
                }

                public void done() {
                    TransactionImpl.this.afterCommit(operationsToComplete);
                }
            });
            final List<TransactionOperation> storeOperationsToComplete = this.storeOperations;
            this.storeOperations = null;
            if (storeOperationsToComplete != null) {
                this.storageManager.afterStoreOperations(new IOCallback(){

                    public void onError(int errorCode, String errorMessage) {
                        ActiveMQServerLogger.LOGGER.ioErrorOnTX(errorCode, errorMessage);
                    }

                    public void done() {
                        TransactionImpl.this.afterCommit(storeOperationsToComplete);
                    }
                });
            }
        }
    }

    protected void doCommit() throws Exception {
        if (this.containsPersistent || this.xid != null && this.state == Transaction.State.PREPARED) {
            this.storageManager.commit(this.id);
        }
        this.state = Transaction.State.COMMITTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryRollback() {
        Object object = this.timeoutLock;
        synchronized (object) {
            if (this.state == Transaction.State.ROLLEDBACK) {
                logger.debug((Object)("TransactionImpl::rollbackIfPossible::" + this + " is being ignored"));
                return true;
            }
            if (this.state != Transaction.State.PREPARED) {
                try {
                    this.internalRollback();
                    return true;
                }
                catch (Exception e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("TransactionImpl::rollback::" + this));
        }
        Object object = this.timeoutLock;
        synchronized (object) {
            if (this.state == Transaction.State.ROLLEDBACK) {
                logger.debug((Object)("TransactionImpl::rollback::" + this + " is being ignored"));
                return;
            }
            if (this.xid != null ? this.state != Transaction.State.PREPARED && this.state != Transaction.State.ACTIVE && this.state != Transaction.State.ROLLBACK_ONLY : this.state != Transaction.State.ACTIVE && this.state != Transaction.State.ROLLBACK_ONLY) {
                throw new ActiveMQIllegalStateException("Transaction is in invalid state " + (Object)((Object)this.state));
            }
            this.internalRollback();
        }
    }

    private void internalRollback() throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("TransactionImpl::internalRollback " + this));
        }
        this.beforeRollback();
        try {
            this.doRollback();
            this.state = Transaction.State.ROLLEDBACK;
        }
        catch (IllegalStateException e) {
            ActiveMQServerLogger.LOGGER.failedToPerformRollback(e);
        }
        final List<TransactionOperation> operationsToComplete = this.operations;
        this.operations = null;
        final List<TransactionOperation> storeOperationsToComplete = this.storeOperations;
        this.storeOperations = null;
        this.storageManager.afterCompleteOperations(new IOCallback(){

            public void onError(int errorCode, String errorMessage) {
                ActiveMQServerLogger.LOGGER.ioErrorOnTX(errorCode, errorMessage);
            }

            public void done() {
                TransactionImpl.this.afterRollback(operationsToComplete);
            }
        });
        if (storeOperationsToComplete != null) {
            this.storageManager.afterStoreOperations(new IOCallback(){

                public void onError(int errorCode, String errorMessage) {
                    ActiveMQServerLogger.LOGGER.ioErrorOnTX(errorCode, errorMessage);
                }

                public void done() {
                    TransactionImpl.this.afterRollback(storeOperationsToComplete);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspend() {
        Object object = this.timeoutLock;
        synchronized (object) {
            if (this.state != Transaction.State.ACTIVE) {
                throw new IllegalStateException("Can only suspend active transaction");
            }
            this.state = Transaction.State.SUSPENDED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Object object = this.timeoutLock;
        synchronized (object) {
            if (this.state != Transaction.State.SUSPENDED) {
                throw new IllegalStateException("Can only resume a suspended transaction");
            }
            this.state = Transaction.State.ACTIVE;
        }
    }

    @Override
    public Transaction.State getState() {
        return this.state;
    }

    @Override
    public void setState(Transaction.State state) {
        this.state = state;
    }

    @Override
    public Xid getXid() {
        return this.xid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markAsRollbackOnly(ActiveMQException exception) {
        Object object = this.timeoutLock;
        synchronized (object) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("TransactionImpl::" + this + " marking rollbackOnly for " + exception.toString() + ", msg=" + exception.getMessage()));
            }
            if (this.isEffective()) {
                logger.debug((Object)("Trying to mark transaction " + this.id + " xid=" + this.xid + " as rollbackOnly but it was already effective (prepared, committed or rolledback!)"));
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Marking Transaction " + this.id + " as rollback only"));
            }
            this.state = Transaction.State.ROLLBACK_ONLY;
            this.exception = exception;
        }
    }

    @Override
    public synchronized void addOperation(TransactionOperation operation) {
        this.checkCreateOperations();
        this.operations.add(operation);
    }

    @Override
    public synchronized void afterStore(TransactionOperation sync) {
        if (this.storeOperations == null) {
            this.storeOperations = new LinkedList<TransactionOperation>();
        }
        this.storeOperations.add(sync);
    }

    private int getOperationsCount() {
        this.checkCreateOperations();
        return this.operations.size();
    }

    @Override
    public synchronized List<TransactionOperation> getAllOperations() {
        if (this.operations != null) {
            return new ArrayList<TransactionOperation>(this.operations);
        }
        return new ArrayList<TransactionOperation>();
    }

    @Override
    public void putProperty(int index, Object property) {
        this.ensurePropertiesCapacity(index + 1);
        this.properties[index] = property;
    }

    @Override
    public Object getProperty(int index) {
        return this.properties == null ? null : (index < this.properties.length ? this.properties[index] : null);
    }

    protected void doRollback() throws Exception {
        if (this.containsPersistent || this.xid != null && this.state == Transaction.State.PREPARED) {
            this.storageManager.rollback(this.id);
        }
    }

    private void checkCreateOperations() {
        if (this.operations == null) {
            this.operations = new LinkedList<TransactionOperation>();
        }
    }

    protected synchronized void afterCommit(List<TransactionOperation> operationsToComplete) {
        if (operationsToComplete != null) {
            for (TransactionOperation operation : operationsToComplete) {
                operation.afterCommit(this);
            }
            operationsToComplete.clear();
        }
    }

    private synchronized void afterRollback(List<TransactionOperation> operationsToComplete) {
        if (operationsToComplete != null) {
            for (TransactionOperation operation : operationsToComplete) {
                operation.afterRollback(this);
            }
            operationsToComplete.clear();
        }
    }

    private synchronized void beforeCommit() throws Exception {
        if (this.operations != null) {
            for (TransactionOperation operation : this.operations) {
                operation.beforeCommit(this);
            }
        }
        if (this.storeOperations != null) {
            for (TransactionOperation operation : this.storeOperations) {
                operation.beforeCommit(this);
            }
        }
    }

    private synchronized void beforePrepare() throws Exception {
        if (this.operations != null) {
            for (TransactionOperation operation : this.operations) {
                operation.beforePrepare(this);
            }
        }
        if (this.storeOperations != null) {
            for (TransactionOperation operation : this.storeOperations) {
                operation.beforePrepare(this);
            }
        }
    }

    private synchronized void beforeRollback() throws Exception {
        if (this.operations != null) {
            for (TransactionOperation operation : this.operations) {
                operation.beforeRollback(this);
            }
        }
        if (this.storeOperations != null) {
            for (TransactionOperation operation : this.storeOperations) {
                operation.beforeRollback(this);
            }
        }
    }

    private synchronized void afterPrepare() {
        if (this.operations != null) {
            for (TransactionOperation operation : this.operations) {
                operation.afterPrepare(this);
            }
        }
        if (this.storeOperations != null) {
            for (TransactionOperation operation : this.storeOperations) {
                operation.afterPrepare(this);
            }
        }
    }

    public String toString() {
        Date dt = new Date(this.createTime);
        return "TransactionImpl [xid=" + this.xid + ", txID=" + this.id + ", xid=" + this.xid + ", state=" + (Object)((Object)this.state) + ", createTime=" + this.createTime + "(" + dt + "), timeoutSeconds=" + this.timeoutSeconds + ", nr operations = " + this.getOperationsCount() + "]@" + Integer.toHexString(this.hashCode());
    }
}

