/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.security.AccessController;
import java.security.PrivilegedAction;

class SecuritySPIActions {
    static final PrivilegedAction<ClassLoader> GET_CONTEXT_CLASSLOADER = new PrivilegedAction<ClassLoader>(){

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };

    SecuritySPIActions() {
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(GET_CONTEXT_CLASSLOADER);
        }
        return Thread.currentThread().getContextClassLoader();
    }

    static ClassLoader getCurrentClassLoader(final Class clazz) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return clazz.getClassLoader();
                }
            });
        }
        return clazz.getClassLoader();
    }
}

